package com.xdja.cssp.restful.exception.handler;

import javax.servlet.http.HttpServletResponse;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;

import com.xdja.cssp.restful.auth.exception.AspectException;
import com.xdja.cssp.restful.auth.exception.AuthException;
import com.xdja.cssp.restful.auth.exception.DuplicateRequestException;
import com.xdja.cssp.restful.auth.exception.InvalidAccountException;
import com.xdja.cssp.restful.auth.exception.InvalidCertException;
import com.xdja.cssp.restful.auth.exception.InvalidDateException;
import com.xdja.cssp.restful.auth.exception.InvalidSnException;
import com.xdja.cssp.restful.auth.exception.NotSupportAlgoException;
import com.xdja.cssp.restful.auth.exception.NotSupportSignAlgoException;
import com.xdja.cssp.restful.auth.exception.RemoteInvokeException;
import com.xdja.cssp.restful.auth.exception.RequestTimeoutException;
import com.xdja.cssp.restful.bean.ResponseError;


/**
 * 异常处理类，将实际的异常转换为异常json字符串返回给客户端，
 * 并且根据异常类型返回对应的状态码
 * @author yk
 *
 */
@ControllerAdvice
public class AuthExceptionHandler {

	private Logger logger = LoggerFactory.getLogger(AuthExceptionHandler.class);
	
	/**
	 * 无效的时间异常
	 * @param exception
	 * @return
	 */
	@ExceptionHandler(InvalidDateException.class)
	@ResponseStatus(value = HttpStatus.PRECONDITION_FAILED)
	@ResponseBody
	public Object handleInvalidDate(InvalidDateException exception, HttpServletResponse httpservletResponse) {
		return convertError(exception);
	}
	
	/**
	 * 请求时间戳超时异常
	 * @param exception
	 * @return
	 */
	@ExceptionHandler(RequestTimeoutException.class)
	@ResponseStatus(value = HttpStatus.PRECONDITION_FAILED)
	@ResponseBody
	public Object handleRequestTimeout(RequestTimeoutException exception, HttpServletResponse httpservletResponse) {
		return convertError(exception);
	}
	
	/**
	 * 重复的请求异常
	 * @param exception
	 * @return
	 */
	@ExceptionHandler(DuplicateRequestException.class)
	@ResponseStatus(value = HttpStatus.PRECONDITION_FAILED)
	@ResponseBody
	public Object handleDuplicateRequest(DuplicateRequestException exception, HttpServletResponse httpservletResponse) {
		return convertError(exception);
	}
	
	/**
	 * 不支持的算法异常
	 * @param exception
	 * @return
	 */
	@ExceptionHandler(NotSupportAlgoException.class)
	@ResponseStatus(value = HttpStatus.PRECONDITION_FAILED)
	@ResponseBody
	public Object handleNotSupportAlgo(NotSupportAlgoException exception, HttpServletResponse httpservletResponse) {
		return convertError(exception);
	}
	
	/**
	 * 不支持的签名算法异常
	 * @param exception
	 * @return
	 */
	@ExceptionHandler(NotSupportSignAlgoException.class)
	@ResponseStatus(value = HttpStatus.PRECONDITION_FAILED)
	@ResponseBody
	public Object handleNotSupportSignAlgo(NotSupportSignAlgoException exception, HttpServletResponse httpservletResponse) {
		return convertError(exception);
	}
	
	/**
	 * 无效的sn异常
	 * @param exception
	 * @return
	 */
	@ExceptionHandler(InvalidSnException.class)
	@ResponseStatus(value = HttpStatus.PRECONDITION_FAILED)
	@ResponseBody
	public Object handleInvalidSn(InvalidSnException exception, HttpServletResponse httpservletResponse) {
		return convertError(exception);
	}
	
	/**
	 * 无效的账户异常
	 * @param exception
	 * @return
	 */
	@ExceptionHandler(InvalidAccountException.class)
	@ResponseStatus(value = HttpStatus.PRECONDITION_FAILED)
	@ResponseBody
	public Object handleInvalidAccount(InvalidAccountException exception, HttpServletResponse httpservletResponse) {
		return convertError(exception);
	}
	
	/**
	 * 无效的证书异常
	 * @param exception
	 * @return
	 */
	@ExceptionHandler(InvalidCertException.class)
	@ResponseStatus(value = HttpStatus.PRECONDITION_FAILED)
	@ResponseBody
	public Object handleInvalidCert(InvalidCertException exception, HttpServletResponse httpservletResponse) {
		return convertError(exception);
	}
	
	/**
	 * 远程调用异常
	 * @param exception
	 * @return
	 */
	@ExceptionHandler(RemoteInvokeException.class)
	@ResponseStatus(value = HttpStatus.PRECONDITION_FAILED)
	@ResponseBody
	public Object handleRemoteInvoke(RemoteInvokeException exception, HttpServletResponse httpservletResponse) {
		return convertError(exception);
	}
	
	/**
	 * 异常切面处理异常
	 * @param exception
	 * @return
	 */
	@ExceptionHandler(AspectException.class)
	@ResponseStatus(value = HttpStatus.PRECONDITION_FAILED)
	@ResponseBody
	public Object handleExceptionAspect(AspectException exception, HttpServletResponse httpservletResponse) {
		return convertError(exception);
	}
	
	/**
	 * 转换异常为对应的异常返回对象
	 * @param exception
	 * @return
	 */
	public ResponseError convertError(AuthException exception) {
		ResponseError response = new ResponseError();
		response.setRequestId(exception.getRequestId());
		response.setHostId(exception.getHostId());
		response.setErrCode(exception.getErrCode());
		response.setMessage(exception.getMessage());
		logger.debug("error response:" + response.toString());
		return response;
	}
}
