package com.xdja.cssp.restful.auth.exception;

/**
 * 认证异常基类
 * @author yk
 *
 */
public abstract class AuthException extends RuntimeException {
	
	/**
	 * @Fields serialVersionUID:
	 *
	 */
	private static final long serialVersionUID = 7997287651662552510L;

	//不支持的签名算法
	public static final String NOT_SUPPORT_SIGN_ALGO = "not_support_sign_algo";
	//验证签名异常
	public static final String VERIFY_SIGNATURE_ERROR = "verify_signature_error";
	//不匹配的签名
	public static final String NOT_MATCH_SIGNATURE = "not_match_signature";
	//加密会话密钥失败
	public static final String ENCRYPT_KEY_ERROR = "encrypt_key_error";
	//加密数据失败
	public static final String ENCRYPT_DATA_ERROR = "encrypt_data_error";
	//签名异常
	public static final String SIGN_ERROR = "sign_error";
	//远程调用异常
	public static final String REMOTE_INVOKE_ERROR = "remote_invoke_error";
	//请求超时
	public static final String REQUEST_TIMEOUT = "request_timeout";
	//无效的时间
	public static final String INVALID_DATE = "invalid_date";
	//重复的请求
	public static final String DUPLICATE_REQUEST = "duplicate_request";
	//不支持的算法
	public static final String NOT_SUPPORT_ALGO = "not_support_algo";
	//无效的sn
	public static final String INVALID_SN = "invalid_sn";
	//无效的账户
	public static final String INVALID_ACCOUNT = "invalid_account";
	//无效的证书
	public static final String INVALID_CERT = "invalid_cert";
	//解密会话密钥失败
	public static final String DECRYPT_KEY_ERROR = "decrypt_key_error";
	//解密数据失败
	public static final String DECRYPT_DATA_ERROR = "decrypt_data_error";
	//异常切面处理异常
	public static final String EXCEPTION_HANDLE_ERROR = "exception_handle_error";

	/**
	 * 服务主机标识
	 */
	private String hostId;
	
	/**
	 * 请求id
	 */
	private String requestId;
	
	/**
	 * 错误码
	 */
	private String errCode;
	
	/**
	 * 错误描述
	 */
	private String message;
	
	
	private Throwable cause;
	
	public String getHostId() {
		return hostId;
	}

	public void setHostId(String hostId) {
		this.hostId = hostId;
	}

	public String getRequestId() {
		return requestId;
	}

	public void setRequestId(String requestId) {
		this.requestId = requestId;
	}

	public String getErrCode() {
		return errCode;
	}

	public void setErrCode(String errCode) {
		this.errCode = errCode;
	}

	public String getMessage() {
		return message;
	}

	public void setMessage(String message) {
		this.message = message;
	}
	
	public Throwable getCause() {
		return cause;
	}

	public void setCause(Throwable cause) {
		this.cause = cause;
	}

	public AuthException(String hostId, String requestId,
			String errCode, String message, Throwable cause) {
		super();
		this.hostId = hostId;
		this.requestId = requestId;
		this.errCode = errCode;
		this.message = message;
		this.cause = cause;
	}

	public abstract int getStatus();
}
