package com.xdja.cssp.restful.auth.exception;

import org.springframework.http.HttpStatus;

/**
 * 重复的请求异常
 * @author yk
 *
 */
public class DuplicateRequestException extends AuthException {

	/**
	 * @Fields serialVersionUID:
	 *
	 */
	private static final long serialVersionUID = -8357543192842292982L;
	
	public static final HttpStatus HTTP_STATUS = HttpStatus.PRECONDITION_FAILED;
	
	public DuplicateRequestException(String hostId,
			String requestId, String errCode, String message) {
		this(hostId, requestId, errCode, message, null);
	}
	
	public DuplicateRequestException(String hostId, String requestId,
			String errCode, String message, Throwable cause) {
		super(hostId, requestId, errCode, message, cause);
	}

	@Override
	public int getStatus() {
		return HTTP_STATUS.value();
	}

}
