package com.xdja.cssp.restful.auth.exception;

import org.springframework.http.HttpStatus;

/**
 * 无效的账户异常
 * @author yk
 *
 */
public class InvalidAccountException extends AuthException {

	/**
	 * @Fields serialVersionUID:
	 *
	 */
	private static final long serialVersionUID = 7092971568780572995L;

	public static final HttpStatus HTTP_STATUS = HttpStatus.PRECONDITION_FAILED;
	
	public InvalidAccountException(String hostId,
			String requestId, String errCode, String message) {
		this(hostId, requestId, errCode, message, null);
	}
	
	public InvalidAccountException(String hostId, String requestId, String errCode,
			String message, Throwable cause) {
		super(hostId, requestId, errCode, message, cause);
	}

	@Override
	public int getStatus() {
		return HTTP_STATUS.value();
	}
}
