package com.xdja.cssp.restful.auth.exception;

import org.springframework.http.HttpStatus;

/**
 * 无效的证书异常
 * @author yk
 *
 */
public class InvalidCertException extends AuthException {

	/**
	 * @Fields serialVersionUID:
	 *
	 */
	private static final long serialVersionUID = 5809296437892479327L;

	public static final HttpStatus HTTP_STATUS = HttpStatus.PRECONDITION_FAILED;
	
	public InvalidCertException(String hostId,
			String requestId, String errCode, String message) {
		this(hostId, requestId, errCode, message, null);
	}
	
	public InvalidCertException(String hostId, String requestId, String errCode,
			String message, Throwable cause) {
		super(hostId, requestId, errCode, message, cause);
	}

	@Override
	public int getStatus() {
		return HTTP_STATUS.value();
	}
}
