package com.xdja.cssp.restful.auth.exception;

import org.springframework.http.HttpStatus;

/**
 * 请求超时异常
 * @author yk
 *
 */
public class RequestTimeoutException extends AuthException {

	/**
	 * @Fields serialVersionUID:
	 *
	 */
	private static final long serialVersionUID = -2037093849798700162L;
	
	public static final HttpStatus HTTP_STATUS = HttpStatus.PRECONDITION_FAILED;
	
	public RequestTimeoutException(String hostId,
			String requestId, String errCode, String message) {
		this(hostId, requestId, errCode, message, null);
	}
	
	public RequestTimeoutException(String hostId, String requestId,
			String errCode, String message, Throwable cause) {
		super(hostId, requestId, errCode, message, cause);
	}

	@Override
	public int getStatus() {
		return HTTP_STATUS.value();
	}
}
