package com.xdja.cssp.restful.exception;

import org.springframework.http.HttpStatus;

/**
 * 
 * 
 * Project Name：cssp-restful-exception
 * ClassName：TicketNotAuthException
 * Description：ticket验证未通过异常
 * @author: 谢文超
 * @date: 2015-7-21 上午10:07:18
 * note:
 *
 */
public class TicketNotAuthException extends ApiException {

	/**
	 * 
	 */
	private static final long serialVersionUID = 5828722368805746792L;
	
	public static final HttpStatus HTTP_STATUS = HttpStatus.UNAUTHORIZED;
	
	public TicketNotAuthException(String hostId,
			String requestId, String errCode, String message) {
		this(hostId, requestId, errCode, message, null);
	}
	
	public TicketNotAuthException(String hostId, String requestId, String errCode,
			String message, Throwable cause) {
		super(hostId, requestId, errCode, message, cause);
	}

	@Override
	public int getStatus() {
		return HTTP_STATUS.value();
	}

}
