package com.xdja.cssp.key.server.api;

import com.xdja.cssp.key.server.api.bean.DeviceKuepBean;
import com.xdja.cssp.key.server.api.bean.KuepBean;
import com.xdja.cssp.key.server.api.bean.ResultBean;

/**
 * 
 * Project Name：key-server-api
 * ClassName：IKuepService
 * Description：账户Kuep相关接口
 * @author: 谢文超
 * @date: 2015-7-10 上午9:16:06
 * note:
 * 
 */
public interface IKuepService {
	
	
	/**
	 *uploadKuep接口 处理失败错误码 4-Kuep已存在
	 */
	public static final int UPLOADKUEP_ERROR_KUEP_EXIST = 4;
	
	/**
	 *uploadDeviceKuep接口 处理失败错误码 4-账号Kuep不已存在
	 */
	public static final int UPLOAD_DEVICE_KUEP_ERROR_KUEP_NOT_EXIST = 4;
	
	/**
	 *queryDeviceKuep接口 处理失败错误码 4-账号Kuep不已存在
	 */
	public static final int QUERY_DEVICE_KUEP_ERROR_KUEP_NOT_EXIST = 4;
	
	/**
	 * 
	 * 方法描述：上传Kuep
	 * @author: 谢文超
	 * @date: 2015-7-10 上午11:09:30
	 * @param kuepBean
	 * @return
	 */
	ResultBean uploadKuep(KuepBean kuepBean);

	/**
	 * 
	 * 方法描述：上传单个设备dekuep
	 * @author: 谢文超
	 * @date: 2015-7-10 上午11:16:16
	 */
	ResultBean uploadDeviceKuep(DeviceKuepBean deviceKuepBean);
	/**
	 * 查询指定账号的kuep
	 * 方法描述：
	 * @author: 谢文超
	 * @date: 2015-7-10 上午11:11:55
	 * @param account
	 * @return
	 */
	ResultBean queryKuepubByAccounts(String...account);
	
	/**
	 * 
	 * 方法描述：
	 * @author: 谢文超
	 * @date: 2015-7-10 上午11:22:50
	 * @return
	 */
	ResultBean queryDeviceKuep(DeviceKuepBean deviceKuepBean);
}
