package com.xdja.cssp.key.server.api.bean;

import java.io.Serializable;

/**
 * 
 * Project Name：key-server-api
 * ClassName：ResultBean
 * Description：RPC接口返回参数
 * @author: 谢文超
 * @date: 2015-7-12 上午10:51:16
 * note:
 * 
 */
public class ResultBean implements Serializable {

	/**
	 * 处理结果标识 1-成功
	 */
	public static final int RESULT_SUCCESS = 1;
	
	/**
	 * 处理结果标识 2-参数错误
	 */
	public static final int PARAM_ERROR = 2;
	

	/**
	 * 处理结果标识 3-服务器内部错误
	 */
	public static final int SERVER_ERROR = 3;
	
	/** 
	* @Fields serialVersionUID : TODO
	*/ 
	private static final long serialVersionUID = 2335717123646259964L;

	/**
	 * 处理结果标识：1--成功，其它-失败
	 */
	private int resultFlag = RESULT_SUCCESS;
	
	/**
	 * 错误描述
	 */
	private String msg;
	
	/**
	 * 处理结果
	 */
	private Object result;

	public int getResultFlag() {
		return resultFlag;
	}

	public void setResultFlag(int resultFlag) {
		this.resultFlag = resultFlag;
	}

	public String getMsg() {
		return msg;
	}

	public void setMsg(String msg) {
		this.msg = msg;
	}

	public Object getResult() {
		return result;
	}

	public void setResult(Object result) {
		this.result = result;
	}
	
	
}
