package com.xdja.cssp.key.server.api;

import java.util.List;
import java.util.Map;

import com.xdja.cssp.key.server.api.bean.AccountCertBean;
import com.xdja.cssp.key.server.api.bean.AccountDistinguishCertBean;
import com.xdja.cssp.key.server.api.bean.DeviceKuepBean;
import com.xdja.cssp.key.server.api.bean.KuepBean;
import com.xdja.cssp.key.server.api.bean.KuepubBean;
import com.xdja.cssp.key.server.exception.KuepInitException;
import com.xdja.cssp.key.server.exception.RescourceNotFoundException;
import com.xdja.cssp.key.server.exception.RescourseConfictException;
import com.xdja.cssp.key.server.exception.ServiceException;
import com.xdja.platform.rpc.RemoteService;

/**
 * 
 * Project Name：key-server-api
 * ClassName：IKuepService
 * Description：账户Kuep相关接口
 * @author: 谢文超
 * @date: 2015-7-10 上午9:16:06
 * note:
 * 
 */
@RemoteService(serviceCode = "key")
public interface IKuepService {
	
	/**
	 * 
	 * 方法描述：上传Kuep】
	 * <br>若账号Kuep不存在，保存账号Kuep
	 * <br>若账号Kuep已存在，则直接返回账号对应设备的Kuep
	 * <br>若账号Kuep已存在且账号对应设备的Kuep不存在则抛出ServiceException
	 * @author: 谢文超
	 * @date: 2015-7-10 上午11:09:30
	 * @param kuepBean
	 * @throws IllegalArgumentException 参数非法异常
	 * @throws ServiceException	Kuep已存在异常
	 * @return 保存成功的设备Kuep 
	 */
	DeviceKuepBean uploadKuep(KuepBean kuepBean) throws IllegalArgumentException, RescourseConfictException;

	/**
	 * 
	 * 方法描述：上传单个设备dekuep
	 * @author: 谢文超
	 * @date: 2015-7-10 上午11:16:16
	 * @param deviceKuepBean 
	 * @throws IllegalArgumentException 参数非法异常
	 * @throws RescourseConfictException KuepId与account不匹配
	 */
	void uploadDeviceKuep(DeviceKuepBean deviceKuepBean) throws IllegalArgumentException, RescourseConfictException;
	/**
	 * 查询指定账号的kuep
	 * 方法描述：
	 * @author: 谢文超
	 * @date: 2015-7-10 上午11:11:55
	 * @param accounts 账号列表
	 * @throws IllegalArgumentException 参数非法异常
	 * @return
	 */
	Map<String, KuepubBean> queryKuepubByAccounts(List<String> accounts) throws IllegalArgumentException;
	
	/**
	 * 
	 * 方法描述：查询指定的设备Kuep
	 * @author: 谢文超
	 * @date: 2015-7-10 上午11:22:50
	 * @param deviceKuepBean
	 * @throws IllegalArgumentException 参数非法异常
	 * @throws RescourceNotFoundException 未查询到kuep异常
	 * @return
	 */
	DeviceKuepBean queryDeviceKuep(DeviceKuepBean deviceKuepBean) throws IllegalArgumentException, RescourceNotFoundException;
	
	/**
	 * 
	 * 方法描述：批量检测账号Kuep是否存在
	 * @author: 谢文超
	 * @date: 2015-8-4 上午10:44:09
	 * @param accounts	待检测账号
	 * @return  Map<账号, 检测结果 true-已存在 false-不存在>
	 * @throws IllegalArgumentException 参数非法
	 */
	Map<String/*账号*/, Boolean/*检测结果 true-已存在 false-不存在*/> checkAccoutsKuep(String ... accounts) throws IllegalArgumentException;
	
	/**
	 * 
	 * 方法描述：账号Kuep初始化
	 * @author: 谢文超
	 * @date: 2015-8-20 上午10:47:49
	 * @param list	账号与设备证书列表
	 * @throws IllegalArgumentException 参数异常
	 * <br>KuepInitException  密钥初始化异常
	 */
	void accountKuepInit(List<AccountCertBean> list) throws IllegalArgumentException, KuepInitException;
	
    /**
     * 
     * 方法描述：账号资产识别Kuep初始化
     * @author: 谢文超
     * @date: 2015-8-20 上午10:49:46
     * @param list 账号、待删除账号设备证书列表
     * @throws IllegalArgumentException 参数异常
	 * <br>KuepInitException  密钥初始化异常
     */
	void accountDistinguishKuepInit(List<AccountDistinguishCertBean> list) throws IllegalArgumentException, KuepInitException;
}
