/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.cssp.ams.web.cardactivate.action;

import com.xdja.cssp.ams.cardactivate.bean.ChipBeanCondition;
import com.xdja.cssp.ams.cardactivate.bean.ChipQueryBean;
import com.xdja.cssp.ams.cardactivate.bean.ChipsResultBean;
import com.xdja.cssp.ams.cardactivate.service.IActivateReportService;
import com.xdja.cssp.ams.customer.entity.Customer;
import com.xdja.cssp.ams.customer.entity.Project;
import com.xdja.cssp.ams.customer.service.ICustomerService;
import com.xdja.cssp.ams.web.json.DataTablesParameters;
import com.xdja.cssp.ams.web.util.DataConvertUtil;
import com.xdja.platform.rpc.consumer.refer.DefaultServiceRefer;
import com.xdja.platform.rpc.proxy.page.LitePaging;
import com.xdja.platform.util.DateTimeUtil;
import com.xdja.platform.web.action.BaseAction;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
public class ActiveReportAction
extends BaseAction {
    private ICustomerService customerService = (ICustomerService)DefaultServiceRefer.getServiceRefer(ICustomerService.class);
    private IActivateReportService activateReportService = (IActivateReportService)DefaultServiceRefer.getServiceRefer(IActivateReportService.class);

    @RequestMapping(value={"active/report/index.do"})
    public String index(ModelMap model) {
        List listCustomer = this.customerService.queryAllCustomer();
        model.put((Object)"listCustomer", (Object)listCustomer);
        return "active/report/index";
    }

    @RequestMapping(value={"report/list"})
    public void list(Integer type, Long customerId, Long projectId, Integer year, Long orderId, HttpServletResponse response, ModelMap map) {
        Map chipsStatistics = this.activateReportService.queryChipsActivateStatistics(customerId, Integer.valueOf(type + 1), year, projectId, orderId);
        if (chipsStatistics.size() > 0) {
            this.renderJson(response, this.toJsonStr((Object)chipsStatistics));
        } else {
            this.renderJson(response, this.toJsonStr((Object)"fail"));
        }
    }

    @RequestMapping(value={"active/report/getCustomers.do"})
    public void getCustomers(HttpServletResponse response) {
        List listCustomer = this.customerService.queryAllCustomer();
        ArrayList customerMapList = new ArrayList();
        for (int i = 0; i < listCustomer.size(); ++i) {
            HashMap<String, Object> customerMap = new HashMap<String, Object>();
            customerMap.put("id", ((Customer)listCustomer.get(i)).getId());
            customerMap.put("name", ((Customer)listCustomer.get(i)).getName());
            customerMapList.add(customerMap);
        }
        this.renderJson(response, this.toJsonStr(customerMapList));
    }

    @RequestMapping(value={"active/report/getCustomerProjects.do"})
    public void getCustomerProjects(ModelMap model, String customerId, HttpServletResponse response) {
        Long customerIdLong = null;
        customerIdLong = StringUtils.isBlank((CharSequence)customerId) ? null : Long.valueOf(customerId);
        ArrayList projectMapList = new ArrayList();
        List listProject = this.customerService.queryCustomerProjects(customerIdLong);
        for (int i = 0; i < listProject.size(); ++i) {
            HashMap<String, Object> projectMap = new HashMap<String, Object>();
            projectMap.put("id", ((Project)listProject.get(i)).getId());
            projectMap.put("name", ((Project)listProject.get(i)).getProjectName());
            projectMapList.add(projectMap);
        }
        this.renderJson(response, this.toJsonStr(projectMapList));
    }

    @RequestMapping(value={"active/report/getProjectOrders.do"})
    public void getprojectOrders(ModelMap model, String projectId, HttpServletResponse response) {
        Long projectIdLong = null;
        projectIdLong = StringUtils.isBlank((CharSequence)projectId) ? null : Long.valueOf(projectId);
        List orderMapList = this.customerService.queryProjectOrders(projectIdLong);
        this.renderJson(response, this.toJsonStr((Object)orderMapList));
    }

    @RequestMapping(value={"report/detail.do"})
    public String detail(Integer activateType, ModelMap model) {
        if (null != activateType && activateType == 1) {
            model.addAttribute("activateType", (Object)1);
        } else {
            model.addAttribute("activateType", (Object)2);
        }
        return "active/report/detail";
    }

    @RequestMapping(value={"report/show.do"})
    @ResponseBody
    public Object list(ChipQueryBean chipquerybean, String category, Integer year, Integer type, Integer activateType) {
        long startTime;
        String[] split;
        HashSet<ChipBeanCondition.ENUM_CHIP_STATUS> statusList = new HashSet<ChipBeanCondition.ENUM_CHIP_STATUS>();
        if (activateType == 1) {
            statusList.add(ChipBeanCondition.ENUM_CHIP_STATUS.activate);
        } else if (activateType == 2) {
            statusList.add(ChipBeanCondition.ENUM_CHIP_STATUS.activateParam);
        } else if (activateType == 3) {
            statusList.add(ChipBeanCondition.ENUM_CHIP_STATUS.unActivate);
        } else {
            this.logger.error("\u6fc0\u6d3b\u72b6\u6001\u53c2\u6570\u9519\u8bef");
            throw new RuntimeException("\u6fc0\u6d3b\u72b6\u6001\u53c2\u6570\u9519\u8bef");
        }
        chipquerybean.setActivateStatus(statusList);
        if (type == 0) {
            chipquerybean.setCustomerName(category);
        } else if (type == 3) {
            split = DataConvertUtil.getMouth((Integer)year, (String)category).split(":");
            startTime = DateTimeUtil.getStartTime((String)split[0]);
            chipquerybean.setStartTime(Long.valueOf(startTime));
            chipquerybean.setEndTime(Long.valueOf(startTime + (long)(Integer.parseInt(split[1]) * 24 * 60 * 60) * 1000L - 1L));
        } else if (type == 4) {
            String[] quarter = DataConvertUtil.getQuarter((Integer)year, (String)category).split(":");
            chipquerybean.setStartTime(Long.valueOf(DateTimeUtil.getStartTime((String)quarter[0])));
            chipquerybean.setEndTime(Long.valueOf(DateTimeUtil.getEndTime((String)quarter[1])));
        } else if (type == 5) {
            split = DataConvertUtil.getYear((Integer)Integer.parseInt(category)).split(":");
            startTime = DateTimeUtil.getStartTime((String)split[0]);
            chipquerybean.setStartTime(Long.valueOf(DateTimeUtil.getStartTime((String)split[0])));
            chipquerybean.setEndTime(Long.valueOf(startTime + (long)(Integer.parseInt(split[1]) * 24 * 60 * 60) * 1000L - 1L));
        } else if (type == 1) {
            chipquerybean.setProjectName(category);
        } else if (type == 2) {
            chipquerybean.setOrderName(category);
        }
        DataTablesParameters tables = DataTablesParameters.newInstance();
        int index = (tables.getPage() - 1) * tables.getLength();
        ChipsResultBean queryChips = this.activateReportService.statisticChipsInfo(chipquerybean, index, tables.getLength());
        List chipList = queryChips.getChipList();
        LitePaging bean = new LitePaging();
        bean.setDataList(chipList);
        bean.setTotalCount(Integer.valueOf(Integer.parseInt(queryChips.getTotalCount() + "")));
        return tables.getDataTablesReply(bean);
    }
}

