/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.cssp.ams.web.customer.action;

import com.xdja.cssp.ams.core.util.DicBean;
import com.xdja.cssp.ams.customer.entity.Customer;
import com.xdja.cssp.ams.customer.entity.Project;
import com.xdja.cssp.ams.customer.service.ICustomerService;
import com.xdja.cssp.ams.customer.service.IProjectService;
import com.xdja.cssp.ams.log.entity.SystemLog;
import com.xdja.cssp.ams.system.entity.TUser;
import com.xdja.cssp.ams.web.json.DataTablesParameters;
import com.xdja.cssp.ams.web.system.action.DicInitCache;
import com.xdja.cssp.ams.web.util.Constants;
import com.xdja.cssp.ams.web.util.EncoderUtil;
import com.xdja.platform.log.LoggerExtData;
import com.xdja.platform.rpc.consumer.refer.DefaultServiceRefer;
import com.xdja.platform.rpc.proxy.page.LitePaging;
import com.xdja.platform.security.utils.OperatorUtil;
import com.xdja.platform.web.action.BaseAction;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
public class CustomerMessageAction
extends BaseAction {
    private ICustomerService customerService = (ICustomerService)DefaultServiceRefer.getServiceRefer(ICustomerService.class);
    private IProjectService projectService = (IProjectService)DefaultServiceRefer.getServiceRefer(IProjectService.class);

    @RequestMapping(value={"/customer/message/index.do"})
    public String toIndex(ModelMap model) {
        model.addAttribute("roles", (Object)this.toJsonStr((Object)DicInitCache.getDics((String)"role")));
        model.addAttribute("models", (Object)this.toJsonStr((Object)DicInitCache.getDics((String)"model")));
        model.addAttribute("assetTypeStr", (Object)this.toJsonStr((Object)DicInitCache.getDics((String)"importAssetType")));
        return "customer/message/index";
    }

    @RequestMapping(value={"/customer/message/ajaxList.do"})
    @ResponseBody
    public Object ajaxList(Customer condition) {
        DataTablesParameters tables = DataTablesParameters.newInstance();
        String[] orderColumns = new String[]{"", "", "", "regTime", ""};
        LitePaging pagination = this.customerService.queryCustomers(condition, Integer.valueOf(tables.getPage()), Integer.valueOf(tables.getLength()), tables.getOrderColName(orderColumns), tables.getOrderDir());
        return tables.getDataTablesReply(pagination);
    }

    @RequestMapping(value={"/customer/message/toEditCustomer.do"})
    public String toEditCustomer(Long customerId, ModelMap model) {
        Customer customer = this.customerService.getCustomerById(customerId);
        model.addAttribute("models", (Object)DicInitCache.getDics((String)"model"));
        model.addAttribute("roles", (Object)DicInitCache.getDics((String)"role"));
        Map userServiceMap = DicInitCache.getDics((String)"service");
        model.addAttribute("customer", (Object)customer);
        StringBuilder userServicesCN = new StringBuilder();
        String userServices = customer.getUserService();
        int i = 0;
        if (StringUtils.isNotBlank((CharSequence)userServices)) {
            for (String key : userServiceMap.keySet()) {
                String value = (String)userServiceMap.get(key);
                if (!userServices.contains(key)) continue;
                if (i == 0) {
                    userServicesCN.append(value);
                } else {
                    userServicesCN.append("#" + value);
                }
                ++i;
            }
        }
        model.addAttribute("userServicesCN", (Object)userServicesCN.toString());
        return "customer/message/edit";
    }

    @RequestMapping(value={"/customer/message/toAddCustomer.do"})
    public String toAddCustomer(ModelMap model) {
        model.addAttribute("roles", (Object)DicInitCache.getDics((String)"role"));
        model.addAttribute("models", (Object)DicInitCache.getDics((String)"model"));
        return "customer/message/add";
    }

    @RequestMapping(value={"/customer/message/checkName.do"})
    @ResponseBody
    public Object checkName(String name, Long customerId) {
        try {
            return this.customerService.isNameExsit(customerId, name) ? EncoderUtil.encode((String)"\u5ba2\u6237\u5df2\u5b58\u5728") : "success";
        }
        catch (Exception e) {
            this.logger.error("\u670d\u52a1\u5f02\u5e38", (Throwable)e);
            return EncoderUtil.encode((String)Constants.SERVICE_BREAKE);
        }
    }

    @RequestMapping(value={"/customer/message/saveCustomer.do"})
    public void saveCustomer(HttpServletResponse response, Customer customer) {
        HashMap<String, String> result = new HashMap<String, String>();
        TUser currUser = (TUser)OperatorUtil.getOperator().getCurrUser();
        try {
            LoggerExtData extData = LoggerExtData.create((String)"modelType", (Object)SystemLog.ENUM_LOG_MODEL_TYPE.customerManagerLog.value);
            extData.put("logType", (Object)8);
            extData.put("client", (Object)customer.getName());
            if (null == customer.getId()) {
                customer.setRegTime(Long.valueOf(System.currentTimeMillis()));
                this.customerService.saveCustomer(customer);
                this.logger.info(SystemLog.ENUM_LOG_TYPE.operateLog.value.intValue(), extData, "\u7ba1\u7406\u5458{}\u6dfb\u52a0\u5ba2\u6237{}\u6210\u529f", (Object)currUser.getUserName(), (Object)customer.getName());
            } else {
                this.customerService.saveCustomer(customer);
                this.logger.info(SystemLog.ENUM_LOG_TYPE.operateLog.value.intValue(), extData, "\u7ba1\u7406\u5458{}\u4fee\u6539\u5ba2\u6237{}\u6210\u529f", (Object)currUser.getUserName(), (Object)customer.getName());
            }
            result.put("message", "success");
        }
        catch (Exception e) {
            this.logger.info("\u7ba1\u7406\u5458{}\u4fdd\u5b58\u5ba2\u6237{}\u5931\u8d25", new Object[]{currUser.getName(), customer.getName(), e});
            result.put("message", "\u6267\u884c\u5931\u8d25");
        }
        this.renderJson(response, this.toJsonStr(result));
    }

    @RequestMapping(value={"/customer/message/setUserService.do"})
    public String setUserService(Boolean checkFlag, Boolean showClear, ModelMap model) {
        Map dics = DicInitCache.getDics((String)"service");
        ArrayList<DicBean> dicList = new ArrayList<DicBean>();
        DicBean dic = null;
        for (String key : dics.keySet()) {
            dic = new DicBean();
            dic.setCode(key);
            dic.setName((String)dics.get(key));
            dicList.add(dic);
        }
        model.addAttribute("dicList", dicList);
        return "protected/dicListCheckbox";
    }

    @RequestMapping(value={"/customer/message/getUserService.do"})
    public String getUserService(Long customerId, Boolean checkFlag, Boolean showClear, ModelMap model) {
        ArrayList<DicBean> dicList = new ArrayList<DicBean>();
        Map userServiceMap = DicInitCache.getDics((String)"service");
        Customer customer = this.customerService.getCustomerById(customerId);
        String userServices = customer.getUserService();
        DicBean dic = null;
        for (String key : userServiceMap.keySet()) {
            dic = new DicBean();
            dic.setCode(key);
            String value = (String)userServiceMap.get(key);
            dic.setName(value);
            if (StringUtils.isNotBlank((CharSequence)userServices) && userServices.contains(key)) {
                dic.setChecked(true);
            }
            dicList.add(dic);
        }
        model.addAttribute("dicList", dicList);
        return "protected/dicListCheckbox";
    }

    @RequestMapping(value={"/customer/message/projectList.do"})
    public String projectList(ModelMap modelMap) {
        return "customer/message/project";
    }

    @RequestMapping(value={"/customer/message/ajaxProjectList.do"})
    @ResponseBody
    public Object ajaxProjectList(Long id) {
        DataTablesParameters tables = DataTablesParameters.newInstance();
        String[] orderColumns = new String[]{"", "", "", "", ""};
        Project project = new Project();
        project.setCustomerId(id);
        LitePaging pagination = this.projectService.queryProjects(project, Integer.valueOf(tables.getPage()), Integer.valueOf(tables.getLength()), tables.getOrderColName(orderColumns), tables.getOrderDir());
        return tables.getDataTablesReply(pagination);
    }
}

