/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.cssp.ams.web.customer.action;

import com.xdja.cssp.ams.customer.entity.Order;
import com.xdja.cssp.ams.customer.service.IOrderService;
import com.xdja.cssp.ams.web.json.DataTablesParameters;
import com.xdja.cssp.ams.web.system.action.DicInitCache;
import com.xdja.platform.rpc.consumer.refer.DefaultServiceRefer;
import com.xdja.platform.rpc.proxy.page.LitePaging;
import com.xdja.platform.web.action.BaseAction;
import java.util.HashMap;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
public class CustomerOrderAction
extends BaseAction {
    private IOrderService orderService = (IOrderService)DefaultServiceRefer.getServiceRefer(IOrderService.class);

    @RequestMapping(value={"/customer/order/index.do"})
    public String toIndex(ModelMap model) {
        model.addAttribute("assetTypeStr", (Object)this.toJsonStr((Object)DicInitCache.getDics((String)"assetType")));
        model.addAttribute("activeTypeStr", (Object)this.toJsonStr((Object)DicInitCache.getDics((String)"activeType")));
        model.addAttribute("assetActiveStr", (Object)this.toJsonStr((Object)DicInitCache.getDics((String)"assetActive")));
        model.addAttribute("orderOriginStr", (Object)this.toJsonStr((Object)DicInitCache.getDics((String)"orderOrigin")));
        return "customer/order/index";
    }

    @RequestMapping(value={"/customer/order/ajaxList.do"})
    @ResponseBody
    public Object ajaxList(Order order) {
        DataTablesParameters tables = DataTablesParameters.newInstance();
        String[] orderColumns = new String[]{"", "", "", "", "", "activeType", "activeLicense", "", "", "", "orderTime", ""};
        LitePaging pagination = this.orderService.queryOrders(order, Integer.valueOf(tables.getPage()), Integer.valueOf(tables.getLength()), tables.getOrderColName(orderColumns), tables.getOrderDir());
        return tables.getDataTablesReply(pagination);
    }

    @RequestMapping(value={"/customer/order/detail.do"})
    public String indexDetail(ModelMap modelMap) {
        modelMap.addAttribute("assetTypeStr", (Object)this.toJsonStr((Object)DicInitCache.getDics((String)"assetType")));
        return "customer/order/importInfo";
    }

    @RequestMapping(value={"/customer/order/bakcardDetail.do"})
    public String indexBakcardDetail(ModelMap modelMap) {
        modelMap.addAttribute("assetTypeStr", (Object)this.toJsonStr((Object)DicInitCache.getDics((String)"assetType")));
        return "customer/order/importBakcardInfo";
    }

    @RequestMapping(value={"/customer/order/ajaxDataList.do"})
    @ResponseBody
    public Object ajaxDataList(Order condition) {
        DataTablesParameters tables = DataTablesParameters.newInstance();
        String[] orderColumns = new String[]{"", "", "assetType", "", "", "productionTime", "time"};
        LitePaging pagination = this.orderService.queryAssetDetails(condition, Integer.valueOf(tables.getPage()), Integer.valueOf(tables.getLength()), tables.getOrderColName(orderColumns), tables.getOrderDir());
        return tables.getDataTablesReply(pagination);
    }

    @RequestMapping(value={"/customer/order/ajaxBakcardDataList.do"})
    @ResponseBody
    public Object ajaxBakcardDataList(Order condition) {
        DataTablesParameters tables = DataTablesParameters.newInstance();
        String[] orderColumns = new String[]{"", "", "assetType", "", "", "productionTime", "time"};
        LitePaging pagination = this.orderService.queryBakcardDetails(condition, Integer.valueOf(tables.getPage()), Integer.valueOf(tables.getLength()), tables.getOrderColName(orderColumns), tables.getOrderDir());
        return tables.getDataTablesReply(pagination);
    }

    @RequestMapping(value={"/customer/order/modifyActiveType.do"})
    @ResponseBody
    public Object modifyActiveType(Order condition) {
        HashMap<String, Boolean> modelMap = new HashMap<String, Boolean>();
        boolean result = false;
        result = this.orderService.updateActiveType(condition);
        modelMap.put("success", result);
        return modelMap;
    }

    @RequestMapping(value={"/customer/order/modifyActiveLicense.do"})
    @ResponseBody
    public Object modifyActiveLicense(Order condition) {
        HashMap<String, Boolean> modelMap = new HashMap<String, Boolean>();
        boolean result = false;
        result = this.orderService.updateActiveLicense(condition);
        modelMap.put("success", result);
        return modelMap;
    }
}

