/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.cssp.ams.web.system.action;

import com.xdja.cssp.ams.system.entity.TDic;
import com.xdja.cssp.ams.system.service.IDicService;
import com.xdja.platform.log.Logger;
import com.xdja.platform.log.LoggerFactory;
import com.xdja.platform.rpc.consumer.refer.DefaultServiceRefer;
import com.xdja.platform.util.json.JSONException;
import com.xdja.platform.util.json.JsonMapper;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.PostConstruct;
import org.springframework.stereotype.Component;

/*
 * Exception performing whole class analysis ignored.
 */
@Component
public class DicInitCache {
    public static ConcurrentHashMap<String, Map<String, String>> dicMap = new ConcurrentHashMap();
    private static IDicService dicService = (IDicService)DefaultServiceRefer.getServiceRefer(IDicService.class);
    protected static final transient Logger logger = LoggerFactory.getLogger(DicInitCache.class);

    @PostConstruct
    public static void initDicCache() {
        List dicList = null;
        try {
            dicList = dicService.queryAllTopDicsOrderByparentCode();
        }
        catch (Exception e1) {
            logger.error("\u4eceAMS\u670d\u52a1\u83b7\u53d6\u5b57\u5178\u6570\u636e\u5f02\u5e38", (Throwable)e1);
        }
        if (dicList != null && dicList.size() > 0) {
            LinkedHashMap<String, String> subMap = new LinkedHashMap<String, String>();
            String parentCode = null;
            for (int i = 0; i < dicList.size(); ++i) {
                TDic dic = (TDic)dicList.get(i);
                if (dic.getParentCode().equals("0")) {
                    dicMap.put(dic.getCode(), new LinkedHashMap());
                } else {
                    if (i != 0 && !parentCode.equals("0") && !parentCode.equals(dic.getParentCode())) {
                        LinkedHashMap<String, String> sameParentMap = new LinkedHashMap<String, String>();
                        sameParentMap.putAll(subMap);
                        dicMap.put(parentCode, sameParentMap);
                        subMap.clear();
                    }
                    subMap.put(dic.getCode(), dic.getName());
                    if (i == dicList.size() - 1) {
                        dicMap.put(dic.getParentCode(), subMap);
                    }
                }
                parentCode = dic.getParentCode();
            }
        }
        try {
            logger.info("\u521d\u59cb\u5316\u5b57\u5178\u6570\u636e\u4e3a" + JsonMapper.nonEmptyMapper().toJson((Object)dicMap));
        }
        catch (JSONException e) {
            logger.error("\u521d\u59cb\u5316\u5b57\u5178\u6570\u636e\uff1a{}", (Throwable)e);
        }
    }

    public static Map<String, String> getDics(String parentCode) {
        if (dicMap == null || dicMap.size() == 0) {
            DicInitCache.initDicCache();
        }
        return (Map)dicMap.get(parentCode);
    }

    public static void addDics(String code) {
        dicMap.put(code, new TreeMap());
    }

    public static void addDicItem(String code, String value, String parentCode) {
        Map dicItems = (Map)dicMap.get(parentCode);
        if (dicItems == null) {
            DicInitCache.addDics((String)parentCode);
        }
        dicItems.put(code, value);
        try {
            logger.info("\u521d\u59cb\u5316\u5b57\u5178\u6570\u636e\u4e3a" + JsonMapper.nonEmptyMapper().toJson((Object)dicMap));
        }
        catch (JSONException e) {
            logger.error("\u521d\u59cb\u5316\u5b57\u5178\u6570\u636e\u5f02\u5e38\uff1a{}", (Throwable)e);
        }
    }

    public static void deleteDics(String code) {
        dicMap.remove(code);
    }

    public static void deleteDicItem(String code, String parentCode) {
        Map dicItems = (Map)dicMap.get(parentCode);
        dicItems.remove(code);
    }
}

