/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.cssp.ams.web.system.action;

import com.xdja.cssp.ams.log.entity.SystemLog;
import com.xdja.cssp.ams.system.entity.TUser;
import com.xdja.cssp.ams.system.entity.TUserCert;
import com.xdja.cssp.ams.system.service.IRoleService;
import com.xdja.cssp.ams.system.service.IUserService;
import com.xdja.cssp.ams.web.json.DataTablesParameters;
import com.xdja.cssp.ams.web.util.EncoderUtil;
import com.xdja.platform.log.LoggerExtData;
import com.xdja.platform.rpc.consumer.refer.DefaultServiceRefer;
import com.xdja.platform.rpc.proxy.page.LitePaging;
import com.xdja.platform.security.utils.OperatorUtil;
import com.xdja.platform.security.utils.PasswordUtils;
import com.xdja.platform.web.action.BaseAction;
import java.util.List;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
public class UserManagerAction
extends BaseAction {
    private IUserService userService = (IUserService)DefaultServiceRefer.getServiceRefer(IUserService.class);
    private IRoleService roleService = (IRoleService)DefaultServiceRefer.getServiceRefer(IRoleService.class);

    @RequestMapping(value={"/system/user/index.do"})
    public String index() {
        return "system/user/index";
    }

    @RequestMapping(value={"/system/user/ajaxList.do"})
    @ResponseBody
    public Object ajaxList(TUser condition) {
        DataTablesParameters tables = DataTablesParameters.newInstance();
        String[] orderColumns = new String[]{"", "", "", "createTime"};
        LitePaging pagination = this.userService.queryAllUsers(condition, Integer.valueOf(tables.getPage()), Integer.valueOf(tables.getLength()), tables.getOrderColName(orderColumns), tables.getOrderDir());
        return tables.getDataTablesReply(pagination);
    }

    @RequestMapping(value={"/system/user/checkUserName.do"})
    @ResponseBody
    public Object checkUserName(String userName, Long userId) {
        return this.userService.isNameExist(userName, userId) ? EncoderUtil.encode((String)"\u7528\u6237\u540d\u91cd\u590d") : "success";
    }

    @RequestMapping(value={"/system/user/addUser.do"})
    public String addUser(ModelMap modelMap) {
        List roleList = this.roleService.queryListRoles();
        modelMap.addAttribute("roles", (Object)roleList);
        return "system/user/add";
    }

    @RequestMapping(value={"/system/user/saveUser.do"})
    public void saveUser(TUser user, Long[] roleId, HttpServletResponse response) {
        String message = "success";
        TUser currUser = (TUser)OperatorUtil.getOperator().getCurrUser();
        try {
            this.userService.saveUser(user, roleId);
            LoggerExtData extData = LoggerExtData.create((String)"modelType", (Object)SystemLog.ENUM_LOG_MODEL_TYPE.systemManagerLog.value);
            extData.put("logType", (Object)5);
            extData.put("user", (Object)user.getUserName());
            if (null != user.getId()) {
                this.logger.info(SystemLog.ENUM_LOG_TYPE.operateLog.value.intValue(), extData, "\u7ba1\u7406\u5458{}\u4fee\u6539{}\u7528\u6237\u6210\u529f", (Object)currUser.getUserName(), (Object)user.getUserName());
            } else {
                this.logger.info(SystemLog.ENUM_LOG_TYPE.operateLog.value.intValue(), extData, "\u7ba1\u7406\u5458{}\u6dfb\u52a0{}\u7528\u6237\u6210\u529f", (Object)currUser.getUserName(), (Object)user.getUserName());
            }
        }
        catch (IllegalArgumentException e) {
            message = e.getMessage();
            this.logger.error("\u7528\u6237\u4fdd\u5b58\u65f6\u53c2\u6570\u5f02\u5e38", (Throwable)e);
        }
        catch (Exception e) {
            message = "\u4fdd\u5b58\u7528\u6237\u5931\u8d25";
            this.logger.error("\u4fdd\u5b58\u7528\u6237\u5931\u8d25\uff0c\u5f02\u5e38\u4fe1\u606f\u4e3a", (Throwable)e);
        }
        this.renderText(response, message);
    }

    @RequestMapping(value={"/system/user/editUser.do"})
    public String editUser(Long userId, ModelMap modelMap) {
        TUser user = this.userService.findById(userId);
        List roleList = this.roleService.queryListRolesOrCheck(userId);
        modelMap.put((Object)"user", (Object)user);
        modelMap.addAttribute("roles", (Object)roleList);
        return "system/user/edit";
    }

    @RequestMapping(value={"/system/user/deleteUser.do"})
    public void deleteUser(Long userId, HttpServletResponse response) {
        String message = "success";
        TUser user = this.userService.findById(userId);
        TUser currUser = (TUser)OperatorUtil.getOperator().getCurrUser();
        try {
            this.userService.deleteUser(userId);
            LoggerExtData extData = LoggerExtData.create((String)"modelType", (Object)SystemLog.ENUM_LOG_MODEL_TYPE.systemManagerLog.value);
            extData.put("logType", (Object)5);
            extData.put("user", (Object)user.getUserName());
            this.logger.info(SystemLog.ENUM_LOG_TYPE.operateLog.value.intValue(), extData, "\u7ba1\u7406\u5458{}\u5220\u9664{}\u7528\u6237\u6210\u529f", (Object)currUser.getUserName(), (Object)user.getUserName());
        }
        catch (IllegalArgumentException e) {
            message = e.getMessage();
            this.logger.error("\u7528\u6237\u5220\u9664\u65f6\u53c2\u6570\u5f02\u5e38", (Throwable)e);
        }
        catch (Exception e) {
            message = "\u5220\u9664\u7528\u6237\u5931\u8d25";
            this.logger.error("\u5220\u9664\u7528\u6237\u5931\u8d25\uff0c\u5f02\u5e38\u4fe1\u606f\u4e3a", (Throwable)e);
        }
        this.renderText(response, message);
    }

    @RequestMapping(value={"/system/user/resetPwd.do"})
    public void resetPwd(Long userId, HttpServletResponse response) {
        String message = "success";
        TUser user = this.userService.findById(userId);
        TUser currUser = (TUser)OperatorUtil.getOperator().getCurrUser();
        try {
            this.userService.resetPwd(userId);
            LoggerExtData extData = LoggerExtData.create((String)"modelType", (Object)SystemLog.ENUM_LOG_MODEL_TYPE.systemManagerLog.value);
            extData.put("logType", (Object)5);
            extData.put("user", (Object)user.getUserName());
            this.logger.info(SystemLog.ENUM_LOG_TYPE.operateLog.value.intValue(), extData, "\u7ba1\u7406\u5458{}\u5bf9{}\u7528\u6237\u91cd\u7f6e\u5bc6\u7801\u6210\u529f", (Object)currUser.getUserName(), (Object)user.getUserName());
        }
        catch (IllegalArgumentException e) {
            message = e.getMessage();
            this.logger.error("\u7528\u6237\u91cd\u7f6e\u5bc6\u7801\u65f6\u53c2\u6570\u5f02\u5e38", (Throwable)e);
        }
        catch (Exception e) {
            message = "\u7528\u6237\u91cd\u7f6e\u5bc6\u7801\u5931\u8d25";
            this.logger.error("\u7528\u6237\u91cd\u7f6e\u5bc6\u7801\u5931\u8d25\uff0c\u5f02\u5e38\u4fe1\u606f\u4e3a", (Throwable)e);
        }
        this.renderText(response, message);
    }

    @RequestMapping(value={"/system/user/suspendUser.do"})
    public void suspendUserById(Long userId, HttpServletResponse response) {
        String message = "success";
        TUser user = this.userService.findById(userId);
        TUser currUser = (TUser)OperatorUtil.getOperator().getCurrUser();
        try {
            this.userService.suspendUser(userId);
            LoggerExtData extData = LoggerExtData.create((String)"modelType", (Object)SystemLog.ENUM_LOG_MODEL_TYPE.systemManagerLog.value);
            extData.put("logType", (Object)5);
            extData.put("user", (Object)user.getUserName());
            this.logger.info(SystemLog.ENUM_LOG_TYPE.operateLog.value.intValue(), extData, "\u7ba1\u7406\u5458{}\u6682\u505c{}\u7528\u6237\u6210\u529f", (Object)currUser.getUserName(), (Object)user.getUserName());
        }
        catch (IllegalArgumentException e) {
            message = e.getMessage();
            this.logger.error("\u6682\u505c\u7528\u6237\u65f6\u53c2\u6570\u5f02\u5e38", (Throwable)e);
        }
        catch (Exception e) {
            message = "\u6682\u505c\u7528\u6237\u5931\u8d25";
            this.logger.error("\u6682\u505c\u7528\u6237\u5931\u8d25\uff0c\u5f02\u5e38\u4fe1\u606f\u4e3a", (Throwable)e);
        }
        this.renderText(response, message);
    }

    @RequestMapping(value={"/system/user/startUser.do"})
    public void startUser(Long userId, HttpServletResponse response) {
        String message = "success";
        TUser user = this.userService.findById(userId);
        TUser currUser = (TUser)OperatorUtil.getOperator().getCurrUser();
        try {
            this.userService.startUser(userId);
            LoggerExtData extData = LoggerExtData.create((String)"modelType", (Object)SystemLog.ENUM_LOG_MODEL_TYPE.systemManagerLog.value);
            extData.put("logType", (Object)5);
            extData.put("user", (Object)user.getUserName());
            this.logger.info(SystemLog.ENUM_LOG_TYPE.operateLog.value.intValue(), extData, "\u7ba1\u7406\u5458{}\u542f\u7528{}\u7528\u6237\u6210\u529f", (Object)currUser.getUserName(), (Object)user.getUserName());
        }
        catch (IllegalArgumentException e) {
            message = e.getMessage();
            this.logger.error("\u542f\u7528\u7528\u6237\u65f6\u53c2\u6570\u5f02\u5e38", (Throwable)e);
        }
        catch (Exception e) {
            message = "\u542f\u7528\u7528\u6237\u5931\u8d25";
            this.logger.error("\u542f\u7528\u7528\u6237\u5931\u8d25\uff0c\u5f02\u5e38\u4fe1\u606f\u4e3a", (Throwable)e);
        }
        this.renderText(response, message);
    }

    @RequestMapping(value={"/system/user/bind.do"})
    public String bindUserCard(Long userId, ModelMap modelMap) {
        TUser currentUser = (TUser)OperatorUtil.getOperator().getCurrUser();
        modelMap.put((Object)"userId", (Object)userId);
        modelMap.put((Object)"loginUserCardId", (Object)currentUser.getCardId());
        return "system/user/bind";
    }

    @RequestMapping(value={"/system/user/getCardSn.do"})
    public void getCardSn(String cert, HttpServletResponse response) {
        String result = "";
        try {
            Object[] certArray = this.userService.queryUserCertByCardId(cert);
            result = !((Boolean)certArray[2]).booleanValue() ? "{\"flag\":\"success\",\"sn\":\"" + certArray[1] + "\",\"cardId\":\"" + certArray[0] + "\"}" : "{\"flag\":\"error\", \"message\":\"\u5b89\u5168\u5361\u5df2\u88ab\u4f7f\u7528\"}";
        }
        catch (Exception e) {
            result = "{\"flag\":\"error\", \"message\":\"\u5b89\u5168\u5361\u6821\u9a8c\u5931\u8d25\"}";
            this.logger.error("\u5b89\u5168\u5361\u6821\u9a8c\u65f6\u5f02\u5e38\uff0c\u9519\u8bef\u4fe1\u606f\u4e3a", (Throwable)e);
        }
        this.renderJson(response, result);
    }

    @RequestMapping(value={"/system/user/saveCard.do"})
    public void saveCard(TUserCert userCert, HttpServletResponse response) {
        String message = "success";
        TUser currUser = (TUser)OperatorUtil.getOperator().getCurrUser();
        try {
            this.userService.saveUserCert(userCert);
            TUser user = this.userService.findById(userCert.getUserId());
            LoggerExtData extData = LoggerExtData.create((String)"modelType", (Object)SystemLog.ENUM_LOG_MODEL_TYPE.systemManagerLog.value);
            extData.put("logType", (Object)6);
            extData.put("userType", (Object)"\u7528\u6237");
            extData.put("user", (Object)user.getUserName());
            extData.put("card", (Object)userCert.getCardId());
            this.logger.info(SystemLog.ENUM_LOG_TYPE.operateLog.value.intValue(), extData, "\u7ba1\u7406\u5458{}\u4e3a\u7528\u6237{}\u7ed1\u5b9a\u5b89\u5168\u5361{}\u6210\u529f", new Object[]{currUser.getUserName(), user.getUserName(), userCert.getCardId()});
        }
        catch (IllegalArgumentException e) {
            message = e.getMessage();
            this.logger.error("\u5361\u7ed1\u5b9a\u65f6\uff0c\u53c2\u6570\u5f02\u5e38", (Throwable)e);
        }
        catch (Exception e) {
            message = "\u5361\u7ed1\u5b9a\u5931\u8d25";
            this.logger.error("\u5361\u7ed1\u5b9a\u65f6\u64cd\u4f5c\u65f6\u5f02\u5e38", (Throwable)e);
        }
        this.renderText(response, message);
    }

    @RequestMapping(value={"/system/user/deleteCard.do"})
    public void deleteCard(String userCertId, String userId, HttpServletResponse response) {
        String message = "success";
        TUser currUser = (TUser)OperatorUtil.getOperator().getCurrUser();
        try {
            TUserCert userCert = this.userService.queryUserCertById(Long.valueOf(userCertId));
            this.userService.deleteUserCertById(userCertId);
            TUser user = this.userService.findById(Long.valueOf(userId));
            LoggerExtData extData = LoggerExtData.create((String)"modelType", (Object)SystemLog.ENUM_LOG_MODEL_TYPE.systemManagerLog.value);
            extData.put("logType", (Object)6);
            extData.put("userType", (Object)"\u7528\u6237");
            extData.put("user", (Object)user.getUserName());
            extData.put("card", (Object)userCert.getCardId());
            this.logger.info(SystemLog.ENUM_LOG_TYPE.operateLog.value.intValue(), extData, "\u7ba1\u7406\u5458{}\u4e3a\u7528\u6237{}\u64a4\u9500\u5b89\u5168\u5361{}\u6210\u529f", new Object[]{currUser.getUserName(), user.getUserName(), userCert.getCardId()});
        }
        catch (IllegalArgumentException e) {
            message = e.getMessage();
            this.logger.error("\u64a4\u9500\u7528\u6237\u7ed1\u5b9a\u5361\u65f6\uff0c\u53c2\u6570\u5f02\u5e38", (Throwable)e);
        }
        catch (Exception e) {
            message = "\u64a4\u9500\u5361\u7ed1\u5b9a\u5931\u8d25";
            this.logger.error("\u5361\u7ed1\u5b9a\u65f6\u64cd\u4f5c\u65f6\u5f02\u5e38", (Throwable)e);
        }
        this.renderText(response, message);
    }

    @RequestMapping(value={"/system/user/ajaxCardList.do"})
    @ResponseBody
    public Object ajaxCardList(String userId) {
        DataTablesParameters tables = DataTablesParameters.newInstance();
        String[] orderColumns = new String[]{"", "cardId", "note"};
        LitePaging pagination = this.userService.queryAllUserCert(userId, Integer.valueOf(tables.getPage()), Integer.valueOf(tables.getLength()), tables.getOrderColName(orderColumns), tables.getOrderDir());
        return tables.getDataTablesReply(pagination);
    }

    @RequestMapping(value={"/toModifyPassword.do"})
    public String toModifyPassword() {
        return "modify-pwd";
    }

    @RequestMapping(value={"/modifyPassword.do"})
    @ResponseBody
    public Object modifyPassword(String oldPasswd, String newPasswd, String verifyPasswd) {
        TUser user = (TUser)OperatorUtil.getOperator().getCurrUser();
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{oldPasswd}) && StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{newPasswd}) && StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{verifyPasswd})) {
            if (PasswordUtils.encodePasswordSHA1((String)oldPasswd).equals(user.getPassword()) && newPasswd.equals(verifyPasswd)) {
                user.setPassword(PasswordUtils.encodePasswordSHA1((String)newPasswd));
                this.userService.updateUser(user);
                LoggerExtData extData = LoggerExtData.create((String)"modelType", (Object)SystemLog.ENUM_LOG_MODEL_TYPE.systemManagerLog.value);
                extData.put("logType", (Object)3);
                this.logger.info(SystemLog.ENUM_LOG_TYPE.operateLog.value.intValue(), extData, "\u7ba1\u7406\u5458{}\u4fee\u6539\u5bc6\u7801\u6210\u529f", (Object)user.getUserName());
                return "success";
            }
            return EncoderUtil.encode((String)"\u65e7\u5bc6\u7801\u8f93\u5165\u9519\u8bef\uff01");
        }
        return EncoderUtil.encode((String)"\u8f93\u5165\u53c2\u6570\u5f02\u5e38");
    }
}

