<#--
	名称：快速日期查询区域标签
	作者：任瑞修
	时间：2012-07-20 15:00:20
	描述：显示快速日期查询区
	参数：
-->
<#macro dateQuery>
	<div class="toolBar">
		<table cellpadding="0" cellspacing="0" border="0" class="toolBarTable">
			<tr>
				<td class="toolBarTd" style="border:0px; padding: 0px 0px;">
					<div class="colorDiv">
						<div id="1_btn" class="divBtn divBtnCurr query" data="1" unit="day">今天</div>
						<div id="2_btn" class="divBtn query" data="3" unit="day">近三天</div>
						<div id="3_btn" class="divBtn query" data="1" unit="week">近一周</div>
						<div id="4_btn" class="divBtn query" data="1" unit="month">近一个月</div>
						<div id="5_btn" class="divBtn custom" tip="只能查询最近一个月的数据">自定义</div>
						<#nested />
					</div>
				</td>
			</tr>
			<tr id="customDate" style="display:none;">
				<td class="toolBarTd" style="border:0px; padding: 0px 4px;">
					<table class="queryTable">
						<tr>
							<td class="queryLabel">开始时间</td>
							<td>
								<#local required=false>
								<#local showTime=false>
								<#local name="startTime">
								<#local value=queryBean.startTime!>
								<#local maxDate="#F{$dp.$D(\\'endTime\\')||\\'%y-%M-%d\\'}">
								<#local minDate="#F{$dp.$DV(\\'%y-%M-%d\\',{M:-1})}">
								<#include "dateInput.ftl"><#t/>
							</td>
							<td class="queryLabel">结束时间</td>
							<td>
								<#local name="endTime">
								<#local value=queryBean.endTime!>
								<#local maxDate="%y-%M-%d">
								<#local minDate="#F{$dp.$D(\\'startTime\\')||$dp.$DV(\\'%y-%M-%d\\',{M:-1})}">
								<#include "dateInput.ftl"><#t/>
							</td>
							<td style="padding-left:10px;"><input id="dateQueryBtn" class="btn btnQuery" type="submit" value="查询" /></td>
						</tr>
					</table>
				</td>
			</tr>
		</table>
	</div>
	<input id="btnId" name="btnId" value="${queryBean.btnId!}" type="hidden" />
	<input id="dateData" name="dateData" value="${queryBean.dateData!1}" type="hidden" />
	<input id="dateUnit" name="dateUnit" value="${queryBean.dateUnit!'day'}" type="hidden" />
	<script type="text/javascript">
		$(function(){
			$("div.divBtn").click(function(){
				var self = $(this);
				if(!self.hasClass("divBtnCurr")) {
					$("div.divBtn").removeClass("divBtnCurr");
					self.addClass("divBtnCurr");
				}
				$("#btnId").val(self.attr("id"));
				$("#dateData").val(self.attr("data"));
				$("#dateUnit").val(self.attr("unit"));
				if(self.hasClass("custom")) {
					if($("#customDate").css("display") == "none") {
						$("#customDate").css("display", "block");
					} else {
						$("#customDate").css("display", "none");
					}
				} else if(self.hasClass("query")) {
					$("#startTime").val("");
					$("#endTime").val("");
					$("#dateQueryBtn").trigger("click");
					$("#customDate").css("display", "none");
				}
				layout();
			});
			<#if queryBean.btnId! != "">
				$(".divBtnCurr").removeClass("divBtnCurr");
				$("#${queryBean.btnId}").addClass("divBtnCurr");
			</#if>
			
			$("#dateQueryBtn").click(function() {
				if(window.refresh) {
					window.refresh();
					return false;
				}
			});
		});
	</script>
</#macro>