(function($){
  var settings = [], popups=[],
  //default setting of core
  _setting = {
    popupId: "",
    popupObj: null,
    url: "",
    height: 200,
    width: null,
    popupDiv : null,
    contentFrame : null,
    valueEle: null,
    onChange: null
  },
  tools = {
    clone: function (jsonObj) {
      var buf;
      if (jsonObj instanceof Array) {
        buf = [];
        var i = jsonObj.length;
        while (i--) {
          buf[i] = arguments.callee(jsonObj[i]);
        }
        return buf;
      }else if (typeof jsonObj == "function"){
        return jsonObj;
      }else if (jsonObj instanceof Object){
        buf = {};
        for (var k in jsonObj) {
          buf[k] = arguments.callee(jsonObj[k]);
        }
        return buf;
      }else{
        return jsonObj;
      }
    } 
  },
  core = {
    showPopupDiv : function(setting) {
	  if(!setting.popupDiv.attr("id")) {
		setting.popupDiv.attr("id", "popup_" + setting.popupId);
        setting.contentFrame.attr("id", "contentFrame_" + setting.popupId);

        setting.contentFrame.css("height", setting.popupDiv.innerHeight());
        setting.contentFrame.css("width", setting.popupDiv.innerWidth());
        if(setting.url != "") {
		  setTimeout(function(){
			setting.contentFrame.attr("src", setting.url);
		  },1);
		}
      }
      
      var textHeight = setting.wrapper.height();
	  var wrapTop = setting.wrapper.offset().top;
	  var wrapLeft = setting.wrapper.offset().left;
	  var selfheight = setting.popupDiv.height();	  
	  setting.popupDiv.css("left", wrapLeft);
	  if(wrapTop + (selfheight + textHeight) > $(window).height() && wrapTop > (selfheight + textHeight)) {
		setting.popupDiv.css("top", wrapTop - 2 - selfheight);
	  } else {
		setting.popupDiv.css("top", wrapTop + textHeight);
	  }
      
      setting.popupDiv.show();
    },
    
    movePopupDiv : function(setting) {
      if(setting.popupDiv.css("display") == "block") {
	      var textHeight = setting.wrapper.height();
	  	  var wrapTop = setting.wrapper.offset().top;
	  	  var wrapLeft = setting.wrapper.offset().left;
	  	  var selfheight = setting.popupDiv.height();	  
	  	  setting.popupDiv.css("left", wrapLeft);
	  	  if(wrapTop + (selfheight + textHeight) > $(window).height() && wrapTop > (selfheight + textHeight)) {
	  		setting.popupDiv.css("top", wrapTop - 2 - selfheight);
	  	  } else {
	  		setting.popupDiv.css("top", wrapTop + textHeight);
	  	  }
      }
    },
    
    hidePopupDiv : function(setting) {
      setting.popupDiv.hide();
    }
  };
  $.fn.popup = {
    setSelected : function(popupId, value, lable, visible) {
      settings[popupId].valueEle.val(value);
      settings[popupId].popupObj.val(lable);
      if(!visible) {
        settings[popupId].popupDiv.hide();
      }
      if(settings[popupId].onChange) {
    	  settings[popupId].onChange.call(window, value);
      }
    },
    refresh : function(popupId, url){
      url = url || settings[popupId].url;
      if(settings[popupId].popupDiv.attr("id")) {
	    settings[popupId].contentFrame[0].contentWindow.document.location.replace(url);
	    } else {
	    settings[popupId].url = url;
	    }
    },
    setDisabled : function(popupId, disabled) {
		settings[popupId].popupObj.attr("disabled", disabled);
		if(disabled) {
			settings[popupId].wrapper.append(settings[popupId].linkDisabled);
		} else {
			settings[popupId].linkDisabled.remove();
		}
    },
    hidePopup : function(id) {
      settings[id].popupDiv.hide();
    },
    init: function(obj, zSetting) {
      var setting = tools.clone(_setting);
      $.extend(true, setting, zSetting);
      setting.popupId = obj.attr("id");
      setting.popupObj = obj;
      setting.popupObj.empty();
      settings[setting.popupId] = setting;
      obj.click(function() {
        core.showPopupDiv(setting);
      });
      
      //开关
      setting.link = $('<div class="dropDown-trigger"><div class="dropDown-trigger-icon"></div></div>').hover(function() {
          this.className = "dropDown-trigger-hover";
      }, function() {
          this.className = "dropDown-trigger";
      }).mousedown(function() {
          this.className = "dropDown-trigger-pressed";
      }).mouseup(function() {
          this.className = "dropDown-trigger-hover";
      }).click(function() {
        core.showPopupDiv(setting);
      });
      
      setting.linkDisabled = $('<div class="dropDown-trigger dropDown-trigger-disabled"><div class="dropDown-trigger-disabled-icon"></div></div>');
      
      if(setting.width) obj.css("width", setting.width);
      //外层
      var textDiv = $('<div class="l-text l-text-combobox"></div>').css("width", setting.width || obj.outerWidth());
      setting.wrapper = obj.wrap(textDiv).parent();
      setting.wrapper.append('<div class="l-text-l"></div><div class="l-text-r"></div>');

      setting.popupDiv = $("<div style='display:none;' class='popupDiv'></div>").appendTo($(document.body));
      setting.wrapper.append(setting.link);
        
      if(setting.url != "") {
    	setting.contentFrame = $("<iframe src='about:blank' class='contentFrame' style='display:none;' frameborder='0'></iframe>");
		setting.contentFrame.bind("load", function(){
	    var self = $(this);
		  self.css("display", "block");
	    });
	    setting.contentFrame[0].win = window;
	    setting.contentFrame[0].popupId = setting.popupId;
	  } else {
		setting.contentFrame.css("display", "");
	  }
	  
      setting.popupDiv.height(setting.height);
      setting.popupDiv.width(setting.width || textDiv.css("width"));

      obj.addClass("l-text-field");
      obj.width(obj.outerWidth() - 17);

      setting.popupDiv.append(setting.contentFrame);

      $(document.body).bind("mousedown", function(event){
        var event = window.event || event;
        var elm = event.srcElement || event.target;
        
		for(var key in settings) {
		  var canHide = true;
		  $(elm).parentsUntil().each(function() {
			  if(this.id == ("popup_" + key)) {
				  canHide = false;
				  return;
			  }
		  });
		  if(elm.id != key && canHide) {
			core.hidePopupDiv(settings[key]);
		  }
		}
      });
      $("#l_center").scroll(function() {
    	  core.movePopupDiv(setting);
      });
    }
  };
})(jQuery);

function setSelected(popupId, value, label, visible) {
  $.fn.popup.setSelected(popupId, value, label, visible);
  $("#"+popupId).blur();
}

function setSelectedBlur(popupId, value, label, visible) {
  $.fn.popup.setSelected(popupId, value, label, visible);
}