/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.cssp.ams.web.asset.action;

import com.xdja.cssp.ams.assetmanager.entity.AssetImportMsg;
import com.xdja.cssp.ams.assetmanager.entity.ImportResultBean;
import com.xdja.cssp.ams.assetmanager.service.IAssetManagerService;
import com.xdja.cssp.ams.customer.entity.Customer;
import com.xdja.cssp.ams.customer.service.ICustomerService;
import com.xdja.cssp.ams.log.entity.SystemLog;
import com.xdja.cssp.ams.system.entity.TUser;
import com.xdja.cssp.ams.web.system.action.DicInitCache;
import com.xdja.cssp.ams.web.util.Constants;
import com.xdja.cssp.ams.web.util.ExcelResolveUtil;
import com.xdja.cssp.ams.web.util.ExcelUtil;
import com.xdja.cssp.ams.web.util.ResolveCert;
import com.xdja.platform.log.LoggerExtData;
import com.xdja.platform.rpc.consumer.refer.DefaultServiceRefer;
import com.xdja.platform.security.utils.OperatorUtil;
import com.xdja.platform.web.action.BaseAction;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RequestPart;
import org.springframework.web.multipart.MultipartFile;

@Controller
public class AssetImportAction
extends BaseAction {
    private IAssetManagerService assetService = (IAssetManagerService)DefaultServiceRefer.getServiceRefer(IAssetManagerService.class);
    private ICustomerService customerService = (ICustomerService)DefaultServiceRefer.getServiceRefer(ICustomerService.class);

    @RequestMapping(value={"/asset/import/index.do"})
    public String index(ModelMap model) {
        HashMap<String, String> customers = new HashMap<String, String>();
        for (Customer item : this.customerService.getAllCustomer()) {
            customers.put(String.valueOf(item.getId()), item.getName());
        }
        model.addAttribute("customers", customers);
        model.addAttribute("assetTypes", (Object)DicInitCache.getDics((String)"importAssetType"));
        return "asset/import/assetImport";
    }

    @RequestMapping(value={"/asset/import/import.do"}, method={RequestMethod.POST})
    public void downloadTemplate(@RequestParam(required=false) @RequestPart MultipartFile file, int type, HttpServletRequest request, HttpServletResponse response) {
        HashMap<String, Object> result;
        block10: {
            boolean status = false;
            TUser user = (TUser)OperatorUtil.getOperator().getCurrUser();
            result = new HashMap<String, Object>();
            result.put("success", false);
            Map assetTypes = DicInitCache.getDics((String)"importAssetType");
            try {
                response.setCharacterEncoding("UTF-8");
                request.setCharacterEncoding("UTF-8");
                if (file.isEmpty()) {
                    result.put("message", "\u8bf7\u5148\u9009\u62e9\u6587\u4ef6");
                    this.logger.error("\u8bf7\u9009\u62e9\u6587\u4ef6");
                    this.renderText(response, this.toJsonStr(result));
                    return;
                }
                System.out.println(file.getOriginalFilename());
                if (!file.getOriginalFilename().endsWith(Constants.getImportFileSuffix((int)type))) {
                    result.put("message", "\u9009\u62e9\u7684\u6587\u4ef6\u683c\u5f0f\u4e0d\u7b26\uff0c\u8bf7\u5148\u4e0b\u8f7d\u6a21\u677f\uff0c\u6309\u7167\u6a21\u677f\u4e2d\u7684\u683c\u5f0f\u8fdb\u884c\u4e0a\u4f20");
                    this.logger.error("\u9009\u62e9\u7684\u6587\u4ef6\u683c\u5f0f\u4e0d\u7b26\uff0c\u8bf7\u5148\u4e0b\u8f7d\u6a21\u677f\uff0c\u6309\u7167\u6a21\u677f\u4e2d\u7684\u683c\u5f0f\u8fdb\u884c\u4e0a\u4f20");
                    this.renderText(response, this.toJsonStr(result));
                    return;
                }
                if (type == 7 && file.getSize() > 0x500000L) {
                    result.put("message", "\u9009\u62e9\u7684\u6587\u4ef6\u5927\u5c0f\u6700\u5927\u5141\u8bb85M");
                    this.logger.error("\u9009\u62e9\u7684\u6587\u4ef6\u5927\u5c0f\u8d85\u8fc7\u6700\u5927\u9650\u52365M");
                    this.renderText(response, this.toJsonStr(result));
                    return;
                }
                String failFileName = String.valueOf(System.nanoTime()) + ".xls";
                ImportResultBean resultBean = this.resolve(type, status, file.getInputStream(), failFileName, result);
                if (null == resultBean) break block10;
                if (resultBean.getFailCount() > 0) {
                    String path = Constants.getImportFailFilePath() + failFileName;
                    try {
                        this.createAssetFailMsgExcel(path, resultBean.getFailCardsMsg());
                        result.put("failFileName", failFileName);
                    }
                    catch (Exception e) {
                        result.put("failFileName", "");
                    }
                }
                result.put("total", resultBean.getSucessCount() + resultBean.getFailCount());
                result.put("successCount", resultBean.getSucessCount());
                result.put("failCount", resultBean.getFailCount());
                Integer[] detail = (Integer[])resultBean.getDetail();
                if (type != 7) {
                    result.put("requiredFailure", detail[0]);
                    result.put("repetitionFailure", detail[1]);
                    result.put("repetitionDataFail", detail[2]);
                    result.put("unExistsChipFail", detail[3]);
                    result.put("templetIllegalFail", detail[4]);
                    result.put("unExistsCertFail", detail[5]);
                    result.put("orderExceptionFail", detail[6]);
                    result.put("algorithmFail", detail[7]);
                } else {
                    result.put("repetitionFail", detail[0]);
                    result.put("repetitionDataFail", detail[1]);
                    result.put("numberFail", detail[2]);
                    result.put("algorithmFail", detail[3]);
                    result.put("certChangeFail", detail[4]);
                }
                result.put("success", true);
                LoggerExtData extData = LoggerExtData.create((String)"modelType", (Object)SystemLog.ENUM_LOG_MODEL_TYPE.assetManagerLog.value);
                extData.put("logType", (Object)10);
                this.logger.info(SystemLog.ENUM_LOG_TYPE.operateLog.value.intValue(), extData, "\u7ba1\u7406\u5458\u3010{}\u3011\u5bfc\u5165\u3010{}\u3011 \u6570\u636e\u6210\u529f\uff0c\u6587\u4ef6\u540d\u79f0\uff1a{}\uff0c\u6587\u4ef6\u5927\u5c0f\uff1a{} b\uff0c\u6570\u636e\u603b\u6761\u6570\uff1a{}\uff0c\u6210\u529f\uff1a{}\uff0c\u5931\u8d25\uff1a{}", new Object[]{user.getUserName(), assetTypes.get(String.valueOf(type)), file.getOriginalFilename(), file.getSize(), result.get("total"), result.get("successCount"), result.get("failCount")});
            }
            catch (Exception e) {
                result.put("message", "\u5bfc\u5165\u6587\u4ef6\u5931\u8d25\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
                this.logger.error("\u5bfc\u5165\u6587\u4ef6\u5f02\u5e38", (Throwable)e);
            }
        }
        this.renderText(response, this.toJsonStr(result));
    }

    private ImportResultBean resolve(int type, boolean status, InputStream in, String failureName, Map<String, Object> result) throws Exception {
        ExcelResolveUtil resolve = null;
        switch (type) {
            case 1: 
            case 2: {
                resolve = new ExcelResolveUtil(in, 0, 8);
                List mobiles = resolve.getDatasInSheet();
                if (null == mobiles || mobiles.isEmpty()) {
                    result.put("message", "\u6587\u4ef6\u4e0d\u5305\u542b\u6570\u636e\u6216\u5927\u4e8e20000\u6761");
                    return null;
                }
                return this.assetService.importAsset(mobiles, failureName, type, status);
            }
            case 4: 
            case 5: 
            case 10: {
                resolve = new ExcelResolveUtil(in, 0, 3);
                List assets = resolve.getDatasInSheet();
                if (null == assets || assets.isEmpty()) {
                    result.put("message", "\u6587\u4ef6\u4e0d\u5305\u542b\u6570\u636e\u6216\u5927\u4e8e20000\u6761");
                    return null;
                }
                return this.assetService.importAsset(assets, failureName, type, status);
            }
            case 6: {
                resolve = new ExcelResolveUtil(in, 0, 9);
                List chips = resolve.getDatasInSheet();
                if (null == chips || chips.isEmpty()) {
                    result.put("message", "\u6587\u4ef6\u4e0d\u5305\u542b\u6570\u636e\u6216\u5927\u4e8e20000\u6761");
                    return null;
                }
                return this.assetService.importAsset(chips, failureName, type, status);
            }
            case 7: {
                ResolveCert resolveCert = new ResolveCert();
                resolveCert.resolve(in);
                Map certs = resolveCert.getDatas();
                if (null == certs || certs.size() > 1000) {
                    result.put("message", "\u6587\u4ef6\u4e0d\u5305\u542b\u6570\u636e\u6216\u5927\u4e8e1000\u6761");
                    return null;
                }
                return this.assetService.importCert(certs, failureName, type, status);
            }
            case 8: {
                resolve = new ExcelResolveUtil(in, 0, 4);
                List unLocks = resolve.getDatasInSheet();
                if (null == unLocks || unLocks.isEmpty()) {
                    result.put("message", "\u6587\u4ef6\u4e0d\u5305\u542b\u6570\u636e\u6216\u5927\u4e8e20000\u6761");
                    return null;
                }
                return this.assetService.importAsset(unLocks, failureName, type, status);
            }
            case 9: {
                resolve = new ExcelResolveUtil(in, 0, 11);
                List bakcards = resolve.getDatasInSheet();
                if (null == bakcards || bakcards.isEmpty()) {
                    result.put("message", "\u6587\u4ef6\u4e0d\u5305\u542b\u6570\u636e\u6216\u5927\u4e8e20000\u6761");
                    return null;
                }
                return this.assetService.importAsset(bakcards, failureName, type, status);
            }
        }
        result.put("message", "\u4e0d\u652f\u6301\u7684\u5bfc\u5165\u7c7b\u578b");
        return null;
    }

    private void createAssetFailMsgExcel(String fileName, List<AssetImportMsg> failCardsMsg) throws Exception {
        File newFile = new File(fileName);
        try {
            FileOutputStream out = new FileOutputStream(newFile);
            ExcelUtil.getExcel((OutputStream)out, (String)"\u5bfc\u5165\u5931\u8d25\u7ed3\u679c", (String)"\u5bfc\u5165\u5931\u8d25\u7ed3\u679c", failCardsMsg);
        }
        catch (Exception e) {
            this.logger.error("\u5199\u5165\u5931\u8d25\u6587\u4ef6\u5f02\u5e38", (Throwable)e);
            throw e;
        }
    }
}

