/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.cssp.ams.web.asset.action;

import com.xdja.cssp.ams.assetmanager.entity.TLoadRecord;
import com.xdja.cssp.ams.assetmanager.service.ILoadRecordManagerService;
import com.xdja.cssp.ams.core.util.DateQueryBean;
import com.xdja.cssp.ams.log.entity.SystemLog;
import com.xdja.cssp.ams.system.entity.TUser;
import com.xdja.cssp.ams.web.json.DataTablesParameters;
import com.xdja.cssp.ams.web.system.action.DicInitCache;
import com.xdja.cssp.ams.web.util.Constants;
import com.xdja.platform.log.LoggerExtData;
import com.xdja.platform.rpc.consumer.refer.DefaultServiceRefer;
import com.xdja.platform.rpc.proxy.page.LitePaging;
import com.xdja.platform.security.utils.OperatorUtil;
import com.xdja.platform.web.action.BaseAction;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URLEncoder;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
public class LoadRecordManagerAction
extends BaseAction {
    ILoadRecordManagerService loadRecordManagerService = (ILoadRecordManagerService)DefaultServiceRefer.getServiceRefer(ILoadRecordManagerService.class);

    @RequestMapping(value={"/asset/load/index.do"})
    public String index(ModelMap modelMap) {
        modelMap.addAttribute("assetTypeStr", (Object)this.toJsonStr((Object)DicInitCache.getDics((String)"importAssetType")));
        modelMap.addAttribute("revokeStatusStr", (Object)this.toJsonStr((Object)DicInitCache.getDics((String)"revokeStatus")));
        modelMap.addAttribute("nativateStatusStr", (Object)this.toJsonStr((Object)DicInitCache.getDics((String)"nativateStatus")));
        modelMap.addAttribute("currentTime", (Object)System.currentTimeMillis());
        modelMap.addAttribute("revokeShowDay", (Object)Constants.REVOKE_SHOW_DAY);
        modelMap.addAttribute("isAllowRevoke", (Object)Constants.IS_ALLOW_REVOKE);
        return "asset/recordManage";
    }

    @RequestMapping(value={"/asset/load/ajaxList.do"})
    @ResponseBody
    public Object ajaxList(TLoadRecord condition, DateQueryBean queryBean) {
        DataTablesParameters tables = DataTablesParameters.newInstance();
        String[] orderColumns = new String[]{"", "assetType", "", "", "", "regTime", ""};
        LitePaging pagination = this.loadRecordManagerService.queryLoadRecords(condition, Integer.valueOf(tables.getPage()), Integer.valueOf(tables.getLength()), tables.getOrderColName(orderColumns), tables.getOrderDir(), queryBean);
        return tables.getDataTablesReply(pagination);
    }

    @RequestMapping(value={"/asset/load/detail.do"})
    public String indexDetail(ModelMap modelMap) {
        modelMap.addAttribute("assetTypeStr", (Object)this.toJsonStr((Object)DicInitCache.getDics((String)"assetType")));
        return "asset/importInfo";
    }

    @RequestMapping(value={"/asset/load/ajaxDataList.do"})
    @ResponseBody
    public Object ajaxDataList(TLoadRecord condition) {
        DataTablesParameters tables = DataTablesParameters.newInstance();
        String[] orderColumns = new String[]{"", "", "", "assetType", "", "", "time"};
        LitePaging pagination = this.loadRecordManagerService.queryLoadRecordDetails(condition, Integer.valueOf(tables.getPage()), Integer.valueOf(tables.getLength()), tables.getOrderColName(orderColumns), tables.getOrderDir());
        return tables.getDataTablesReply(pagination);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequestMapping(value={"/asset/load/download.do"})
    public void downloadConfigFile(String recordId, HttpServletResponse response, HttpServletRequest request) {
        block12: {
            TUser currUser = (TUser)OperatorUtil.getOperator().getCurrUser();
            OutputStream out = null;
            try {
                TLoadRecord record = this.loadRecordManagerService.getByRecordId(recordId);
                String failPath = record.getFailurePath();
                File file = new File(request.getSession().getServletContext().getRealPath("/") + "/download/" + failPath);
                if (!file.exists()) {
                    this.renderText(response, "\u6587\u4ef6\u4e0d\u5b58\u5728\uff01");
                    return;
                }
                this.logger.info(SystemLog.ENUM_LOG_TYPE.operateLog.value.intValue(), LoggerExtData.create((String)"modelType", (Object)SystemLog.ENUM_LOG_MODEL_TYPE.assetManagerLog.value), "\u7ba1\u7406\u5458{}\u4e0b\u8f7d\u8d44\u4ea7\u5bfc\u5165\u8bb0\u5f55\u5931\u8d25\u6570\u636e\u6210\u529f", (Object)currUser.getUserName());
                FileInputStream fis = null;
                ByteArrayOutputStream bos = null;
                byte[] content = null;
                try {
                    fis = new FileInputStream(file);
                    bos = new ByteArrayOutputStream();
                    byte[] cache = new byte[128];
                    int length = 0;
                    while ((length = fis.read(cache, 0, cache.length)) > 0) {
                        bos.write(cache, 0, length);
                    }
                    content = bos.toByteArray();
                    bos.flush();
                }
                catch (Exception e) {
                    this.logger.error("\u4e0b\u8f7d\u5931\u8d25\u6570\u636e\u5f02\u5e38", (Throwable)e);
                    this.renderText(response, "\u4e0b\u8f7d\u5931\u8d25!");
                }
                finally {
                    fis.close();
                    bos.close();
                }
                response.setHeader("Content-Disposition", "attachment;filename=" + URLEncoder.encode(failPath, "UTF-8"));
                response.setContentType("application/vnd.ms-excel");
                out = response.getOutputStream();
                out.write(content);
                out.flush();
                out.close();
            }
            catch (Exception e) {
                this.renderText(response, "\u4e0b\u8f7d\u5931\u8d25!");
                if (null == out) break block12;
                try {
                    out.close();
                }
                catch (IOException e1) {
                    this.logger.error("\u4e0b\u8f7d\u521d\u59cb\u5316\u914d\u7f6e\u6587\u4ef6\u5f02\u5e38", (Throwable)e);
                }
            }
        }
    }
}

