/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.cssp.ams.web.security.provider;

import com.xdja.cssp.ams.system.entity.TUser;
import com.xdja.cssp.ams.system.service.IUserService;
import com.xdja.cssp.ams.web.security.provider.UsernamePasswordCardidToken;
import com.xdja.platform.rpc.consumer.refer.DefaultServiceRefer;
import com.xdja.platform.security.provider.AuthenticationProvider;
import org.apache.commons.lang3.StringUtils;
import org.apache.shiro.authc.AuthenticationException;
import org.apache.shiro.authc.AuthenticationToken;
import org.apache.shiro.authc.UnknownAccountException;

public class AuthenticationProviderImpl
implements AuthenticationProvider {
    private IUserService userService = (IUserService)DefaultServiceRefer.getServiceRefer(IUserService.class);

    public AuthenticationProvider.AuthenticationInfo doAuthenticate(AuthenticationToken authToken) throws AuthenticationException {
        TUser user;
        UsernamePasswordCardidToken token = (UsernamePasswordCardidToken)authToken;
        boolean status = false;
        try {
            user = this.userService.getUserByUserName(token.getUsername());
        }
        catch (Exception e) {
            throw new AuthenticationException("\u767b\u5f55\u5931\u8d25,\u670d\u52a1\u5f02\u5e38", (Throwable)e);
        }
        if (user != null) {
            if (user.getStatus() == TUser.ENUM_USER_STATUS.stopStatus.value) {
                status = true;
            } else {
                if (StringUtils.isBlank((CharSequence)token.getCardId())) {
                    throw new AuthenticationException("\u8bf7\u63d2\u5165\u767b\u5f55\u5b89\u5168\u5361");
                }
                if (!this.userService.cardIdIsExist(token.getUsername(), token.getCardId())) {
                    throw new AuthenticationException("\u7528\u6237\u540d\u4e0e\u5b89\u5168\u5361\u4e0d\u5339\u914d");
                }
            }
            AuthenticationProvider.AuthenticationInfo info = new AuthenticationProvider.AuthenticationInfo();
            info.setUsername(user.getUserName());
            info.setPassword(user.getPassword());
            info.setLocked(status);
            return info;
        }
        throw new UnknownAccountException();
    }
}

