/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.cssp.ams.web.system.action;

import com.xdja.cssp.ams.log.entity.SystemLog;
import com.xdja.cssp.ams.system.condition.DicCondition;
import com.xdja.cssp.ams.system.entity.TDic;
import com.xdja.cssp.ams.system.entity.TUser;
import com.xdja.cssp.ams.system.service.IDicService;
import com.xdja.cssp.ams.web.json.DataTablesParameters;
import com.xdja.cssp.ams.web.system.action.DicInitCache;
import com.xdja.cssp.ams.web.util.Constants;
import com.xdja.cssp.ams.web.util.EncoderUtil;
import com.xdja.platform.log.LoggerExtData;
import com.xdja.platform.rpc.consumer.refer.DefaultServiceRefer;
import com.xdja.platform.rpc.proxy.page.LitePaging;
import com.xdja.platform.security.utils.OperatorUtil;
import com.xdja.platform.util.json.JSONException;
import com.xdja.platform.util.json.JsonMapper;
import com.xdja.platform.web.action.BaseAction;
import javax.servlet.http.HttpServletResponse;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
public class DicManagerAction
extends BaseAction {
    private IDicService dicService = (IDicService)DefaultServiceRefer.getServiceRefer(IDicService.class);

    @RequestMapping(value={"/system/dic/index.do"})
    public String index() {
        return "system/dic/index";
    }

    @RequestMapping(value={"/system/dic/toSubList.do"})
    public String subIndex(DicCondition condition, ModelMap modelMap) {
        modelMap.addAttribute("dic", (Object)condition);
        if (condition.getParentCode().equals("0")) {
            return "system/dic/index";
        }
        return "system/dic/subIndex";
    }

    @RequestMapping(value={"/system/dic/ajaxList.do"})
    @ResponseBody
    public Object ajaxList(DicCondition condition) {
        DataTablesParameters tables = DataTablesParameters.newInstance();
        String[] orderColumns = new String[]{"name", "note"};
        LitePaging pagination = this.dicService.queryAllTopDics(condition, tables.getPage(), tables.getLength(), tables.getOrderColName(orderColumns), tables.getOrderDir());
        return tables.getDataTablesReply(pagination);
    }

    @RequestMapping(value={"/system/dic/add.do"})
    public String add(String parentCode, ModelMap modelMap) {
        modelMap.put((Object)"parentCode", (Object)parentCode);
        return "system/dic/add";
    }

    @RequestMapping(value={"/system/dic/addItem.do"})
    public String addItem(String parentCode, ModelMap modelMap) {
        modelMap.put((Object)"parentCode", (Object)parentCode);
        return "system/dic/additem";
    }

    @RequestMapping(value={"/system/dic/save.do"})
    public void save(TDic dic, HttpServletResponse response) {
        String message;
        block13: {
            message = "success";
            TUser user = (TUser)OperatorUtil.getOperator().getCurrUser();
            try {
                boolean isSave = false;
                if (null == dic.getId()) {
                    isSave = true;
                }
                this.dicService.saveDic(dic);
                LoggerExtData extData = LoggerExtData.create((String)"modelType", (Object)SystemLog.ENUM_LOG_MODEL_TYPE.systemManagerLog.value);
                extData.put("logType", (Object)7);
                extData.put("dict", (Object)dic.getName());
                if (isSave) {
                    if (dic.getParentCode().equals("0")) {
                        DicInitCache.addDics((String)dic.getCode());
                    } else {
                        DicInitCache.addDicItem((String)dic.getCode(), (String)dic.getName(), (String)dic.getParentCode());
                    }
                    try {
                        this.logger.info("\u521d\u59cb\u5316\u5b57\u5178\u6570\u636e\u4e3a" + JsonMapper.nonEmptyMapper().toJson((Object)DicInitCache.dicMap));
                    }
                    catch (JSONException e) {
                        e.printStackTrace();
                    }
                    if (dic.getParentCode().equals("0")) {
                        this.logger.info(SystemLog.ENUM_LOG_TYPE.operateLog.value.intValue(), extData, "\u7ba1\u7406\u5458{}\u6dfb\u52a0\u5b57\u5178\u7c7b\u578b{}\u6210\u529f", (Object)user.getUserName(), (Object)dic.getName());
                    } else {
                        this.logger.info(SystemLog.ENUM_LOG_TYPE.operateLog.value.intValue(), extData, "\u7ba1\u7406\u5458{}\u6dfb\u52a0\u5b57\u5178\u7c7b\u578b{}\u7684\u5b57\u5178\u503c{}\u6210\u529f", new Object[]{user.getUserName(), dic.getParentCode(), dic.getName()});
                    }
                    break block13;
                }
                if (dic.getParentCode().equals("0")) {
                    this.logger.info(SystemLog.ENUM_LOG_TYPE.operateLog.value.intValue(), extData, "\u7ba1\u7406\u5458{}\u4fee\u6539\u5b57\u5178\u7c7b\u578b{}\u6210\u529f", (Object)user.getUserName(), (Object)dic.getName());
                } else {
                    this.logger.info(SystemLog.ENUM_LOG_TYPE.operateLog.value.intValue(), extData, "\u7ba1\u7406\u5458{}\u4fee\u6539\u5b57\u5178\u7c7b\u578b{}\u7684\u5b57\u5178\u503c{}\u6210\u529f", new Object[]{user.getUserName(), dic.getParentCode(), dic.getName()});
                    DicInitCache.addDicItem((String)dic.getCode(), (String)dic.getName(), (String)dic.getParentCode());
                }
            }
            catch (IllegalArgumentException e) {
                message = e.getMessage();
                this.logger.error("\u7ba1\u7406\u5458{}\u4fdd\u5b58\u5b57\u5178{}\u65f6\u53c2\u6570\u5f02\u5e38:{}", new Object[]{user.getUserName(), dic.getName(), e});
            }
            catch (Exception e) {
                message = "\u4fdd\u5b58\u5b57\u5178\u9879\u5931\u8d25";
                this.logger.error("\u7ba1\u7406\u5458{}\u4fdd\u5b58\u5b57\u5178{}\u65f6\u51fa\u73b0\u5f02\u5e38:{}", new Object[]{user.getUserName(), dic.getName(), e});
            }
        }
        this.renderText(response, message);
    }

    @RequestMapping(value={"/system/dic/edit.do"})
    public String edit(Long dicId, ModelMap modelMap) {
        TDic dic = this.dicService.getDicById(dicId);
        modelMap.addAttribute("dic", (Object)dic);
        return "system/dic/edit";
    }

    @RequestMapping(value={"/system/dic/editItem.do"})
    public String editItem(Long dicId, ModelMap modelMap) {
        TDic dic = this.dicService.getDicById(dicId);
        modelMap.addAttribute("dic", (Object)dic);
        return "system/dic/edititem";
    }

    @RequestMapping(value={"/system/dic/del.do"})
    public void del(DicCondition condition, HttpServletResponse response) {
        String message = "success";
        TUser user = (TUser)OperatorUtil.getOperator().getCurrUser();
        try {
            this.dicService.deleteDicById(condition);
            if (condition.getParentCode().equals("0")) {
                DicInitCache.deleteDics((String)condition.getCode());
            } else {
                DicInitCache.deleteDicItem((String)condition.getCode(), (String)condition.getParentCode());
            }
            try {
                this.logger.info("\u521d\u59cb\u5316\u5b57\u5178\u6570\u636e\u4e3a" + JsonMapper.nonEmptyMapper().toJson((Object)DicInitCache.dicMap));
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
            LoggerExtData extData = LoggerExtData.create((String)"modelType", (Object)SystemLog.ENUM_LOG_MODEL_TYPE.systemManagerLog.value);
            extData.put("logType", (Object)7);
            extData.put("dict", (Object)condition.getName());
            if (condition.getParentCode().equals("0")) {
                this.logger.info(SystemLog.ENUM_LOG_TYPE.operateLog.value.intValue(), extData, "\u7ba1\u7406\u5458{}\u5220\u9664\u5b57\u5178\u7c7b\u578b{}\u6210\u529f", (Object)user.getUserName(), (Object)condition.getName());
            } else {
                this.logger.info(SystemLog.ENUM_LOG_TYPE.operateLog.value.intValue(), extData, "\u7ba1\u7406\u5458{}\u5220\u9664\u5b57\u5178\u7c7b\u578b{}\u7684\u5b57\u5178\u503c{}\u6210\u529f", new Object[]{user.getUserName(), condition.getParentCode(), condition.getName()});
            }
        }
        catch (IllegalArgumentException e) {
            message = e.getMessage();
            this.logger.error("\u7ba1\u7406\u5458{}\u5220\u9664{}\u5b57\u5178\u65f6\u53c2\u6570\u5f02\u5e38", (Object)user.getUserName(), (Object)condition.getName());
        }
        catch (Exception e) {
            message = "\u5220\u9664\u5b57\u5178\u9879\u5931\u8d25";
            this.logger.error("\u7ba1\u7406\u5458{}\u5220\u9664{}\u5b57\u5178\u4fe1\u606f\u65f6\u5f02\u5e38", (Object)user.getUserName(), (Object)condition.getName());
        }
        this.renderText(response, message);
    }

    @RequestMapping(value={"/system/dic/checkDicName.do"})
    @ResponseBody
    public Object checkDicName(String dicId, String name) {
        try {
            return this.dicService.isDicNameExist(dicId, name) ? EncoderUtil.encode((String)"\u5b57\u5178\u6807\u8bc6\u91cd\u590d") : "success";
        }
        catch (Exception e) {
            this.logger.error("\u670d\u52a1\u5f02\u5e38", (Throwable)e);
            return EncoderUtil.encode((String)Constants.SERVICE_BREAKE);
        }
    }

    @RequestMapping(value={"/system/dic/checkDicCode.do"})
    @ResponseBody
    public Object checkDicCode(String code) {
        try {
            return this.dicService.isDicCodeExist("0", code) ? EncoderUtil.encode((String)"\u5b57\u5178\u7c7b\u578b\u91cd\u590d") : "success";
        }
        catch (Exception e) {
            this.logger.error("\u670d\u52a1\u5f02\u5e38", (Throwable)e);
            return EncoderUtil.encode((String)Constants.SERVICE_BREAKE);
        }
    }

    @RequestMapping(value={"/system/dic/checkDicValue.do"})
    @ResponseBody
    public Object checkDicValue(String parentCode, String code) {
        try {
            return this.dicService.isDicCodeExist(parentCode, code) ? EncoderUtil.encode((String)"\u5b57\u5178\u503c\u6807\u8bc6\u91cd\u590d") : "success";
        }
        catch (Exception e) {
            this.logger.error("\u670d\u52a1\u5f02\u5e38", (Throwable)e);
            return EncoderUtil.encode((String)Constants.SERVICE_BREAKE);
        }
    }
}

