/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.cssp.ams.web.system.action;

import com.xdja.cssp.ams.log.entity.SystemLog;
import com.xdja.cssp.ams.system.entity.TRole;
import com.xdja.cssp.ams.system.entity.TUser;
import com.xdja.cssp.ams.system.service.IRoleService;
import com.xdja.cssp.ams.web.json.DataTablesParameters;
import com.xdja.cssp.ams.web.util.Constants;
import com.xdja.cssp.ams.web.util.EncoderUtil;
import com.xdja.platform.log.LoggerExtData;
import com.xdja.platform.rpc.consumer.refer.DefaultServiceRefer;
import com.xdja.platform.rpc.proxy.page.LitePaging;
import com.xdja.platform.security.utils.OperatorUtil;
import com.xdja.platform.web.action.BaseAction;
import javax.servlet.http.HttpServletResponse;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
public class RoleManagerAction
extends BaseAction {
    private IRoleService roleService = (IRoleService)DefaultServiceRefer.getServiceRefer(IRoleService.class);

    @RequestMapping(value={"/system/role/index.do"})
    public String index() {
        return "system/role/index";
    }

    @RequestMapping(value={"/system/role/ajaxList.do"})
    @ResponseBody
    public Object ajaxList(TRole roleCondition) {
        DataTablesParameters tables = DataTablesParameters.newInstance();
        String[] orderColumns = new String[]{"name", "note"};
        LitePaging pagination = this.roleService.queryAllRoles(roleCondition, Integer.valueOf(tables.getPage()), Integer.valueOf(tables.getLength()), tables.getOrderColName(orderColumns), tables.getOrderDir());
        return tables.getDataTablesReply(pagination);
    }

    @RequestMapping(value={"/system/role/addRole.do"})
    public String addRole(ModelMap modelMap) {
        modelMap.addAttribute("roleFuncTree", (Object)this.toJsonStr((Object)this.roleService.queryAllFunctions(null)));
        return "system/role/add";
    }

    @RequestMapping(value={"/system/role/saveRole.do"})
    public void saveRole(TRole role, String funcIds, HttpServletResponse response) {
        String message = "success";
        TUser user = (TUser)OperatorUtil.getOperator().getCurrUser();
        try {
            this.roleService.saveRole(role, funcIds);
            LoggerExtData extData = LoggerExtData.create((String)"modelType", (Object)SystemLog.ENUM_LOG_MODEL_TYPE.systemManagerLog.value);
            extData.put("logType", (Object)4);
            extData.put("role", (Object)role.getName());
            if (null == role.getId()) {
                this.logger.info(SystemLog.ENUM_LOG_TYPE.operateLog.value.intValue(), extData, "\u7ba1\u7406\u5458{}\u6dfb\u52a0\u89d2\u8272{}\u6210\u529f", (Object)user.getUserName(), (Object)role.getName());
            } else {
                this.logger.info(SystemLog.ENUM_LOG_TYPE.operateLog.value.intValue(), extData, "\u7ba1\u7406\u5458{}\u4fee\u6539\u89d2\u8272{}\u6210\u529f", (Object)user.getUserName(), (Object)role.getName());
            }
        }
        catch (IllegalArgumentException e) {
            message = e.getMessage();
            this.logger.error("\u7ba1\u7406\u5458{}\u4fdd\u5b58\u89d2\u8272{}\u65f6\u53c2\u6570\u5f02\u5e38", (Object)user.getUserName(), (Object)role.getName());
        }
        catch (Exception e) {
            message = "\u4fdd\u5b58\u89d2\u8272\u5931\u8d25";
            this.logger.error("\u7ba1\u7406\u5458{}\u4fdd\u5b58\u89d2\u8272{}\u65f6\u51fa\u73b0\u5f02\u5e38", (Object)user.getUserName(), (Object)role.getName());
        }
        this.renderText(response, message);
    }

    @RequestMapping(value={"/system/role/editRole.do"})
    public String editRole(String roleId, ModelMap modelMap) {
        TRole role = this.roleService.getRoleById(roleId);
        modelMap.addAttribute("roleFuncTree", (Object)this.toJsonStr((Object)this.roleService.queryAllFunctions(roleId)));
        modelMap.addAttribute("role", (Object)role);
        return "system/role/edit";
    }

    @RequestMapping(value={"/system/role/delRole.do"})
    public void delRole(String roleId, String roleName, HttpServletResponse response) {
        String message = "success";
        TUser user = (TUser)OperatorUtil.getOperator().getCurrUser();
        try {
            Boolean isSuccDel = this.roleService.deleteRoleById(roleId);
            LoggerExtData extData = LoggerExtData.create((String)"modelType", (Object)SystemLog.ENUM_LOG_MODEL_TYPE.systemManagerLog.value);
            extData.put("logType", (Object)4);
            extData.put("role", (Object)roleName);
            if (!isSuccDel.booleanValue()) {
                message = "\u5f53\u524d\u89d2\u8272\u88ab\u7528\u6237\u7ed1\u5b9a\uff0c\u4e0d\u5141\u8bb8\u5220\u9664\uff01";
                this.logger.info(SystemLog.ENUM_LOG_TYPE.operateLog.value.intValue(), extData, "\u7ba1\u7406\u5458{}\u5220\u9664{}\u89d2\u8272\u5931\u8d25\uff0c\u5f53\u524d\u89d2\u8272\u5df2\u88ab\u7528\u6237\u7ed1\u5b9a", (Object)user.getUserName(), (Object)roleName);
            } else {
                this.logger.info(SystemLog.ENUM_LOG_TYPE.operateLog.value.intValue(), extData, "\u7ba1\u7406\u5458{}\u5220\u9664{}\u89d2\u8272\u6210\u529f", (Object)user.getUserName(), (Object)roleName);
            }
        }
        catch (IllegalArgumentException e) {
            message = e.getMessage();
            this.logger.error("\u7ba1\u7406\u5458{}\u5220\u9664{}\u89d2\u8272\u65f6\u53c2\u6570\u5f02\u5e38", (Object)user.getUserName(), (Object)roleName);
        }
        catch (Exception e) {
            message = "\u5220\u9664\u89d2\u8272\u5931\u8d25";
            this.logger.error("\u7ba1\u7406\u5458{}\u5220\u9664{}\u89d2\u8272\u65f6\u5f02\u5e38", (Object)user.getUserName(), (Object)roleName);
        }
        this.renderText(response, message);
    }

    @RequestMapping(value={"/system/role/checkRoleName.do"})
    @ResponseBody
    public Object checkRoleName(String roleId, String name) {
        try {
            return this.roleService.isRoleNameExist(roleId, name) != false ? EncoderUtil.encode((String)"\u89d2\u8272\u540d\u91cd\u590d") : "success";
        }
        catch (Exception e) {
            this.logger.error("\u670d\u52a1\u5f02\u5e38", (Throwable)e);
            return EncoderUtil.encode((String)Constants.SERVICE_BREAKE);
        }
    }
}

