/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.cssp.ams.web.util;

import com.sun.org.apache.xerces.internal.impl.dv.util.Base64;
import java.io.ByteArrayInputStream;
import java.security.Provider;
import java.security.Security;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.security.interfaces.ECPublicKey;
import java.security.interfaces.RSAPublicKey;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import sun.misc.BASE64Encoder;

/*
 * Exception performing whole class analysis ignored.
 */
public class CertUtil {
    public static final String CERT_HEAD = "-----BEGIN CERTIFICATE-----";
    public static final String CERT_TAIL = "-----END CERTIFICATE-----";

    public static X509Certificate getCertFromStr16(String str) {
        byte[] bs = CertUtil.hex2byte((String)str);
        CertificateFactory cf = null;
        X509Certificate x509Cert = null;
        try {
            cf = CertificateFactory.getInstance("X.509", "BC");
            ByteArrayInputStream inStream = new ByteArrayInputStream(bs);
            x509Cert = (X509Certificate)cf.generateCertificate(inStream);
            return x509Cert;
        }
        catch (Exception e) {
            System.err.println("getCertFromFullStr error: " + e.toString());
            return null;
        }
    }

    public static byte[] hex2byte(String str) {
        if (null == str || str.equals("")) {
            return null;
        }
        StringBuffer sb = new StringBuffer(str = str.trim());
        int len = sb.length();
        if (len == 0 || len % 2 == 1) {
            return null;
        }
        byte[] b = new byte[len / 2];
        try {
            for (int i = 0; i < len; i += 2) {
                b[i / 2] = (byte)Integer.decode("0x" + sb.substring(i, i + 2)).intValue();
            }
            return b;
        }
        catch (Exception e) {
            return null;
        }
    }

    public static String getPubKey(String str, int caAlg) {
        X509Certificate x509Cert = CertUtil.getCertFromStr((String)str);
        String pubKey = null;
        if (caAlg == 1) {
            RSAPublicKey rsa = (RSAPublicKey)x509Cert.getPublicKey();
            pubKey = rsa.getModulus().toString(16).toUpperCase();
        } else {
            ECPublicKey sm2 = (ECPublicKey)x509Cert.getPublicKey();
            pubKey = sm2.getW().getAffineX().toString(16) + "#" + sm2.getW().getAffineY().toString(16);
        }
        return pubKey;
    }

    public static X509Certificate getCertFromStr(String str) {
        X509Certificate x509Cert = null;
        x509Cert = CertUtil.getCertFromB64((String)str);
        if (x509Cert == null) {
            x509Cert = CertUtil.getCertFromFullStr((String)str);
        }
        if (x509Cert == null) {
            x509Cert = CertUtil.getCertFromStr16((String)str);
        }
        return x509Cert;
    }

    public static X509Certificate getCertFromFullStr(String str) {
        CertificateFactory cf = null;
        X509Certificate x509Cert = null;
        try {
            cf = CertificateFactory.getInstance("X.509", "BC");
            ByteArrayInputStream inStream = new ByteArrayInputStream(str.getBytes());
            x509Cert = (X509Certificate)cf.generateCertificate(inStream);
            return x509Cert;
        }
        catch (Exception e) {
            System.err.println("getCertFromFullStr error: " + e.toString());
            return null;
        }
    }

    public static synchronized X509Certificate getCertFromB64(String b64) {
        CertificateFactory cf = null;
        X509Certificate x509Cert = null;
        try {
            cf = CertificateFactory.getInstance("X.509", "BC");
            byte[] bsCert = Base64.decode(b64);
            ByteArrayInputStream inStream = new ByteArrayInputStream(bsCert);
            x509Cert = (X509Certificate)cf.generateCertificate(inStream);
            return x509Cert;
        }
        catch (Exception e) {
            System.err.println("getCertFromB64 error: " + e.toString());
            return null;
        }
    }

    public static String getSub(String dn, String cn) {
        if (dn == null || dn.length() == 0 || cn == null || cn.length() == 0) {
            return null;
        }
        String[] items = dn.split(",");
        if (items == null || items.length == 0) {
            return null;
        }
        for (int i = 0; i < items.length; ++i) {
            String[] item = items[i].split("=");
            if (item == null || item.length != 2) continue;
            for (int j = 0; j < item.length; ++j) {
                item[j] = item[j].trim();
            }
            if (!item[0].equalsIgnoreCase(cn)) continue;
            return item[1];
        }
        return null;
    }

    public static String[][] getItems(String dn) {
        if (dn == null || dn.length() == 0) {
            return null;
        }
        String[] items = dn.split(",");
        if (items == null || items.length == 0) {
            return null;
        }
        String[][] itemss = new String[items.length][2];
        for (int i = 0; i < items.length; ++i) {
            String[] item = items[i].split("=");
            if (item == null || item.length != 2) {
                return null;
            }
            for (int j = 0; j < item.length; ++j) {
                itemss[i][j] = item[j].trim();
            }
        }
        return itemss;
    }

    public static String getSn(X509Certificate cert) {
        return cert.getSerialNumber().toString(16).toLowerCase();
    }

    public static String getDn(X509Certificate cert) {
        String dn = cert.getSubjectX500Principal().getName();
        String[] items = dn.split(",");
        if (items.length == 4 && dn.toLowerCase().indexOf("cn=") > -1 && dn.toLowerCase().indexOf("ou=") > -1 && dn.toLowerCase().indexOf("o=") > -1 && dn.toLowerCase().indexOf("c=") > -1) {
            StringBuffer sb = new StringBuffer();
            sb.append("CN=");
            sb.append(CertUtil.getSub((String)dn, (String)"cn"));
            sb.append(",OU=");
            sb.append(CertUtil.getSub((String)dn, (String)"ou"));
            sb.append(",O=");
            sb.append(CertUtil.getSub((String)dn, (String)"o"));
            sb.append(",C=");
            sb.append(CertUtil.getSub((String)dn, (String)"c"));
            return sb.toString();
        }
        return dn;
    }

    public static String certToFullB64(Certificate cert) {
        String certb64 = "";
        try {
            certb64 = CertUtil.bytesToFullB64((byte[])cert.getEncoded());
        }
        catch (Exception e) {
            System.err.println("certToFullB64 error:" + e.toString());
        }
        return certb64;
    }

    public static String bytesToFullB64(byte[] certder) {
        String certb64 = null;
        try {
            BASE64Encoder encoder = new BASE64Encoder();
            certb64 = encoder.encode(certder);
            certb64 = "-----BEGIN CERTIFICATE-----\n" + certb64 + "\n" + "-----END CERTIFICATE-----" + "\n";
            return certb64;
        }
        catch (Exception e) {
            System.err.println("certDerToFullB64 error:" + e.toString());
            return null;
        }
    }

    static {
        Security.addProvider((Provider)new BouncyCastleProvider());
    }
}

