/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.cssp.ams.web.util;

import com.xdja.platform.log.Logger;
import com.xdja.platform.log.LoggerFactory;
import java.io.FileNotFoundException;
import org.apache.commons.lang3.StringEscapeUtils;
import org.owasp.validator.html.AntiSamy;
import org.owasp.validator.html.CleanResults;
import org.owasp.validator.html.Policy;
import org.owasp.validator.html.PolicyException;
import org.owasp.validator.html.ScanException;

public class XSSEscapeUtils {
    protected static final Logger logger = LoggerFactory.getLogger(XSSEscapeUtils.class);

    public static String cleanWithPolicy(String source) {
        String result = "";
        String policyFilePath = XSSEscapeUtils.class.getResource("/").getFile() + "antisamy-xdja.xml";
        try {
            Policy policy = Policy.getInstance((String)policyFilePath);
            AntiSamy as = new AntiSamy();
            CleanResults cr = as.scan(source, policy);
            result = cr.getCleanHTML();
        }
        catch (PolicyException e) {
            if (e.getCause().getClass().equals(FileNotFoundException.class)) {
                logger.error("\u627e\u4e0d\u5230XSS\u7b56\u7565\u6587\u4ef6\uff1a" + policyFilePath);
            } else {
                logger.error("\u52a0\u8f7dxss\u7b56\u7565\u6587\u4ef6\u5f02\u5e38\uff0c\u5f02\u5e38\u4fe1\u606f\u4e3a\uff1a" + e.getMessage());
            }
        }
        catch (ScanException e) {
            logger.error("\u6839\u636e\u7b56\u7565\u6e05\u7406\u8f93\u5165\u6570\u636e\u5f02\u5e38\uff0c\u5f02\u5e38\u4fe1\u606f\u4e3a\uff1a" + e.getMessage());
        }
        return result;
    }

    public static String simpleClean(String source) {
        return StringEscapeUtils.escapeHtml4((String)source);
    }
}

