<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8"%>
<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@ taglib prefix="fn" uri="http://java.sun.com/jsp/jstl/functions"%>

<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml" >
  <head >
    <meta charset="utf-8" />
<title>硬件安全模块统计管理系统</title>
<!-- <title>资产管理系统</title> -->     
<link rel="shortcut icon" href="${base}/images/small-logo.ico" type="image/x-icon" />  
<script type="text/javascript" src="${base}/script/jquery-1.10.2.js"></script>
<script type="text/javascript" src="${base}/script/bootstrap.min.js"></script>
<script type="text/javascript" src="${base}/script/app.js"></script>
<script type="text/javascript" src="${base}/script/json2.js"></script>
<script type="text/javascript" src="${base}/script/card-1.0.0.js"></script>
<script type="text/javascript" src="${base}/script/cookie/jquery.cookie.js"></script>
<!-- artDialog -->
<script type="text/javascript" src="${base}/script/dialog/artDialog/artDialog.source.js"></script>
<script type="text/javascript" src="${base}/script/dialog/artDialog/plugins/iframeTools.js"></script>
<script type="text/javascript" src="${base}/script/utils.js"></script>
<link rel="stylesheet" type="text/css" href="${base}/script/dialog/artDialog/skins/default.css" />
<!-- dataTable -->
<script type="text/javascript" src="${base}/script/dataTables/jquery.dataTables.min.js"></script>
<script type="text/javascript" src="${base}/script/dataTablesWrap.js"></script>
<link rel="stylesheet" type="text/css" href="${base}/script/dataTables/jquery.dataTables.min.css" />
<link rel="stylesheet" type="text/css" href="${base}/script/dataTables/css/jquery.dataTables_theme.css" />
<script type="text/javascript" src="${base}/script/dataTables/js/tableMove.js"></script>
<link rel="stylesheet" type="text/css" href="${base}/themes/default/css/bootstrap.min.css" />
<link rel="stylesheet" type="text/css" href="${base}/themes/default/css/default.css" />
<link rel="stylesheet" type="text/css" href="${base}/themes/default/css/style.css" />
<script type="text/javascript" language="javascript">
jQuery(document).ready(function() {  
	var openedLi = $.cookie("openedMenu");
	var openedLink = $.cookie("openedLink");
	
	var closed = $.cookie("closed");
	
	if(closed == "true"){
		$("body").addClass("page-sidebar-closed");
	} else {
		$("body").removeClass("page-sidebar-closed");
	}

	$("#li_child_" + openedLink).addClass("active");
	$("#" + openedLi).addClass("open active");
	$("#" + openedLi + "_arrow").addClass("open");

});

function redirect(url, link, d){
	var closed = false;
	if($("body").attr("class").indexOf("page-sidebar-closed") > 0){
		closed = true;
	}

	if("" == link){
		$.cookie("openedMenu", null, {expires:7,  path:"/"});
		$.cookie("openedLink", null, {expires:7,  path:"/"}); 
	} else {
		var newOpenedLi = $(d).parent("li").parent("ul").parent("li").attr("id");
		
		if(null == newOpenedLi){
			newOpenedLi = "li_" + link;
		} 
						
		$.cookie("openedMenu", newOpenedLi, {expires:7,  path:"/"}); 
		$.cookie("openedLink", link, {expires:7,  path:"/"}); 
	}
	
	$.cookie("closed", closed, {expires:7,  path:"/"}); 

	location.href = "${base}/" + url;
}

</script>


<script type="text/javascript">
	var errorDesc = {
	 	'0':"未安装读卡控件，请返回登录页面下载",
	 	'3':"读卡控件已经升级，请到登录页面下载安装后重新登录",
	 	'-100':'您的浏览器不支持安全控件'
	};
	
	$(function(){
		var plugin = Card.ready();
		if(!plugin.success){
			$alert("安全卡已被拔出，系统将强制退出", logout);
			return;
		}
		
		plugin.onpullcard("${sessionScope.operator.currUser.cardId}", function(){
			$alert("安全卡已被拔出，系统将强制退出", logout);
			return;
		});
	});
	
	//退出登陆
	function logout() {
		$.cookie("openedLi", null);
		location.href = "${base}/logout.do";
	}
</script>

<sitemesh:write property='head' />
</head>
<body class="page-header-fixed ">
<div style="line-height:0;height: 0;width: 0;">
	<embed width="0" height="0" type="application/NPCardCert" id="pluginXdja" />
</div>


<!-- 主内容开始 -->   
<div class="page-container row-fluid">
<div class="page-sidebar">
	<!-- 头部开始 -->
	<div class="header navbar">
		<div class="navbar-inner">
			<div class="">
				<div class="system-logo">
					<!-- logo图标开始 -->
					<div class="brand logo-color">
						<div class="logo"></div>
					</div>
					<!-- logo图标开始end -->
		
					<!-- 系统名称开始 -->
					<div class="brand title-bg" href="javascript:void(0);"></div>
					<!-- 系统名称开始end -->
				</div>
						
			</div>
		</div>
	</div>
	<!-- 头部开始end -->
	<!-- 左侧边栏开始 -->
	<div class="nav-collapse collapse">
		<!-- 菜单开始 -->
		<ul class="page-sidebar-menu">			
			<c:forEach items="${sessionScope.operator.topMenus}" var="menu">
				<%-- <c:if test="${menu.properties['isControl'] == 2}"> --%>
					<c:if test="${!empty menu.children}">
						<li  id="li_${menu.id}" class="start">
							<a id="${menu.id}" href="javascript:void(0)" class="menu-bg">
								<i class="${menu.properties['icon']}"></i> 
								<span class="title">${menu.name}</span>
								<span id="li_${menu.id}_arrow"  class="arrow "></span>
							</a>
							<ul class="sub-menu">
								<c:forEach items="${menu.children}" var="child" >
									<li id="li_child_${child.id}">
										<a id="link_${child.id}" href="javascript:void(0)" onclick="redirect('${child.properties['link']}', '${child.id}', this)">
											<i class="icon-sort-down"></i>${child.name}
										</a>
									</li>
								</c:forEach>
							</ul>
						</li>
					</c:if>
					
					<c:if test="${empty menu.children}">
						<li id="li_${menu.id}" class="start">
							<a id="link_${menu.id}"  href="javascript:void(0)"  onclick="redirect('${menu.properties['link']}', '${menu.id}', this)" class="menu-bg">
								<i class="${menu.properties['icon']}"></i> 
							   <span class="title">${menu.name}</span>
							</a>
						</li>	
					</c:if>
				<%-- </c:if> --%>
			</c:forEach>
		</ul>

		<!-- END SIDEBAR MENU -->
	</div>
	</div>
	<!-- END SIDEBAR -->
	<!-- BEGIN PAGE -->
	<div class="page-content">
		<!-- BEGIN PAGE CONTAINER-->
		
		<!-- 用户名开始 -->
		<div class="system-operate row-fluid">
			<div id="navbar" class="navbar-text span12 nomin">
				<ul class="nav navbar-nav show-user">
					<!-- 用户名开始 -->
					<li class="navbar-link">
						<div>
							<div class="user-name"></div>
							<div class="declare">${sessionScope.operator.username}</div>
							<div class="fgx"></div>
						</div>							
					</li>
					<!-- 用户名开始end -->

					<!-- 密码开始 -->
					<li><a href="javascript:" onclick="redirect('toModifyPassword.do', '', this)"><div class="mima" title="修改密码"></div></a></li>
					<!-- 密码开始end -->

					<!-- 退出开始 -->
					<li><a href="javascript:" onclick="redirect('logout.do', '', this)"><div class="logout" title="退出"></div></a></li>
					<!-- 退出开始end -->
				</ul>
			</div>
		</div>	
		<!-- 用户名开始end -->
		
		<div class="content" >
			<div class="setMinWidth">
				<sitemesh:write property="body"/>
			</div>
		</div>
	</div>
</div>
<div id="execptionContainer" class=""></div>
<script>
jQuery(document).ready(function() {       
   // initiate layout and plugins
   App.init();	      
});

function sessionTimeout() {
	top.location.href = "${base}/login.do";
}

//所有的ajax请求在sesstion超时的时候都自动跳转到登录页面
var ajax = $.ajax;
$.ajax = function (opt) {
	//避免缓存
	opt.cache = false;
    //备份opt中error和success方法
    var fn = {
        success: function (data, textStatus, jqXHR) {
        }
    }
    if (opt.success) {
        fn.success = opt.success;
    }
    //扩展增强处理
    var _opt = $.extend(opt, {
        success: function (data, textStatus, jqXHR) {
        	if(jqXHR.getResponseHeader("sessionstatus") == "timeout") {
    			sessionTimeout();
    			return;
    		} else if(jqXHR.getResponseHeader("isException") === "true" && (jqXHR.getResponseHeader("Content-Type") === "text/html;charset=UTF-8" || jqXHR.getResponseHeader("Content-Type") === "text/html; charset=utf-8")) {
    			var clone = $('#execptionContainer').clone(true,true); 
    			clone.append(jqXHR.responseText);
    			
    			openDialog({
    				 height:540,
    				 width: 680,
    				 title : '系统异常',
    				 content: $(clone)[0]
    			 });
    			return;
    		}
            fn.success(data, textStatus, jqXHR);
        }
    });
    var def = ajax.call($, _opt);                                                                                                                             // 兼容不支持异步回调的版本
    if('done' in def){
        var done = def.done;
        def.done = function (func) {
            function _done(data, textStatus, jqXHR) {
            	if(jqXHR.getResponseHeader("sessionstatus") == "timeout") {
        			sessionTimeout();
        			return;
        		} else if(jqXHR.getResponseHeader("isException") === "true" && (jqXHR.getResponseHeader("Content-Type") === "text/html;charset=UTF-8" || jqXHR.getResponseHeader("Content-Type") === "text/html; charset=utf-8")) {
        			var clone = $('#execptionContainer').clone(true,true); 
        			clone.append(jqXHR.responseText);
        			
        			openDialog({
        				 height:540,
        				 width: 680,
        				 title : '系统异常',
        				 content: $(clone)[0]
        			 });
        			return;
        		}
                func(data);
            }

            done.call(def, _done);
            return def;
        };
    }
    return def;
};
</script>
<script type="text/javascript" language="javascript">
$("body").delegate("a","focus",function(){
  $("a").blur();
});
</script>
 </body>
</html>
