<#--
基于flash的上传组件标签
name：表单提交后可以通过该属性在action中取出提交所上传文件的真实名称
value：已经上传的文件的真实名称
uploadAction：文件上传请求地址
downloadAction：文件下载请求地址
-->
<#macro swfupload name="upload" value="" uploadAction="${base}/upload.do" fileFilter=["*.*", "所有文件"] required=false allowDownload=true fileType="" appId="" bizId="" fileSize="5MB" downloadAction="${base}/download.do">
	<script type="text/javascript">
		$(function(){
			swfu_${name} = new SWFUpload({
				flash_url : "${base}/plugins/swfupload.swf",
				flash9_url : "${base}/plugins/swfupload_fp9.swf",
				upload_url: "${uploadAction}",
				use_query_string: true,
				post_params: {
					"jsessionId" : "${sessionId!}",
					<#if fileType != "">
					"fileType" : "${fileType}",
					</#if>
					<#if appId != "">
					"id" : ${appId},
					</#if>
					<#if bizId != "">
					"bizId" : "${bizId}",
					</#if>
					"oldFile" : $("#${name}").val()
				},
				file_size_limit : "${fileSize}",
				file_types : "${fileFilter[0]}",
				file_types_description : "${fileFilter[1]}",
				file_queue_limit : 0,
				custom_settings : {
					progressTarget : "fsUploadProgress",
					cancelButtonId : "btnCancel"
				},
				debug: false,
		
				// Button Settings
				button_image_url : "${base}/themes/${themes}/images/swfupload.png",
				button_placeholder_id : "spanButtonPlaceholder_${name}",
				button_width: 65,
				button_height: 24,
				button_window_mode: SWFUpload.WINDOW_MODE.TRANSPARENT,
				button_cursor: SWFUpload.CURSOR.HAND,
				button_action:SWFUpload.BUTTON_ACTION.SELECT_FILE,
		
				file_queued_handler : function(file){
					this.addPostParam("oldFile", $("#${name}").val());
					$("#${name}").val(file.name);
					$("#${name}_div").html(file.name);
				},
				file_queue_error_handler : fileQueueError,
				file_dialog_complete_handler : fileDialogComplete,
				upload_progress_handler : function(file, bytesLoaded, bytesTotal) {
					
				},
				upload_error_handler : uploadError,
				upload_success_handler : function(file, serverData) {
					if (typeof serverData == "string") {
						serverData = eval("(" + serverData + ")");
					}
					if(!serverData.result) {
						alert(serverData.msg);
					} else {
						$("#${name}").val(serverData.fileName);
						$("#${name}_div").html(serverData.fileName);
						$("#${name}_dlBtn").removeClass("btnDownloadDisable").addClass("btnDownload").attr("disabled", false);
					}
				}
			});
			
			<#if allowDownload>
				$("#${name}_dlBtn").click(function() {
					$("#${name}_frame").attr("src", "${downloadAction}?fileType=${fileType}&fileName=" + $("#${name}").val());
				});
				<#if value != "">
					$("#${name}_dlBtn").removeClass("btnDownloadDisable").addClass("btnDownload").attr("disabled", false);
				</#if>
			</#if>
		});
	</script>
	<table>
		<tr>
			<td>
				<div id="${name}_div" tip="上传的附件不能超过${fileSize}" style="overflow:hidden;width:260px;border:#949494 1px solid;height:24px;line-height: 24px;white-space:nowrap;">${value!}</div>
				<input type="hidden" id="${name}" name="${name}" style="width:260px;" value="${value!}" <#if required>reg="notempty" message="{notempty:'附件不允许为空'}"</#if> readonly="readonly" />
			</td>
			<td style="padding-left:20px;">
				<span id="spanButtonPlaceholder_${name}"></span>
			</td>
			<#if allowDownload>
			<td>
				<input type="button" id="${name}_dlBtn" class="btn btnDownloadDisable" disabled="disabled" value="下载" />
			</td>
			</#if>
		</tr>
	</table>
	<#if allowDownload>
	<iframe name="${name}_frame" id="${name}_frame" src="about:blank" style="width:0px;height:0px;display:none;"></iframe>
	</#if>
</#macro>