$("li").click(function() {
	$("li").removeClass("li-active");
	$(this).addClass("li-active");
});

function toGateWayControl(){
	window.location.href="index.do";
}

function commandHandler(gwCode, cmdType){
	$confirm("您确定要执行指令吗？", function(){
		var waiting = $waiting("操作中...");
		$.ajax({
			type: "POST",
			url: "commandHandler.do",
			data: {gwCode:gwCode, cmdType:cmdType},
			success: function(result){
				if(result != ''){
					var msg = eval('(' + result + ')');
					if (msg == "success") {
						$notice('指令发送成功');
					} else {
						$alert("指令发送失败");
					}
				}else{
					$alert('指令发送失败');
				}
			},
			error : function(data){
				$alert('操作失败');
	  		},
			complete : function(XMLHttpRequest,status){
				waiting.close();
	  		}
		});
	});
}

function timeMonitor() {
	var waiting = $waiting("加载中...");	
	$.ajax({
		type: "POST",
		url: "runTimeReflesh.do",
		data: $("#searchForm").serialize(),
		success: function(json){
			if(json.error || json.monitorStatus == '2'){
				$alert('操作失败');
				return;
			}
			$notice('操作成功');
			$("#cpuRate").text(json.cpuRate+'%');
			$("#cpuRateImg").text(json.cpuRate+'%');
			$("#cpuRateOther").text((100-json.cpuRate)+'%');
			
			$("#memRate").text(json.memRate+'%');
			$("#memRateImg").text(json.memRate+'%');
			$("#memRateOther").text((100-json.memRate)+'%');
			
			$("#diskRate").text(json.diskRate+'%');
			$("#diskRateImg").text(json.diskRate+'%');
			$("#diskRateOther").text((100-json.diskRate)+'%');
			$("#collTime").text(json.collTime);
			initHighchartTable();
		}, 
		error : function(data){
			$alert('操作失败');
  		},
		complete : function(XMLHttpRequest,status){
			waiting.close();
  		}
	});
}

function buildCpuHistorys(series) {
	$('.network').hide();
	$('.monitor').show();
	var cpuChart = 	{
		legend :{
			enabled : false
		},
		credits : {
			enabled : false
		},
		chart : {
			type : 'spline'
		},
		title : {
			text : 'CPU利用率(%)'
		},
		xAxis : {
			type : 'datetime',
			labels : {
				formatter: function() {
					if(this.dateTimeLabelFormat=='%H:%M'){
						return Highcharts.dateFormat('%H:%M' , this.value);
					}else{
						return Highcharts.dateFormat('%m-%d %H:%M', this.value);
					}
		        }
			}
		},
		yAxis : {
			title: {
	        	text: ''
	        },
			gridLineWidth : 1,
			min:0,
			labels : {
				formatter: function() {
					return this.value;
		        }
			}
		},
		tooltip : {
			formatter: function() {
		            var s = Highcharts.dateFormat('%Y-%m-%d %H:%M:%S', this.x)+"<br/><strong><font color='"+this.series.color+"'>"+this.series.name+"</font>："+this.y+"%</strong>";
		            return s;
		        }
		},
		plotOptions : {
			spline : {
				lineWidth : 3,
				states : {
					hover : {
						lineWidth : 4
					}
				},
				marker : {
					enabled : false
				}
			}
		},
		series : series,
		colors: ["#19986d"]
	};
	$('#container').highcharts(cpuChart);
}

function getCpuSeriesList(data){
	var seriesList = new Array();
	var x = [];
	$.each(data,function(name,v){
		var s = new Date(v.time);
		x.push([Date.UTC(format(s,"yyyy"), parseInt(format(s,"MM"))-1, format(s,"dd"), format(s, "HH"), format(s, "mm"), format(s, "ss")), v.cpu]);
	});
	seriesList.push({
		name : 'cpu使用率',
		data:x
	});
	return seriesList;
}

function buildCommonHistorys(series, title, unit, seriesName) {
	$('.network').hide();
	$('.monitor').show();
	var cpuChart = 	{
		legend: {
			align: 'right',
			verticalAlign: 'top',
			y: 20,
			x: -45,
			floating: true
		},
		credits : {
			enabled : false
		},
		chart : {
			type : 'spline'
		},
		title : {
			text : title
		},
		xAxis : {
			type : 'datetime',
			labels : {
				formatter: function() {
					if(this.dateTimeLabelFormat=='%H:%M'){
						return Highcharts.dateFormat('%H:%M' , this.value);
					}else{
						return Highcharts.dateFormat('%m-%d %H:%M', this.value);
					}
		        }
			}
		},
		yAxis : {
			title: {
	        	text: ''
	        },
			gridLineWidth : 0,
			alternateGridColor : 'rgba(68, 170, 213, 0.1)',
			min:0,
			labels : {
				formatter: function() {
					return this.value;
		        }
			}
		},
		tooltip : {
			formatter: function() {
		            var s = Highcharts.dateFormat('%Y-%m-%d %H:%M:%S', this.x)+"<br/><strong><font color='"+this.series.color+"'>"+seriesName+"</font>："+this.y+unit+"</strong>";
		            return s;
		        }
		},
		plotOptions : {
			spline : {
				lineWidth : 3,
				states : {
					hover : {
						lineWidth : 4
					}
				},
				marker : {
					enabled : false
				}
			}
		},
		series : series,
		colors: ["#19986d"]
	};
	$('#container').highcharts(cpuChart);
}

function getMemSeriesList(data){
	seriesList = new Array();
	var x = new Array();
	var tatal = '';
	$.each(data,function(i,item){
		var s = new Date(item.time);
		x.push([Date.UTC(format(s,"yyyy"), parseInt(format(s,"MM"))-1, format(s,"dd"), format(s, "HH"), format(s, "mm"), format(s, "ss")), item.mem.used]);
		if(i==0) tatal = item.mem.total + 'M';
	});
	
	seriesList.push({
		name : '总内存：' + tatal,
		data : x
	});
	return seriesList;
}

function getDiskSeriesList(data){
	seriesList = new Array();
	var x = new Array();
	var tatal = '';
	$.each(data,function(i,item){
		var s = new Date(item.time);
		x.push([Date.UTC(format(s,"yyyy"), parseInt(format(s,"MM"))-1, format(s,"dd"), format(s, "HH"), format(s, "mm"), format(s, "ss")), item.disk.used]);
		if(i==0) tatal = item.disk.total + 'GB';
	});
	
	seriesList.push({
		name : '总磁盘：' + tatal,
		data : x
	});
	return seriesList;
}

function buildNetHistorys(seriesInput, seriesOutput, titleInput, titleOutput) {
	$('.monitor').hide();
	$('.network').show();
	
	var netChartInput = {
		legend: {
			align: 'right',
			verticalAlign: 'middle',
			width: 160,
			itemWidth:80,
			borderWidth:1,
			symbolWidth:30,
			borderRadius:5,
			borderWidth:1,
			itemHoverStyle: {
				color: '#33b086'
			},
			x:-30
        },
		credits : {
			enabled : false
		},
		chart : {
			type : 'spline'
		},
		title : {
			text : titleInput
		},
		xAxis : {
			type : 'datetime',
			labels : {
				formatter: function() {
					if(this.dateTimeLabelFormat=='%H:%M'){
						return Highcharts.dateFormat('%H:%M' , this.value);
					}else{
						return Highcharts.dateFormat('%m-%d %H:%M', this.value);
					}
		        }
			}
		},
		yAxis : {
			title: {
	        	text: ''
	        },
			gridLineWidth : 0,
			min:0,
			labels : {
				formatter: function() {
					return this.value;
		        }
			}
		},
		tooltip : {
			formatter: function() {
		            var s = Highcharts.dateFormat('%Y-%m-%d %H:%M:%S', this.x)+"<br/><strong><font color='"+this.series.color+"'>"+this.series.name+"</font>："+this.y+"MB</strong>";
		            return s;
		        }
		},
		plotOptions : {
			spline : {
				lineWidth : 3,
				states : {
					hover : {
						lineWidth : 4
					}
				},
				marker : {
					enabled : false
				}
			}
		},
		series : seriesInput,
		colors: ["#ff6633","#995831","#6633ff","#19986d","#0066cc","#cc3333"]
	};
	

	var netChartOutput = {
		legend: {
			align: 'right',
			verticalAlign: 'middle',
			width: 160,
			itemWidth:80,
			borderWidth:1,
			symbolWidth:30,
			borderRadius:5,
			borderWidth:1,
			itemHoverStyle: {
				color: '#33b086'
			},
			x:-30
        },
		credits : {
			enabled : false
		},
		chart : {
			type : 'spline'
		},
		title : {
			text : titleOutput
		},
		xAxis : {
			type : 'datetime',
			labels : {
				formatter: function() {
					if(this.dateTimeLabelFormat=='%H:%M'){
						return Highcharts.dateFormat('%H:%M' , this.value);
					}else{
						return Highcharts.dateFormat('%m-%d %H:%M', this.value);
					}
		        }
			}
		},
		yAxis : {
			title: {
	        	text: ''
	        },
			gridLineWidth : 0,
			min:0,
			labels : {
				formatter: function() {
					return this.value;
		        }
			}
		},
		tooltip : {
			formatter: function() {
		            var s = Highcharts.dateFormat('%Y-%m-%d %H:%M:%S', this.x)+"<br/><strong><font color='"+this.series.color+"'>"+this.series.name+"</font>："+this.y+"MB</strong>";
		            return s;
		        }
		},
		plotOptions : {
			spline : {
				lineWidth : 3,
				states : {
					hover : {
						lineWidth : 4
					}
				},
				marker : {
					enabled : false
				}
			}
		},
		series : seriesOutput,
		colors: ["#ff6633","#995831","#6633ff","#19986d","#0066cc","#cc3333"]
	};
	$('#netInput').highcharts(netChartInput);
	$('#netOutput').highcharts(netChartOutput);
}

function getInputNetSeriesList(data){
	seriesList = new Array();
	$.each(data,function(name,item){
		var x = new Array();
		$.each(item,function(i,net){
			var s = new Date(net.time);
			x.push([Date.UTC(format(s,"yyyy"), parseInt(format(s,"MM"))-1, format(s,"dd"), format(s, "HH"), format(s, "mm"), format(s, "ss")), net.in_bytes]);
		});
		seriesList.push({
			name : name,
			data : x
		});
	})
	
	return seriesList;
}

function getOutputNetSeriesList(data){
	seriesList = new Array();
	$.each(data,function(name,item){
		var x = new Array();
		$.each(item,function(i,net){
			var s = new Date(net.time);
			x.push([Date.UTC(format(s,"yyyy"), parseInt(format(s,"MM"))-1, format(s,"dd"), format(s, "HH"), format(s, "mm"), format(s, "ss")), net.out_bytes]);
		});
		seriesList.push({
			name : name,
			data : x
		});
	})
	
	return seriesList;
}

function buildLoadHistorys(series) {
	$('.network').hide();
	$('.monitor').show();
	
	var cpuChart = 	{
		legend: {
			borderWidth:1,
			symbolWidth:30,
			borderRadius:5,
			borderWidth:1,
			itemHoverStyle: {
				color: '#33b086'
			},
        },
		credits : {
			enabled : false
		},
		chart : {
			type : 'spline'
		},
		title : {
			text : '负载使用情况'
		},
		xAxis : {
			type : 'datetime',
			labels : {
				formatter: function() {
					if(this.dateTimeLabelFormat=='%H:%M'){
						return Highcharts.dateFormat('%H:%M' , this.value);
					}else{
						return Highcharts.dateFormat('%m-%d %H:%M', this.value);
					}
		        }
			}
		},
		yAxis : {
			title: {
	        	text: ''
	        },
			gridLineWidth : 0,
			labels : {
				formatter: function() {
					return this.value;
		        }
			}
		},
		tooltip : {
			formatter: function() {
		            var s = Highcharts.dateFormat('%Y-%m-%d %H:%M:%S', this.x)+"<br/><strong><font color='"+this.series.color+"'>"+this.series.name+"</font>："+this.y+"</strong>";
		            return s;
		        }
		},
		plotOptions : {
			spline : {
				lineWidth : 3,
				states : {
					hover : {
						lineWidth : 4
					}
				},
				marker : {
					enabled : false
				}
			}
		},
		series : series,
		colors: ["#995831","#6633ff","#19986d","#0066cc","#cc3333"]
	};
	$('#container').highcharts(cpuChart);
}

function getLoadSeriesList(data){
	var seriesList = new Array();
	var x1 = [];
	var x5 = [];
	var x15 = [];
	
	$.each(data,function(name,value){
		var s = new Date(value.time);
		var formatDate = Date.UTC(format(s,"yyyy"), parseInt(format(s,"MM"))-1, format(s,"dd"), format(s, "HH"), format(s, "mm"), format(s, "ss"));
		x1.push([formatDate, value.load.last_1min]);
		x5.push([formatDate, value.load.last_5min]);
		x15.push([formatDate, value.load.last_15min]);
	});
	seriesList.push({
		name : '1分钟负载',
		data:x1
	});
	seriesList.push({
		name : '5分钟负载',
		data:x5
	});
	seriesList.push({
		name : '15分钟负载',
		data:x15
	});
	return seriesList;
}

function getHistorys(){
	var waiting = $waiting("加载中...");
	$.ajax({
		   type: "POST",
		   url: "monitorHistorys.do",
		   data: $("#searchForm").serialize(),
		   success: function(json){
			   if(json.error){
					$(".monitor").show();
					$(".network").hide();
					
					$(".monitor").html(json.error);
					return;
				}
				if($("[name='type']").val() == "cpu"){
					buildCpuHistorys(getCpuSeriesList(json),"cpu使用率(%)");
				} else if($("[name='type']").val() == "mem"){
					buildCommonHistorys(getMemSeriesList(json),"内存使用情况(MB)","MB", "内存使用情况");
				} else if($("[name='type']").val() == "disk"){
					buildCommonHistorys(getDiskSeriesList(json),"磁盘使用情况(GB)","GB", "磁盘使用情况");
				} else if($("[name='type']").val() == "net"){
					buildNetHistorys(getInputNetSeriesList(json.input),getOutputNetSeriesList(json.output),"网卡流量接收情况(MB)", "网卡流量发送情况(MB)");
				} else if($("[name='type']").val() == "load"){
					buildLoadHistorys(getLoadSeriesList(json),"负载使用情况");
				}
		   },
			error : function(data){
				$alert('操作失败');
	  		},
			complete : function(XMLHttpRequest,status){
				waiting.close();
	  		}
		});
}

$(function () {
	initHighchartTable();
	getHistorys();
	
	$('#btn-search-down').click(function(){
		getHistorys();
	});

	$('#monitorBtn').click(function(){
		timeMonitor();
	});
});

function initHighchartTable(){
	$("table.highchart").highchartTable();
	$('.highcharts-background').css('display', 'none');
	$('.highcharts-background').css('position', 'static');
}

var format = function(time, format){
    var t = new Date(time);
    var tf = function(i){return (i < 10 ? '0' : '') + i};
    return format.replace(/yyyy|MM|dd|HH|mm|ss/g, function(a){
        switch(a){
            case 'yyyy':
                return tf(t.getFullYear());
                break;
            case 'MM':
                return tf(t.getMonth() + 1);
                break;
            case 'mm':
                return tf(t.getMinutes());
                break;
            case 'dd':
                return tf(t.getDate());
                break;
            case 'HH':
                return tf(t.getHours());
                break;
            case 'ss':
                return tf(t.getSeconds());
                break;
        }
    })
}