/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.cssp.ams.web.customer.action;

import com.xdja.cssp.ams.customer.entity.Customer;
import com.xdja.cssp.ams.customer.entity.CustomerUser;
import com.xdja.cssp.ams.customer.entity.CustomerUserCert;
import com.xdja.cssp.ams.customer.service.ICustomerService;
import com.xdja.cssp.ams.log.entity.SystemLog;
import com.xdja.cssp.ams.system.entity.TUser;
import com.xdja.cssp.ams.web.json.DataTablesParameters;
import com.xdja.cssp.ams.web.util.Constants;
import com.xdja.cssp.ams.web.util.EncoderUtil;
import com.xdja.platform.log.LoggerExtData;
import com.xdja.platform.rpc.consumer.refer.DefaultServiceRefer;
import com.xdja.platform.rpc.proxy.page.LitePaging;
import com.xdja.platform.security.utils.OperatorUtil;
import com.xdja.platform.security.utils.PasswordUtils;
import com.xdja.platform.web.action.BaseAction;
import java.util.HashMap;
import java.util.List;
import javax.servlet.http.HttpServletResponse;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
public class CustomerAccountAction
extends BaseAction {
    private ICustomerService customerService = (ICustomerService)DefaultServiceRefer.getServiceRefer(ICustomerService.class);

    @RequestMapping(value={"/customer/account/index.do"})
    public String index() {
        return "customer/account/index";
    }

    @RequestMapping(value={"/customer/account/ajaxList.do"})
    @ResponseBody
    public Object ajaxList(CustomerUser customerUser) {
        DataTablesParameters tables = DataTablesParameters.newInstance();
        String[] orderColumns = new String[]{"", "", "", "", "time", ""};
        LitePaging pagination = this.customerService.queryCustomerUsers(customerUser, Integer.valueOf(tables.getPage()), Integer.valueOf(tables.getLength()), tables.getOrderColName(orderColumns), tables.getOrderDir());
        return tables.getDataTablesReply(pagination);
    }

    @RequestMapping(value={"/customer/account/toAddAccount.do"})
    public String toAddAccount(ModelMap model) {
        List customerList = this.customerService.getAllCustomer();
        HashMap<String, String> customers = new HashMap<String, String>();
        for (Customer customer : customerList) {
            customers.put(customer.getId().toString(), customer.getName());
        }
        model.addAttribute("customers", customers);
        return "customer/account/add";
    }

    @RequestMapping(value={"/customer/account/checkAccount.do"})
    @ResponseBody
    public Object checkAccount(Long customerUserId, String account) {
        try {
            return this.customerService.isAccountExist(customerUserId, account) ? EncoderUtil.encode((String)"\u5e10\u6237\u5df2\u5b58\u5728") : "success";
        }
        catch (Exception e) {
            this.logger.error("\u670d\u52a1\u5f02\u5e38", (Throwable)e);
            return EncoderUtil.encode((String)Constants.SERVICE_BREAKE);
        }
    }

    @RequestMapping(value={"/customer/account/toEditAccount.do"})
    public String toEditAccount(Long CustomerUserId, ModelMap model) {
        CustomerUser customerUser = this.customerService.getCustomerUserById(CustomerUserId);
        List customerList = this.customerService.getAllCustomer();
        HashMap<String, String> customers = new HashMap<String, String>();
        for (Customer customer : customerList) {
            customers.put(customer.getId().toString(), customer.getName());
        }
        model.addAttribute("customers", customers);
        model.addAttribute("customerUser", (Object)customerUser);
        return "customer/account/edit";
    }

    @RequestMapping(value={"/customer/account/saveAccount.do"})
    public void saveCustomerUser(CustomerUser customerUser, HttpServletResponse response) {
        HashMap<String, String> result = new HashMap<String, String>();
        TUser currUser = (TUser)OperatorUtil.getOperator().getCurrUser();
        try {
            Customer customer = this.customerService.getCustomerById(customerUser.getCustomerId());
            LoggerExtData extData = LoggerExtData.create((String)"modelType", (Object)SystemLog.ENUM_LOG_MODEL_TYPE.customerManagerLog.value);
            extData.put("logType", (Object)9);
            extData.put("client", (Object)customer.getName());
            extData.put("account", (Object)customerUser.getAccount());
            if (null == customerUser.getId()) {
                customerUser.setAccountStatus(CustomerUser.ENUM_ACOUNT_STATUS.on.value);
                customerUser.setTime(Long.valueOf(System.currentTimeMillis()));
                customerUser.setPassword(PasswordUtils.encodePasswordSHA1((String)"111111"));
                this.customerService.saveCustomerUser(customerUser);
                this.logger.info(SystemLog.ENUM_LOG_TYPE.operateLog.value.intValue(), extData, "\u7ba1\u7406\u5458{}\u4e3a\u5ba2\u6237{}\u6dfb\u52a0\u8d26\u6237{}\u6210\u529f", new Object[]{currUser.getUserName(), customer.getName(), customerUser.getAccount()});
            } else {
                this.customerService.saveCustomerUser(customerUser);
                this.logger.info(SystemLog.ENUM_LOG_TYPE.operateLog.value.intValue(), extData, "\u7ba1\u7406\u5458{}\u4e3a\u5ba2\u6237{}\u4fee\u6539\u8d26\u6237{}\u6210\u529f", new Object[]{currUser.getUserName(), customer.getName(), customerUser.getAccount()});
            }
            result.put("message", "success");
        }
        catch (Exception e) {
            this.logger.error("\u7ba1\u7406\u5458{}\u4fdd\u5b58\u8d26\u6237{}\u5931\u8d25", new Object[]{currUser.getName(), customerUser.getAccount(), e});
            result.put("message", "\u6267\u884c\u5931\u8d25");
        }
        this.renderJson(response, this.toJsonStr(result));
    }

    @RequestMapping(value={"/customer/account/pauseAccount.do"})
    public void pauseAccount(HttpServletResponse response, Long customerUserId) {
        String message;
        TUser currUser = (TUser)OperatorUtil.getOperator().getCurrUser();
        try {
            CustomerUser customerUser = this.customerService.getCustomerUserById(customerUserId);
            Customer customer = this.customerService.getCustomerById(customerUser.getCustomerId());
            this.customerService.changeAccountStatus(customerUserId, CustomerUser.ENUM_ACOUNT_STATUS.stop.value);
            message = "success";
            LoggerExtData extData = LoggerExtData.create((String)"modelType", (Object)SystemLog.ENUM_LOG_MODEL_TYPE.customerManagerLog.value);
            extData.put("logType", (Object)9);
            extData.put("client", (Object)customer.getName());
            extData.put("account", (Object)customerUser.getAccount());
            this.logger.info(SystemLog.ENUM_LOG_TYPE.operateLog.value.intValue(), extData, "\u7ba1\u7406\u5458{}\u505c\u7528\u5ba2\u6237{}\u7684\u8d26\u6237{}\u6210\u529f", new Object[]{currUser.getUserName(), customer.getName(), customerUser.getAccount()});
        }
        catch (Exception e) {
            this.logger.info("\u7ba1\u7406\u5458{}\u6682\u505c\u8d26\u6237\u51fa\u9519", (Object)currUser.getName(), (Object)e);
            message = "\u6682\u505c\u8d26\u6237\u51fa\u9519";
        }
        this.renderText(response, message);
    }

    @RequestMapping(value={"/customer/account/startAccount.do"})
    public void startAccount(HttpServletResponse response, Long customerUserId) {
        String message;
        TUser currUser = (TUser)OperatorUtil.getOperator().getCurrUser();
        try {
            CustomerUser customerUser = this.customerService.getCustomerUserById(customerUserId);
            Customer customer = this.customerService.getCustomerById(customerUser.getCustomerId());
            this.customerService.changeAccountStatus(customerUserId, CustomerUser.ENUM_ACOUNT_STATUS.on.value);
            message = "success";
            LoggerExtData extData = LoggerExtData.create((String)"modelType", (Object)SystemLog.ENUM_LOG_MODEL_TYPE.customerManagerLog.value);
            extData.put("logType", (Object)9);
            extData.put("client", (Object)customer.getName());
            extData.put("account", (Object)customerUser.getAccount());
            this.logger.info(SystemLog.ENUM_LOG_TYPE.operateLog.value.intValue(), extData, "\u7ba1\u7406\u5458{}\u542f\u7528\u5ba2\u6237{}\u7684\u8d26\u6237{}\u6210\u529f", new Object[]{currUser.getUserName(), customer.getName(), customerUser.getAccount()});
        }
        catch (Exception e) {
            this.logger.info("\u7ba1\u7406\u5458{}\u542f\u7528\u8d26\u6237\u51fa\u9519", (Object)currUser.getName(), (Object)e);
            message = "\u542f\u52a8\u8d26\u6237\u51fa\u9519";
        }
        this.renderText(response, message);
    }

    @RequestMapping(value={"/customer/account/toBind.do"})
    public String toBind(Long customerUserId, ModelMap modelMap) {
        TUser currentUser = (TUser)OperatorUtil.getOperator().getCurrUser();
        modelMap.put((Object)"customerUserId", (Object)customerUserId);
        modelMap.put((Object)"loginUserCardId", (Object)currentUser.getCardId());
        return "customer/account/bind";
    }

    @RequestMapping(value={"/customer/account/ajaxCardList.do"})
    @ResponseBody
    public Object ajaxCardList(Long customerUserId) {
        DataTablesParameters tables = DataTablesParameters.newInstance();
        String[] orderColumns = new String[]{"", "cardId", "note"};
        LitePaging pagination = this.customerService.queryAllCustomerUserCert(customerUserId, Integer.valueOf(tables.getPage()), Integer.valueOf(tables.getLength()), tables.getOrderColName(orderColumns), tables.getOrderDir());
        return tables.getDataTablesReply(pagination);
    }

    @RequestMapping(value={"/customer/account/getCardSn.do"})
    public void getCardSn(String cert, HttpServletResponse response) {
        String result = "";
        try {
            Object[] certArray = this.customerService.queryCustomerUserCertByCardId(cert);
            result = !((Boolean)certArray[2]).booleanValue() ? "{\"flag\":\"success\",\"sn\":\"" + certArray[1] + "\",\"cardId\":\"" + certArray[0] + "\"}" : "{\"flag\":\"error\", \"message\":\"\u5b89\u5168\u5361\u5df2\u88ab\u4f7f\u7528\"}";
        }
        catch (Exception e) {
            result = "{\"flag\":\"error\", \"message\":\"\u5b89\u5168\u5361\u6821\u9a8c\u5931\u8d25\"}";
            this.logger.info("\u5b89\u5168\u5361\u6821\u9a8c\u65f6\u5f02\u5e38\uff0c\u9519\u8bef\u4fe1\u606f\u4e3a", (Throwable)e);
        }
        this.renderJson(response, result);
    }

    @RequestMapping(value={"/customer/account/saveCard.do"})
    public void saveCard(CustomerUserCert customerUserCert, HttpServletResponse response) {
        String message = "success";
        TUser currUser = (TUser)OperatorUtil.getOperator().getCurrUser();
        try {
            this.customerService.saveCustomerUserCert(customerUserCert);
            CustomerUser customerUser = this.customerService.getCustomerUserById(customerUserCert.getCustomerUserId());
            LoggerExtData extData = LoggerExtData.create((String)"modelType", (Object)SystemLog.ENUM_LOG_MODEL_TYPE.customerManagerLog.value);
            extData.put("logType", (Object)6);
            extData.put("userType", (Object)"\u5ba2\u6237\u8d26\u6237");
            extData.put("user", (Object)customerUser.getAccount());
            extData.put("card", (Object)customerUserCert.getCardId());
            this.logger.info(SystemLog.ENUM_LOG_TYPE.operateLog.value.intValue(), extData, "\u7ba1\u7406\u5458{}\u4e3a\u8d26\u6237{}\u7ed1\u5b9a\u5b89\u5168\u5361{}\u6210\u529f", new Object[]{currUser.getUserName(), customerUser.getAccount(), customerUserCert.getCardId()});
        }
        catch (IllegalArgumentException e) {
            message = "\u5361\u7ed1\u5b9a\u5931\u8d25";
            this.logger.info("\u5361\u7ed1\u5b9a\u65f6\uff0c\u53c2\u6570\u5f02\u5e38", (Throwable)e);
        }
        catch (Exception e) {
            message = "\u5361\u7ed1\u5b9a\u5931\u8d25";
            this.logger.info("\u5361\u7ed1\u5b9a\u65f6\u64cd\u4f5c\u65f6\u5f02\u5e38", (Throwable)e);
        }
        this.renderText(response, message);
    }

    @RequestMapping(value={"/customer/account/deleteCard.do"})
    public void deleteCard(String userCertId, String customerUserId, HttpServletResponse response) {
        String message = "success";
        TUser currUser = (TUser)OperatorUtil.getOperator().getCurrUser();
        try {
            CustomerUserCert userCert = this.customerService.queryUserCertById(Long.valueOf(userCertId));
            this.customerService.deleteUserCertById(userCertId);
            CustomerUser customerUser = this.customerService.getCustomerUserById(userCert.getCustomerUserId());
            LoggerExtData extData = LoggerExtData.create((String)"modelType", (Object)SystemLog.ENUM_LOG_MODEL_TYPE.customerManagerLog.value);
            extData.put("logType", (Object)6);
            extData.put("userType", (Object)"\u5ba2\u6237\u8d26\u6237");
            extData.put("user", (Object)customerUser.getAccount());
            extData.put("card", (Object)userCert.getCardId());
            this.logger.info(SystemLog.ENUM_LOG_TYPE.operateLog.value.intValue(), extData, "\u7ba1\u7406\u5458{}\u4e3a\u8d26\u6237{}\u64a4\u9500\u5b89\u5168\u5361{}\u6210\u529f", new Object[]{currUser.getUserName(), customerUser.getAccount(), userCert.getCardId()});
        }
        catch (IllegalArgumentException e) {
            message = "\u64a4\u9500\u5361\u7ed1\u5b9a\u5931\u8d25";
            this.logger.info("\u64a4\u9500\u7528\u6237\u7ed1\u5b9a\u5361\u65f6\uff0c\u53c2\u6570\u5f02\u5e38", (Throwable)e);
        }
        catch (Exception e) {
            message = "\u64a4\u9500\u5361\u7ed1\u5b9a\u5931\u8d25";
            this.logger.info("\u5361\u7ed1\u5b9a\u65f6\u64cd\u4f5c\u65f6\u5f02\u5e38", (Throwable)e);
        }
        this.renderText(response, message);
    }
}

