/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.cssp.ams.web.log.listener;

import com.xdja.cssp.ams.log.entity.SystemLog;
import com.xdja.cssp.ams.log.service.ISystemLogService;
import com.xdja.cssp.ams.system.entity.TUser;
import com.xdja.log.analysis.format.sdk.service.record.AMSRecord;
import com.xdja.platform.log.LogListener;
import com.xdja.platform.log.LoggingEvent;
import com.xdja.platform.rpc.consumer.refer.DefaultServiceRefer;
import com.xdja.platform.security.utils.OperatorUtil;
import java.util.Map;
import org.springframework.stereotype.Service;

@Service
public class SystemLogListenerImpl
implements LogListener {
    private ISystemLogService systemLogService = (ISystemLogService)DefaultServiceRefer.getServiceRefer(ISystemLogService.class);

    public void log(LoggingEvent event) {
        TUser user = (TUser)OperatorUtil.getOperator().getCurrUser();
        SystemLog log = new SystemLog();
        Map extData = event.getExtData();
        log.setUserId(user.getId());
        log.setUserName(user.getUserName());
        log.setUserIp(user.getLoginIp());
        if (null != extData && null != extData.get("modelType")) {
            log.setModelType((Integer)extData.get("modelType"));
        }
        log.setLogContent(event.getContent());
        log.setLogLevel(Integer.valueOf(SystemLog.ENUM_LOG_LEVEL.valueOf((String)event.getLevel()).value));
        log.setLogType(Integer.valueOf(event.getType()));
        log.setClassName(event.getClassName());
        log.setMethodInfo(event.getMethod());
        log.setLogTime(Long.valueOf(event.getTime()));
        this.systemLogService.saveSystemLog(log);
        if (null != extData && null != extData.get("logType")) {
            this.logAnalysis(user, extData, event.getContent());
        }
    }

    public void logAnalysis(TUser user, Map<String, Object> extData, String logContent) {
        Integer modelType = (Integer)extData.get("logType");
        switch (modelType) {
            case 1: {
                AMSRecord.Login((String)user.getUserName());
                return;
            }
            case 2: {
                AMSRecord.Logout((String)user.getUserName(), (String)logContent);
                return;
            }
            case 3: {
                AMSRecord.ChangePwd((String)user.getUserName());
                return;
            }
            case 4: {
                AMSRecord.ChangeRole((String)user.getUserName(), (String)((String)extData.get("role")), (String)logContent);
                return;
            }
            case 5: {
                AMSRecord.ChangeUser((String)user.getUserName(), (String)((String)extData.get("user")), (String)logContent);
                return;
            }
            case 6: {
                AMSRecord.BindingCard((String)user.getUserName(), (String)((String)extData.get("userType")), (String)((String)extData.get("user")), (String)((String)extData.get("card")), (String)logContent);
                return;
            }
            case 7: {
                AMSRecord.ChangeDict((String)user.getUserName(), (String)((String)extData.get("dict")), (String)logContent);
                return;
            }
            case 8: {
                AMSRecord.ChangeClient((String)user.getUserName(), (String)((String)extData.get("client")), (String)logContent);
                return;
            }
            case 9: {
                AMSRecord.ChangeClientAccount((String)user.getUserName(), (String)((String)extData.get("client")), (String)((String)extData.get("account")), (String)logContent);
                return;
            }
            case 10: {
                AMSRecord.AssetImport((String)user.getUserName(), (String)logContent);
                return;
            }
            case 11: {
                AMSRecord.ChangeCE((String)user.getUserName(), (String)logContent);
                return;
            }
            case 12: {
                AMSRecord.ChipActivation((String)user.getUserName(), (String)logContent);
                return;
            }
        }
    }
}

