/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.cssp.ams.web.resolve.impl;

import com.xdja.cssp.ams.web.resolve.ResolveData;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.dom4j.Attribute;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;

public class Dom4jResolveImpl
implements ResolveData {
    private Map<String, String> elementValue = new HashMap();
    private Map<String, String> attributeValue = new HashMap();
    private Document doc;
    private String rootName;

    public boolean exists(String elementName) {
        return this.elementValue.containsKey(elementName);
    }

    public String getAttribute(String attributeName) {
        return (String)this.attributeValue.get(attributeName);
    }

    public String getElementValue(String elementName) {
        return (String)this.elementValue.get(elementName);
    }

    public List<String> getElementList(String elementName) {
        ArrayList<String> list = new ArrayList<String>();
        if (StringUtils.isBlank((CharSequence)elementName)) {
            return list;
        }
        if (this.elementValue.containsKey(elementName)) {
            list.add((String)this.elementValue.get(elementName));
        } else if (this.elementValue.containsKey(elementName + "[1]")) {
            int count = 1;
            String key = "";
            while (this.elementValue.containsKey(key = elementName + "[" + count + "]")) {
                list.add((String)this.elementValue.get(key));
                ++count;
            }
        }
        return list;
    }

    public Element getRootElement() {
        return this.doc.getRootElement();
    }

    public void loadSource(String xml) throws Exception {
        SAXReader reader = new SAXReader();
        StringReader sReader = new StringReader(xml);
        try {
            this.doc = reader.read((Reader)sReader);
            Element rootElement = this.doc.getRootElement();
            this.rootName = rootElement.getName();
            this.elementValue.put(this.rootName, rootElement.getText());
            Attribute attribute = null;
            Iterator iterator = rootElement.attributeIterator();
            while (iterator.hasNext()) {
                attribute = (Attribute)iterator.next();
                if (null == attribute) continue;
                this.attributeValue.put(this.rootName + "." + attribute.getName(), attribute.getText());
            }
            this.bulidElement(rootElement);
        }
        catch (DocumentException e) {
            throw e;
        }
        finally {
            try {
                if (null != sReader) {
                    ((Reader)sReader).close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public void loadSourceFromFile(String fileName) throws Exception {
        SAXReader reader = new SAXReader();
        this.doc = reader.read(new File(fileName));
        Element rootElement = this.doc.getRootElement();
        this.rootName = rootElement.getName();
        this.elementValue.put(this.rootName, rootElement.getText());
        Attribute attribute = null;
        Iterator iterator = rootElement.attributeIterator();
        while (iterator.hasNext()) {
            attribute = (Attribute)iterator.next();
            if (null == attribute) continue;
            this.attributeValue.put(this.rootName + "." + attribute.getName(), attribute.getText());
        }
        this.bulidElement(rootElement);
    }

    public void loadSourceFromFile(File file) throws Exception {
        SAXReader reader = new SAXReader();
        this.doc = reader.read(file);
        Element rootElement = this.doc.getRootElement();
        this.rootName = rootElement.getName();
        this.elementValue.put(this.rootName, rootElement.getText());
        Attribute attribute = null;
        Iterator iterator = rootElement.attributeIterator();
        while (iterator.hasNext()) {
            attribute = (Attribute)iterator.next();
            if (null == attribute) continue;
            this.attributeValue.put(this.rootName + "." + attribute.getName(), attribute.getText());
        }
        this.bulidElement(rootElement);
    }

    public String getRootName() {
        return this.rootName;
    }

    private void bulidElement(Element element) {
        Element item = null;
        Attribute attribute = null;
        Iterator childElement = element.elementIterator();
        while (childElement.hasNext()) {
            item = (Element)childElement.next();
            if (null != item) {
                String key = this.constructElementKey(item.getUniquePath());
                this.elementValue.put(key, item.getText());
                Iterator iterator = item.attributeIterator();
                while (iterator.hasNext()) {
                    attribute = (Attribute)iterator.next();
                    if (null == attribute) continue;
                    this.attributeValue.put(key + "." + attribute.getName(), attribute.getValue());
                }
            }
            this.bulidElement(item);
        }
    }

    private String constructElementKey(String elementKey) {
        if (StringUtils.isBlank((CharSequence)elementKey)) {
            return "";
        }
        return elementKey.substring(1, elementKey.length()).replace("/", ".");
    }

    public static void main(String[] args) throws Exception {
        StringBuffer xml = new StringBuffer();
        xml.append("<root>");
        xml.append("<mail>");
        xml.append("wuyongfei@xdja.com");
        xml.append("</mail>");
        xml.append("<mail>");
        xml.append("wuyongfei@163.com");
        xml.append("</mail>");
        xml.append("<mail>");
        xml.append("<data id=\"test\">");
        xml.append("1\u6d4b\u8bd5\u6570\u636edata1");
        xml.append("</data>");
        xml.append("<data>");
        xml.append("1\u6d4b\u8bd5\u6570\u636edata2");
        xml.append("</data>");
        xml.append("<data>");
        xml.append("1\u6d4b\u8bd5\u6570\u636edata3");
        xml.append("</data>");
        xml.append("</mail>");
        xml.append("<mail>");
        xml.append("<data>");
        xml.append("\u6d4b\u8bd5\u6570\u636edata1");
        xml.append("</data>");
        xml.append("<data>");
        xml.append("\u6d4b\u8bd5\u6570\u636edata2");
        xml.append("</data>");
        xml.append("<data>");
        xml.append("\u6d4b\u8bd5\u6570\u636edata3");
        xml.append("</data>");
        xml.append("</mail>");
        xml.append("<type>");
        xml.append("aaa");
        xml.append("</type>");
        xml.append("</root>");
        Dom4jResolveImpl resolve = new Dom4jResolveImpl();
        resolve.loadSource(xml.toString());
        List list = resolve.getElementList("root.mail[3].data");
        for (String item : list) {
            System.out.println(item + " ==");
        }
    }

    public void loadSourceFromFile(InputStream in) throws Exception {
        SAXReader reader = new SAXReader();
        this.doc = reader.read(in);
        Element rootElement = this.doc.getRootElement();
        this.rootName = rootElement.getName();
        this.elementValue.put(this.rootName, rootElement.getText());
        Attribute attribute = null;
        Iterator iterator = rootElement.attributeIterator();
        while (iterator.hasNext()) {
            attribute = (Attribute)iterator.next();
            if (null == attribute) continue;
            this.attributeValue.put(this.rootName + "." + attribute.getName(), attribute.getText());
        }
        this.bulidElement(rootElement);
    }
}

