/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.cssp.open.system.business.impl;

import com.xdja.cssp.open.core.util.ReturnCodeUtil;
import com.xdja.cssp.open.developer.dao.DeveloperInfoDao;
import com.xdja.cssp.open.service.developer.entity.DeveloperInfo;
import com.xdja.cssp.open.system.business.IAccountInfoBusiness;
import com.xdja.cssp.open.system.dao.TAccountInfoDao;
import com.xdja.cssp.open.system.entity.TAccountInfo;
import com.xdja.cssp.open.system.entity.UserApplyBriefInfo;
import com.xdja.cssp.open.system.entity.UserSummaryInfo;
import com.xdja.cssp.open.system.util.DateQueryBean;
import com.xdja.cssp.open.utils.Constants;
import com.xdja.cssp.open.utils.MailUtil;
import com.xdja.cssp.open.utils.TimeUtil;
import com.xdja.cssp.open.utils.UUIDUtil;
import com.xdja.platform.redis.core.RedisClient;
import com.xdja.platform.security.utils.PasswordUtils;
import com.xdja.platform.util.DateTimeUtil;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.stereotype.Service;

@Service
public class AccountInfoBusinessImpl
implements IAccountInfoBusiness {
    @Autowired
    private TAccountInfoDao accountInfoDao;
    @Autowired
    private DeveloperInfoDao devInfoDao;
    @Resource
    private RedisClient redisClient;

    @Override
    public TAccountInfo getAccountInfoByAccountId(Long accountId) {
        try {
            return this.accountInfoDao.getAccountInfoByAccountId(accountId);
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    public void resetPwd(Long accountId) {
        this.accountInfoDao.resetPwd(accountId, PasswordUtils.encodePasswordSHA1((String)"111111"));
    }

    @Override
    public void forbiddenUser(Long accoutId) {
        this.accountInfoDao.forbiddenUser(accoutId, TAccountInfo.ENUM_USING_STATUS.stopStatus.value);
    }

    @Override
    public void startoverUser(Long accountId) {
        this.accountInfoDao.forbiddenUser(accountId, TAccountInfo.ENUM_USING_STATUS.normalStatus.value);
    }

    @Override
    public void deleteUser(Long accountId) {
        this.accountInfoDao.deleteUser(accountId, TAccountInfo.ENUM_DELETE_FLAG.deleteFlag.value);
    }

    @Override
    public ReturnCodeUtil checkEmailExist(String currEamil) {
        try {
            TAccountInfo accountInfo = this.accountInfoDao.getAccountInfoByEmail(currEamil);
            if (null != accountInfo.getStatus() && accountInfo.getDeleteFlag() == TAccountInfo.ENUM_DELETE_FLAG.deleteFlag.value) {
                return new ReturnCodeUtil(111, "\u8be5\u90ae\u7bb1\u5df2\u88ab\u7981\u7528");
            }
            if (null != accountInfo.getStatus() && accountInfo.getUsingStatus() == TAccountInfo.ENUM_USING_STATUS.stopStatus.value) {
                return new ReturnCodeUtil(103, "\u8be5\u90ae\u7bb1\u5df2\u88ab\u9501\u5b9a");
            }
            if (null != accountInfo.getStatus() && accountInfo.getStatus() == TAccountInfo.ENUM_ACCOUNT_STATUS.registered.value) {
                return new ReturnCodeUtil(104, "\u8be5\u90ae\u7bb1\u5df2\u6ce8\u518c");
            }
            if (null != accountInfo.getStatus()) {
                return new ReturnCodeUtil(105, "\u8be5\u90ae\u7bb1\u5df2\u6ce8\u518c");
            }
        }
        catch (EmptyResultDataAccessException e) {
            return new ReturnCodeUtil();
        }
        catch (Exception e) {
            throw new RuntimeException();
        }
        return new ReturnCodeUtil();
    }

    @Override
    public void register(String currEmail, String encodePasswordSHA1, String requestUrl) {
        if (StringUtils.isBlank((CharSequence)currEmail)) {
            throw new IllegalArgumentException("\u6ce8\u518c\u90ae\u7bb1\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)encodePasswordSHA1)) {
            throw new IllegalArgumentException("\u5bc6\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        }
        Long currTime = System.currentTimeMillis();
        String activeCode = UUIDUtil.getUUID();
        Long tokenExptime = System.currentTimeMillis();
        try {
            SimpleDateFormat df = new SimpleDateFormat("yyyy\u5e74MM\u6708dd\u65e5");
            String dateStr = df.format(new Date());
            String urlStr = "<a style=\"text-decoration:none\" href=\"" + Constants.OPEN_HTML_URL + "open/index.html#/home/activationResult?email=" + currEmail + "&activeCode=" + activeCode + "\">" + Constants.OPEN_HTML_URL + "open/index.html#/home/activationResult?email=" + currEmail + "&activeCode=" + activeCode + "</a>";
            String str = Constants.REGISTER_EMAIL_CONTENT1 + currEmail + Constants.REGISTER_EMAIL_CONTENT3 + urlStr + Constants.REGISTER_EMAIL_CONTENT5 + Constants.COMMON_MAIL_CONTENT1 + dateStr + Constants.COMMON_MAIL_CONTENT2;
            MailUtil.sendHTMLMail((String)Constants.FROM_MAIL_ADDRESS, (String)currEmail, (String)Constants.REGISTER_EMAIL_SUBJECT, (String)str);
            this.accountInfoDao.register(currEmail, encodePasswordSHA1, currTime, activeCode, tokenExptime);
        }
        catch (Exception e) {
            throw new RuntimeException("\u53d1\u9001\u6fc0\u6d3b\u90ae\u4ef6\u5931\u8d25", e);
        }
    }

    @Override
    public ReturnCodeUtil getActiveNote(String email, String currActiveCode) {
        TAccountInfo info = this.accountInfoDao.getActiveCodeByEmail(email);
        if (TAccountInfo.ENUM_ACCOUNT_STATUS.registered.value != info.getStatus()) {
            return new ReturnCodeUtil(108, "\u8d26\u53f7\u5df2\u6fc0\u6d3b");
        }
        if (!StringUtils.equals((CharSequence)currActiveCode, (CharSequence)info.getActiveCode())) {
            return new ReturnCodeUtil(104, "\u6fc0\u6d3b\u7801\u4e0d\u6b63\u786e");
        }
        Long differTime = DateTimeUtil.getCurrentTime() - info.getTokenExptime();
        if (differTime > Constants.TOKENEXPTIME) {
            return new ReturnCodeUtil(105, "\u6fc0\u6d3b\u7801\u5df2\u5931\u6548");
        }
        try {
            if (email.endsWith("@xdja.com")) {
                this.accountInfoDao.updateAccountStatus(TAccountInfo.ENUM_ACCOUNT_STATUS.auditThrough.value, email);
                DeveloperInfo devInfo = new DeveloperInfo();
                devInfo.setAccType(Integer.valueOf(1));
                devInfo.setMobile("");
                devInfo.setDevAccId(info.getId());
                devInfo.setDevType(Integer.valueOf(1));
                this.devInfoDao.save((Object)devInfo);
            } else {
                this.accountInfoDao.updateAccountStatus(TAccountInfo.ENUM_ACCOUNT_STATUS.activated.value, email);
            }
            return new ReturnCodeUtil((Object)"\u6fc0\u6d3b\u6210\u529f");
        }
        catch (Exception e) {
            return new ReturnCodeUtil(107, "\u6fc0\u6d3b\u5931\u8d25");
        }
    }

    @Override
    public ReturnCodeUtil ajaxAccountInfoList(Long pageNum, int pageSize, TAccountInfo condition, DateQueryBean queryBean) {
        List<TAccountInfo> dataList = this.accountInfoDao.ajaxAccountInfoList(pageNum, pageSize, condition, queryBean);
        Long parseLong = this.accountInfoDao.getCountInfo(pageNum, pageSize, condition, queryBean);
        return new ReturnCodeUtil(parseLong, pageNum, pageSize, dataList);
    }

    @Override
    public TAccountInfo getAccountInfoByEmail(String email) {
        TAccountInfo accountInfo = this.accountInfoDao.getAccountInfoByEmail(email);
        List redisValue = this.redisClient.hmget(Constants.OPEN_APP_INFO, new String[]{"dev_user_" + accountInfo.getId() + "_status"});
        if (null != redisValue && redisValue.size() > 0 && null != redisValue.get(0) && ((String)redisValue.get(0)).equalsIgnoreCase(String.valueOf(accountInfo.getStatus()))) {
            accountInfo.setStatusFlag(true);
        }
        return accountInfo;
    }

    @Override
    public ReturnCodeUtil sendVerifyEmail(String email, String requestUrl) {
        ReturnCodeUtil returnCode = this.checkEmailExist(email);
        if (returnCode.isResult()) {
            return new ReturnCodeUtil(102, "\u8be5\u90ae\u7bb1\u4e0d\u5b58\u5728");
        }
        String resetCode = UUIDUtil.getUUID();
        Long resetTime = System.currentTimeMillis();
        try {
            SimpleDateFormat df = new SimpleDateFormat("yyyy\u5e74MM\u6708dd\u65e5");
            String dateStr = df.format(new Date());
            String urlStr = "<a style=\"text-decoration:none\" href=\"" + Constants.OPEN_HTML_URL + "open/index.html#/home/resetPwd?email=" + email + "&resetCode=" + resetCode + "\">" + Constants.OPEN_HTML_URL + "open/index.html#/home/resetPwd?email=" + email + "&resetCode=" + resetCode + "</a>";
            StringBuffer strBuffer = new StringBuffer().append(Constants.FORGET_EMAIL_CONTENT1).append(email).append(Constants.FORGET_EMAIL_CONTENT3).append(urlStr).append(Constants.FORGET_EMAIL_CONTENT5).append(Constants.COMMON_MAIL_CONTENT1).append(dateStr).append(Constants.COMMON_MAIL_CONTENT2);
            MailUtil.sendHTMLMail((String)Constants.FROM_MAIL_ADDRESS, (String)email, (String)Constants.FORGET_EMAIL_SUBJECT, (String)strBuffer.toString());
            this.accountInfoDao.updateResetPwd(email, resetCode, resetTime);
            return new ReturnCodeUtil((Object)email);
        }
        catch (Exception e) {
            e.printStackTrace();
            return new ReturnCodeUtil(103, "\u53d1\u9001\u91cd\u7f6e\u5bc6\u7801\u9a8c\u8bc1\u90ae\u4ef6\u5931\u8d25");
        }
    }

    @Override
    public ReturnCodeUtil resetPwd(String email, String password) {
        try {
            this.accountInfoDao.resetPwd(email, password);
            this.accountInfoDao.updateResetPwdTime(email);
            return new ReturnCodeUtil((Object)"\u91cd\u7f6e\u5bc6\u7801\u6210\u529f");
        }
        catch (Exception e) {
            return new ReturnCodeUtil(104, "\u91cd\u7f6e\u5bc6\u7801\u5931\u8d25");
        }
    }

    @Override
    public ReturnCodeUtil verifyResetCode(String email, String resetCode) {
        TAccountInfo accountInfo = this.accountInfoDao.getAccountInfoByEmail(email);
        if (!StringUtils.equals((CharSequence)email, (CharSequence)accountInfo.getEmail())) {
            return new ReturnCodeUtil(103, "\u4f60\u7684\u91cd\u7f6e\u5bc6\u7801\u94fe\u63a5\u4e0d\u6b63\u786e");
        }
        if (!StringUtils.equals((CharSequence)resetCode, (CharSequence)accountInfo.getResetCode())) {
            return new ReturnCodeUtil(104, "\u4f60\u7684\u91cd\u7f6e\u5bc6\u7801\u94fe\u63a5\u5df2\u5931\u6548");
        }
        Long differTime = DateTimeUtil.getCurrentTime() - accountInfo.getResetTime();
        if (differTime > Constants.RESETCODEEXPTIME) {
            return new ReturnCodeUtil(105, "\u4f60\u7684\u91cd\u7f6e\u5bc6\u7801\u94fe\u63a5\u8d85\u8fc77\u5929\uff0c\u5df2\u5931\u6548");
        }
        return new ReturnCodeUtil((Object)"\u91cd\u7f6e\u5bc6\u7801\u9a8c\u8bc1\u7801\u6821\u9a8c\u6210\u529f");
    }

    @Override
    public void resendActivateEmail(String email, String requestUrl) {
        String activeCode = UUIDUtil.getUUID();
        Long tokenExptime = System.currentTimeMillis();
        try {
            SimpleDateFormat df = new SimpleDateFormat("yyyy\u5e74MM\u6708dd\u65e5");
            String dateStr = df.format(new Date());
            String urlStr = "<a style=\"text-decoration:none\" href=\"" + Constants.OPEN_HTML_URL + "open/index.html#/home/activationResult?email=" + email + "&activeCode=" + activeCode + "\">" + Constants.OPEN_HTML_URL + "open/index.html#/home/activationResult?email=" + email + "&activeCode=" + activeCode + "</a>";
            String str = Constants.REGISTER_EMAIL_CONTENT1 + email + Constants.REGISTER_EMAIL_CONTENT3 + urlStr + Constants.REGISTER_EMAIL_CONTENT5 + Constants.COMMON_MAIL_CONTENT1 + dateStr + Constants.COMMON_MAIL_CONTENT2;
            MailUtil.sendHTMLMail((String)Constants.FROM_MAIL_ADDRESS, (String)email, (String)Constants.REGISTER_EMAIL_SUBJECT, (String)str);
            this.accountInfoDao.resendActivate(activeCode, tokenExptime, email);
        }
        catch (Exception e) {
            throw new RuntimeException("\u53d1\u9001\u6fc0\u6d3b\u90ae\u4ef6\u5931\u8d25", e);
        }
    }

    @Override
    public void delRedisAudit(Long id) {
        this.redisClient.hdel(Constants.OPEN_APP_INFO, new String[]{"dev_user_" + id + "_status"});
    }

    @Override
    public TAccountInfo getPersonInfoByMail(String email) {
        return this.accountInfoDao.getPersonInfoByMail(email);
    }

    @Override
    public int updateUnActiveEmail(String oldEmail, String newEmail) {
        return this.accountInfoDao.updateUnActiveEmail(oldEmail, newEmail);
    }

    @Override
    public void addLoginErrorCache(String email) {
        String times = this.redisClient.get("open_login_error_" + email);
        if (StringUtils.isBlank((CharSequence)times)) {
            this.redisClient.setex("open_login_error_" + email, 600, String.valueOf(1));
        } else {
            this.redisClient.setex("open_login_error_" + email, 600, String.valueOf(Integer.parseInt(times) + 1));
        }
    }

    @Override
    public UserSummaryInfo getUserSummaryInfo(Long id) {
        UserSummaryInfo userSummaryInfo = new UserSummaryInfo();
        ArrayList infoList = new ArrayList();
        TreeMap userApplyMap = new TreeMap(new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                return o2.compareTo(o1);
            }
        });
        try {
            List<Map<String, Object>> result = this.accountInfoDao.getUserSummaryInfo(id);
            for (Map<String, Object> map : result) {
                userSummaryInfo.setUserName(map.get("userName") == null ? null : (String)map.get("userName"));
                userSummaryInfo.setEmail(map.get("email") == null ? null : (String)map.get("email"));
                userSummaryInfo.setDevType(map.get("devType") == null ? null : (Integer)map.get("devType"));
                userSummaryInfo.setRegistTime(map.get("registTime") == null ? null : (Long)map.get("registTime"));
                userSummaryInfo.setActivateTime(map.get("activateTime") == null ? null : (Long)map.get("activateTime"));
                userSummaryInfo.setApplyTime(map.get("applyTime") == null ? null : (Long)map.get("applyTime"));
                userSummaryInfo.setAuditTime(map.get("auditTime") == null ? null : (Long)map.get("auditTime"));
                userSummaryInfo.setCompanyName(map.get("companyName") == null ? null : (String)map.get("companyName"));
                userSummaryInfo.setOrgName(map.get("orgName") == null ? null : (String)map.get("orgName"));
                userSummaryInfo.setDevName(map.get("devName") == null ? null : (String)map.get("devName"));
                UserApplyBriefInfo userApplyBrifeInfo = new UserApplyBriefInfo();
                userApplyBrifeInfo.setAppName(map.get("appName") == null ? null : (String)map.get("appName"));
                userApplyBrifeInfo.setPackageName(map.get("packageName") == null ? null : (String)map.get("packageName"));
                userApplyBrifeInfo.setPlatform(map.get("platform") == null ? null : (Integer)map.get("platform"));
                userApplyBrifeInfo.setAuthTime(map.get("authTime") == null ? null : (Long)map.get("authTime"));
                if (map.get("authTime") == null) continue;
                String time = TimeUtil.longToDay((long)((Long)map.get("authTime")));
                List list = (List)userApplyMap.get(time);
                if (null == list || list.size() == 0) {
                    ArrayList<UserApplyBriefInfo> userList = new ArrayList<UserApplyBriefInfo>();
                    userList.add(userApplyBrifeInfo);
                    userApplyMap.put(time, userList);
                    continue;
                }
                list.add(userApplyBrifeInfo);
            }
            if (userApplyMap.size() != 0) {
                Iterator it = userApplyMap.entrySet().iterator();
                while (it.hasNext()) {
                    infoList.add(it.next().getValue());
                }
            }
            if (infoList.size() != 0) {
                userSummaryInfo.setApplyList(infoList);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return userSummaryInfo;
    }

    public static void main(String[] args) {
        System.out.println(TimeUtil.longToDay((long)1467595740570L));
        System.out.println(TimeUtil.longToDay((long)1467595740562L));
        System.out.println(TimeUtil.longToDay((long)1475045274797L));
    }
}

