/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.cssp.open.system.business.impl;

import com.xdja.cssp.open.core.util.ReturnCodeUtil;
import com.xdja.cssp.open.system.business.IAppInfoBusiness;
import com.xdja.cssp.open.system.cache.AppInfoCache;
import com.xdja.cssp.open.system.dao.TAppInfoDao;
import com.xdja.cssp.open.system.entity.TAppInfo;
import com.xdja.cssp.open.system.entity.TAppInfoCondition;
import com.xdja.cssp.open.system.entity.TAppInfoExtendBean;
import com.xdja.cssp.open.system.util.DateQueryBean;
import com.xdja.platform.log.LoggerFactory;
import com.xdja.platform.redis.core.RedisClient;
import com.xdja.platform.rpc.proxy.page.LitePaging;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class AppInfoBusinessImpl
implements IAppInfoBusiness {
    private static Logger logger = LoggerFactory.getLogger(AppInfoBusinessImpl.class);
    @Autowired(required=true)
    private TAppInfoDao appInfoDao;
    @Resource
    RedisClient redisClient;
    @Autowired
    private AppInfoCache cache;

    @Override
    public LitePaging<TAppInfo> queryInfoList(TAppInfo condition, Integer pageNo, Integer pageSize, String sortName, String sortType, DateQueryBean queryBean) {
        return null;
    }

    @Override
    public void revokeAuthorize(String appId) {
        try {
            this.cache.delAppInfo(appId);
            this.appInfoDao.updateAuthorizeStatus(appId, TAppInfo.ENUM_APP_STATUS.unAuthorized.value);
        }
        catch (Exception e) {
            throw new RuntimeException("\u64a4\u9500\u6388\u6743\u5931\u8d25", e);
        }
    }

    @Override
    public void startoverAuthorize(String appId) {
        this.appInfoDao.updateAuthorizeStatus(appId, TAppInfo.ENUM_APP_STATUS.authorized.value);
    }

    @Override
    public ReturnCodeUtil ajaxAppInfoList(TAppInfoExtendBean appInfoExtendBean, Long pageNum, int pageSize, DateQueryBean queryBean) {
        try {
            List<TAppInfo> appInfoList = this.appInfoDao.ajaxAppInfoList(appInfoExtendBean, pageNum, pageSize, queryBean);
            Long parseLong = this.appInfoDao.queryCountInfo(appInfoExtendBean, pageNum, pageSize, queryBean);
            return new ReturnCodeUtil(parseLong, pageNum, pageSize, appInfoList);
        }
        catch (Exception e) {
            logger.error(e.getMessage());
            return new ReturnCodeUtil(104, "\u83b7\u53d6\u5e94\u7528\u5206\u9875\u5217\u8868\u5931\u8d25");
        }
    }

    @Override
    public TAppInfo queryAppDetail(String appId) {
        return this.appInfoDao.queryAppDetail(appId);
    }

    @Override
    public ReturnCodeUtil submitAppAuthorize(TAppInfo appInfo) {
        try {
            appInfo.setAuditTime(Long.valueOf(System.currentTimeMillis()));
            this.appInfoDao.submitAppAuthorize(appInfo);
            return new ReturnCodeUtil();
        }
        catch (Exception e) {
            return new ReturnCodeUtil(111, "\u63d0\u4ea4\u5e94\u7528\u4fe1\u606f\u5f02\u5e38");
        }
    }

    @Override
    public TAppInfo getAppNote(String appId) {
        return this.appInfoDao.getAppNote(appId);
    }

    @Override
    public boolean checkAppNameExist(String appName) {
        return this.appInfoDao.checkAppNameExist(appName);
    }

    @Override
    public boolean checkPackageNameExist(String packageName) {
        return this.appInfoDao.checkPackageNameExist(packageName);
    }

    @Override
    public List<TAppInfoCondition> getAppInfosByUserId(Long userId) {
        return this.appInfoDao.getAppInfosByUserId(userId);
    }
}

