/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.cssp.open.system.business.impl;

import com.googlecode.genericdao.search.ISearch;
import com.googlecode.genericdao.search.Search;
import com.xdja.cssp.open.core.util.ReturnCodeUtil;
import com.xdja.cssp.open.system.business.IRoleBusiness;
import com.xdja.cssp.open.system.dao.FunctionDao;
import com.xdja.cssp.open.system.dao.TRoleDao;
import com.xdja.cssp.open.system.dao.TRoleFunctionDao;
import com.xdja.cssp.open.system.dao.TUserRoleDao;
import com.xdja.cssp.open.system.entity.Function;
import com.xdja.cssp.open.system.entity.TRole;
import com.xdja.cssp.open.system.entity.TRoleFunction;
import com.xdja.cssp.open.system.entity.TUserRole;
import com.xdja.platform.datacenter.jpa.business.BaseBusiness;
import com.xdja.platform.datacenter.jpa.page.Pagination;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class RoleBusinessImpl
extends BaseBusiness
implements IRoleBusiness {
    @Autowired
    private TRoleDao roleDao;
    @Autowired
    private TUserRoleDao userRoleDao;
    @Autowired
    private TRoleFunctionDao roleFunctionDao;
    @Autowired
    private FunctionDao functionDao;

    @Override
    public void saveRole(TRole role, String funcIds) {
        String[] funcIdsArr = funcIds.split(",");
        Object[] roleFunctionArray = new TRoleFunction[funcIdsArr.length];
        TRoleFunction roleFunction = null;
        if (null == role.getId()) {
            role.setType(TRole.ENUM_ROLE_TYPE.consumerRole.value);
            role.setTime(Long.valueOf(System.currentTimeMillis()));
        }
        role.setTime(Long.valueOf(System.currentTimeMillis()));
        this.roleDao.save(role);
        for (int index = 0; index < funcIdsArr.length; ++index) {
            roleFunction = new TRoleFunction();
            roleFunction.setRoleId(role.getId());
            roleFunction.setFunctionId(Long.valueOf(Long.parseLong(funcIdsArr[index])));
            roleFunctionArray[index] = roleFunction;
        }
        this.roleFunctionDao.removeRoleFuncById(role.getId());
        this.roleFunctionDao.save(roleFunctionArray);
    }

    @Override
    public Pagination<TRole> queryAllRoles(TRole roleCondition, Integer pageNo, Integer pageSize, String sortName, String sortType) {
        return this.roleDao.queryAllRoles(roleCondition, pageNo, pageSize, sortName, sortType);
    }

    @Override
    public List<Function> queryAllFunctions() {
        return this.functionDao.queryAllFunctions();
    }

    @Override
    public TRole getRoleById(Long roleId) {
        return (TRole)this.roleDao.find(roleId);
    }

    @Override
    public List<TRoleFunction> queryRoleFunctionByRoleId(Long roleId) {
        return this.roleFunctionDao.queryRoleFunctionByRoleId(roleId);
    }

    @Override
    public List<TRole> queryListRoles() {
        return this.roleDao.findAll();
    }

    @Override
    public List<TUserRole> queryUserRoleListByUserId(Long userId) {
        return this.userRoleDao.queryUserRoleListByUserId(userId);
    }

    @Override
    public Boolean isRoleNameExist(Long roleId, String roleName) {
        Search search = new Search(TRole.class);
        search.addFilterEqual("name", (Object)roleName);
        if (null != roleId) {
            search.addFilterNotEqual("id", (Object)roleId);
        }
        return this.roleDao.count((ISearch)search) > 0;
    }

    @Override
    public ReturnCodeUtil queryAllRolesList(Long pageNo, Integer pageSize) {
        Long roleSize = this.roleDao.queryAllRoleSize();
        List<TRole> dataList = this.roleDao.queryAllRolesList(pageNo, pageSize);
        return new ReturnCodeUtil(roleSize, pageNo, pageSize.intValue(), dataList);
    }

    @Override
    public void deleteRoleById(Long id) {
        try {
            this.userRoleDao.removeUserRoleByRoleId(id);
            this.roleDao.removeById(id);
        }
        catch (Exception e) {
            throw new RuntimeException("\u5220\u9664\u89d2\u8272\u65f6\u51fa\u73b0\u5f02\u5e38");
        }
    }
}

