/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.cssp.open.system.service.impl;

import com.xdja.cssp.open.core.util.ReturnCodeUtil;
import com.xdja.cssp.open.system.business.IAccountInfoBusiness;
import com.xdja.cssp.open.system.entity.TAccountInfo;
import com.xdja.cssp.open.system.entity.UserSummaryInfo;
import com.xdja.cssp.open.system.service.IAccountInfoService;
import com.xdja.cssp.open.system.util.DateQueryBean;
import com.xdja.cssp.open.utils.Constants;
import com.xdja.platform.log.Logger;
import com.xdja.platform.log.LoggerFactory;
import com.xdja.platform.redis.core.RedisClient;
import com.xdja.platform.redis.core.action.JedisActionNoResult;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.Pipeline;

@Component
public class AccountInfoServiceImpl
implements IAccountInfoService {
    private Logger logger = LoggerFactory.getLogger(AccountInfoServiceImpl.class);
    @Resource
    private IAccountInfoBusiness accountInfoBusiness;
    @Resource
    RedisClient redisClient;

    public TAccountInfo getAccountInfoByAccountId(Long accountId) {
        if (null != accountId) {
            return this.accountInfoBusiness.getAccountInfoByAccountId(accountId);
        }
        throw new IllegalArgumentException("\u7528\u6237Id\u4e3a\u7a7a");
    }

    public void resetPwd(Long accountId) {
        if (null == accountId) {
            throw new IllegalArgumentException("\u7528\u6237Id\u4e3a\u7a7a");
        }
        this.accountInfoBusiness.resetPwd(accountId);
    }

    public ReturnCodeUtil resetPwd(String email, String password) {
        return this.accountInfoBusiness.resetPwd(email, password);
    }

    public void forbiddenUser(Long accountId) {
        if (null == accountId) {
            throw new IllegalArgumentException("\u7528\u6237Id\u4e3a\u7a7a");
        }
        this.accountInfoBusiness.forbiddenUser(accountId);
    }

    public void startoverUser(Long accountId) {
        if (null == accountId) {
            throw new IllegalArgumentException("\u7528\u6237Id\u4e3a\u7a7a");
        }
        this.accountInfoBusiness.startoverUser(accountId);
    }

    public void deleteUser(Long accountId) {
        if (null == accountId) {
            throw new IllegalArgumentException("\u7528\u6237Id\u4e3a\u7a7a");
        }
        this.accountInfoBusiness.deleteUser(accountId);
    }

    public ReturnCodeUtil checkEmailExist(String currEamil) {
        if (StringUtils.isNotBlank((CharSequence)currEamil)) {
            return this.accountInfoBusiness.checkEmailExist(currEamil);
        }
        throw new IllegalArgumentException("\u90ae\u7bb1\u4e3a\u7a7a");
    }

    public void register(String currEmail, String encodePasswordSHA1, String requestUrl) {
        this.accountInfoBusiness.register(currEmail, encodePasswordSHA1, requestUrl);
    }

    public ReturnCodeUtil getActiveNote(String email, String activeCode) {
        return this.accountInfoBusiness.getActiveNote(email, activeCode);
    }

    public ReturnCodeUtil ajaxAccountInfoList(Long pageNum, int pageSize, TAccountInfo condition, DateQueryBean queryBean) {
        String message = "";
        try {
            return this.accountInfoBusiness.ajaxAccountInfoList(pageNum, pageSize, condition, queryBean);
        }
        catch (Exception e) {
            message = "\u83b7\u53d6\u666e\u901a\u7528\u6237\u5206\u9875\u5217\u8868\u5f02\u5e38";
            this.logger.error(message, (Throwable)e);
            return new ReturnCodeUtil(1, message);
        }
    }

    public TAccountInfo getAccountInfoByEmail(String email) {
        return this.accountInfoBusiness.getAccountInfoByEmail(email);
    }

    public ReturnCodeUtil sendVerifyEmail(String email, String requestUrl) {
        return this.accountInfoBusiness.sendVerifyEmail(email, requestUrl);
    }

    public ReturnCodeUtil verifyResetCode(String email, String resetCode) {
        return this.accountInfoBusiness.verifyResetCode(email, resetCode);
    }

    public void resendActivateEmail(String email, String requestUrl) {
        this.accountInfoBusiness.resendActivateEmail(email, requestUrl);
    }

    public ReturnCodeUtil queryAccountStatus(String email) {
        return null;
    }

    public void delRedisAudit(Long id) {
        this.accountInfoBusiness.delRedisAudit(id);
    }

    public TAccountInfo getPersonInfoByMail(String email) {
        return this.accountInfoBusiness.getPersonInfoByMail(email);
    }

    public int updateUnActiveEmail(String oldEmail, String newEmail) {
        return this.accountInfoBusiness.updateUnActiveEmail(oldEmail, newEmail);
    }

    public void addLoginErrorCache(String email) {
        this.accountInfoBusiness.addLoginErrorCache(email);
    }

    public void addValiCodeCache(String mobile, String email, String verifyCode) {
        if (StringUtils.isNotBlank((CharSequence)mobile)) {
            this.redisClient.setex("open_validate_code_" + mobile, 300, verifyCode);
        } else {
            this.redisClient.setex("open_validate_code_" + email, 300, verifyCode);
        }
    }

    public String getValiCodeCache(String email) {
        return this.redisClient.get("open_validate_code_" + email);
    }

    public int delValidateCodeCache(String email, String validateCode) {
        Integer errorTimes;
        int result = 0;
        String errorTimesStr = this.redisClient.get("open_login_error_" + email);
        if (StringUtils.isNotBlank((CharSequence)errorTimesStr) && null != (errorTimes = Integer.valueOf(Integer.parseInt(errorTimesStr))) && errorTimes >= Constants.PASSWD_ERROR_LIMIT) {
            if (StringUtils.isNotBlank((CharSequence)validateCode)) {
                String oldCode = this.getValiCodeCache(email);
                if (StringUtils.isNotBlank((CharSequence)oldCode)) {
                    int n = result = oldCode.equalsIgnoreCase(validateCode) ? 0 : 1;
                    if (result == 0) {
                        this.redisClient.del(new String[]{"open_validate_code_" + email});
                    }
                    return result;
                }
                return 2;
            }
            return 3;
        }
        return 0;
    }

    public void delLoginValiCodeCache(final String email) {
        this.redisClient.execute(new JedisActionNoResult(){

            public void action(Jedis jedis) {
                Pipeline p = jedis.pipelined();
                p.del("open_validate_code_" + email);
                p.del("open_login_error_" + email);
                p.sync();
            }
        });
    }

    public int checkRegisterCountByIp(String ip, String email, String validateCode) {
        String timesStr = this.redisClient.get("open_register_ip_" + ip);
        if (StringUtils.isNotBlank((CharSequence)timesStr)) {
            Integer times = Integer.parseInt(timesStr);
            if (times < Constants.IP_REGIST_LIMIT) {
                this.redisClient.setex("open_register_ip_" + ip, 36000, String.valueOf(times + 1));
                return 0;
            }
            if (times >= Constants.IP_REGIST_LIMIT) {
                if (StringUtils.isBlank((CharSequence)validateCode)) {
                    return 3;
                }
                String oldCode = this.getValiCodeCache(email);
                if (StringUtils.isNotBlank((CharSequence)oldCode)) {
                    int result;
                    int n = result = oldCode.equalsIgnoreCase(validateCode) ? 0 : 1;
                    if (result == 0) {
                        this.redisClient.setex("open_register_ip_" + ip, 36000, String.valueOf(times + 1));
                        this.redisClient.del(new String[]{"open_validate_code_" + email});
                    }
                    return result;
                }
                return 2;
            }
        } else {
            this.redisClient.setex("open_register_ip_" + ip, 36000, String.valueOf(1));
            return 0;
        }
        return 0;
    }

    public UserSummaryInfo getUserSummaryInfo(Long id) {
        return this.accountInfoBusiness.getUserSummaryInfo(id);
    }
}

