/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.cssp.open.system.business.impl;

import com.xdja.cssp.open.system.business.IAppStatisticsInfoBusiness;
import com.xdja.cssp.open.system.dao.TAppInfoDao;
import com.xdja.cssp.open.system.entity.AppStatisticsInfo;
import com.xdja.cssp.open.system.entity.AppStatisticsInfoBean;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class AppStatisticsInfoBusinessImpl
implements IAppStatisticsInfoBusiness {
    private static Logger logger = LoggerFactory.getLogger(AppStatisticsInfoBusinessImpl.class);
    @Autowired(required=true)
    private TAppInfoDao appInfoDao;

    @Override
    public List<AppStatisticsInfo> getAppStatisticsInfo() {
        List<AppStatisticsInfoBean> originAppList = this.appInfoDao.getAppStatisticInfo();
        return this.appTypeConvertToPlatform(originAppList);
    }

    private List<AppStatisticsInfo> appTypeConvertToPlatform(List<AppStatisticsInfoBean> originAppList) {
        ArrayList<AppStatisticsInfo> destAppList = new ArrayList<AppStatisticsInfo>();
        AppStatisticsInfoBean tempInfo = null;
        int appType = 0;
        if (originAppList != null && !originAppList.isEmpty()) {
            for (int i = 0; i < originAppList.size(); ++i) {
                AppStatisticsInfo appInfo = new AppStatisticsInfo();
                tempInfo = originAppList.get(i);
                appType = tempInfo.getAppType();
                appInfo.setAppIdentifier(tempInfo.getAppIdentifier());
                appInfo.setAppName(tempInfo.getAppName());
                if (appType == AppStatisticsInfoBean.AppTypeConvertPlatform.android.getType()) {
                    appInfo.setAppPlatform(AppStatisticsInfoBean.AppTypeConvertPlatform.android.getPlatform());
                } else if (appType == AppStatisticsInfoBean.AppTypeConvertPlatform.windows.getType()) {
                    appInfo.setAppPlatform(AppStatisticsInfoBean.AppTypeConvertPlatform.windows.getPlatform());
                } else if (appType == AppStatisticsInfoBean.AppTypeConvertPlatform.linux.getType()) {
                    appInfo.setAppPlatform(AppStatisticsInfoBean.AppTypeConvertPlatform.linux.getPlatform());
                }
                destAppList.add(appInfo);
            }
        }
        return destAppList;
    }
}

