/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.cssp.open.system.business.impl;

import com.xdja.cssp.open.system.business.IFunctionBusiness;
import com.xdja.cssp.open.system.dao.FunctionDao;
import com.xdja.cssp.open.system.entity.Function;
import com.xdja.cssp.open.system.entity.TUser;
import com.xdja.platform.security.bean.Menu;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class FunctionBusinessImpl
implements IFunctionBusiness {
    @Autowired
    private FunctionDao functionDao;

    @Override
    public Map<String, Menu> queryAllFunctions(TUser user) {
        List<Object> functions = new ArrayList();
        functions = user.getType() == TUser.ENUM_USER_TYPE.systemUser.value ? this.functionDao.queryAdminFunctions() : this.functionDao.queryUserFunctions(user);
        return this.queryMapFunctions(functions);
    }

    private Map<String, Menu> queryMapFunctions(List<Function> functionList) {
        LinkedHashMap<String, Menu> functions = new LinkedHashMap<String, Menu>();
        LinkedHashMap<Long, Menu> tempFunctions = new LinkedHashMap<Long, Menu>();
        Menu menu = null;
        for (Function function : functionList) {
            menu = this.function2Menu(function);
            if (function.getParentId() == 0L) {
                tempFunctions.put(function.getId(), menu);
                functions.put(function.getId().toString(), menu);
                continue;
            }
            Menu parentFunc = (Menu)tempFunctions.get(function.getParentId());
            if (parentFunc != null) {
                parentFunc.addChild(menu);
            }
            tempFunctions.put(function.getId(), menu);
        }
        tempFunctions = null;
        return functions;
    }

    private Menu function2Menu(Function function) {
        Menu menu = new Menu();
        menu.setId(function.getId().toString());
        menu.setName(function.getName());
        menu.setPermissionKey(function.getObjName());
        menu.addProperty("icon", (Object)function.getIcon());
        menu.addProperty("link", (Object)function.getLink());
        return menu;
    }

    @Override
    public List<Function> queryParentFunctions() {
        return this.functionDao.queryParentFunctions();
    }
}

