/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.cssp.open.system.business.impl;

import com.xdja.cssp.open.system.business.IOpenAppInfoBusiness;
import com.xdja.cssp.open.system.business.impl.AppInfoBusinessImpl;
import com.xdja.cssp.open.system.cache.AppInfoCache;
import com.xdja.cssp.open.system.dao.TAppInfoDao;
import com.xdja.cssp.open.system.entity.OpenApp;
import com.xdja.platform.log.LoggerFactory;
import com.xdja.platform.redis.core.RedisClient;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class OpenAppInfoBusinessImpl
implements IOpenAppInfoBusiness {
    private static Logger logger = LoggerFactory.getLogger(AppInfoBusinessImpl.class);
    @Autowired
    private TAppInfoDao appInfoDao;
    @Resource
    RedisClient redisClient;
    @Autowired
    private AppInfoCache cache;

    @Override
    public Map<String, OpenApp> queryAppInfo(String ... appIds) {
        Map<String, OpenApp> appInfos = new HashMap<String, OpenApp>();
        if (null == appIds || appIds.length <= 0) {
            logger.error("\u6279\u91cf\u67e5\u8be2\u5e94\u7528\u6388\u6743\u4fe1\u606f\u5931\u8d25\uff0c\u539f\u56e0\uff1a\u8bf7\u6c42\u53c2\u6570\u975e\u6cd5\uff0c\u5e94\u7528\u6807\u8bc6\u4e3a\u7a7a");
            return appInfos;
        }
        appInfos = this.cache.getAppInfoBatch(appIds);
        if (appInfos.size() > 0) {
            logger.info("\u4ece\u7f13\u5b58\u4e2d\u83b7\u53d6\u5e94\u7528\u6388\u6743\u4fe1\u606f,\u5e94\u7528appID\u4e3a:" + appInfos.keySet());
        }
        if (appInfos.size() < appIds.length) {
            ArrayList<String> tmpAppIds = new ArrayList<String>();
            tmpAppIds.addAll(Arrays.asList(appIds));
            tmpAppIds.removeAll(appInfos.keySet());
            Map<String, OpenApp> map = this.appInfoDao.queryAuthAppInfos(tmpAppIds.toArray(new String[tmpAppIds.size()]));
            if (!map.isEmpty()) {
                this.cache.addAppInfo(new ArrayList<OpenApp>(map.values()).toArray(new OpenApp[map.size()]));
                logger.info("\u4ece\u6570\u636e\u5e93\u4e2d\u83b7\u53d6\u5e94\u7528\u6388\u6743\u4fe1\u606f,\u5e94\u7528appID\u4e3a:" + map.keySet());
                appInfos.putAll(map);
            }
        }
        return appInfos;
    }

    @Override
    public List<OpenApp> queryAppInfo(List<Map<String, String>> appIdPackages) {
        Map<Object, Object> appInfos = new HashMap();
        List<OpenApp> apps = null;
        if (null == appIdPackages || appIdPackages.size() <= 0) {
            logger.error("\u6279\u91cf\u67e5\u8be2\u5e94\u7528\u6388\u6743\u4fe1\u606f\u5931\u8d25\uff0c\u539f\u56e0\uff1a\u8bf7\u6c42\u53c2\u6570\u975e\u6cd5\uff0c\u5e94\u7528\u6807\u8bc6\u4e3a\u7a7a");
            return new ArrayList<OpenApp>(appInfos.values());
        }
        appInfos = this.cache.getAppInfoBatch(appIdPackages);
        if (appInfos.size() > 0) {
            logger.info("\u4ece\u7f13\u5b58\u4e2d\u83b7\u53d6\u5e94\u7528\u6388\u6743\u4fe1\u606f,\u5e94\u7528appID\u548cpackageName\u4e3a:" + appInfos);
        }
        if (appInfos.size() < appIdPackages.size()) {
            ArrayList<Map<String, String>> temp = new ArrayList<Map<String, String>>();
            temp.addAll(appIdPackages);
            temp.removeAll(appInfos.keySet());
            apps = this.appInfoDao.queryAuthAppInfos(temp);
            if (!apps.isEmpty()) {
                this.cache.addAppInfo(apps.toArray(new OpenApp[apps.size()]));
                logger.info("\u4ece\u6570\u636e\u5e93\u4e2d\u83b7\u53d6\u5e94\u7528\u6388\u6743\u4fe1\u606f\u6210\u529f");
                apps.addAll(appInfos.values());
            }
        }
        return apps;
    }
}

