/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.cssp.open.system.cache;

import com.xdja.cssp.open.system.entity.OpenApp;
import com.xdja.platform.redis.core.RedisClient;
import com.xdja.platform.redis.core.action.JedisAction;
import com.xdja.platform.redis.core.action.JedisActionNoResult;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.Pipeline;
import redis.clients.jedis.Response;

@Component
public class AppInfoCache {
    @Resource
    private RedisClient redisClient;
    private static final String APPINFO_PREFIX = "open_app_info_";

    public void addAppInfo(final OpenApp ... appInfos) {
        if (null != appInfos && appInfos.length > 0) {
            this.redisClient.execute(new JedisActionNoResult(){

                public void action(Jedis jedis) {
                    Pipeline p = jedis.pipelined();
                    OpenApp info = null;
                    Map item = null;
                    for (int i = 0; i < appInfos.length; ++i) {
                        info = appInfos[i];
                        if (null == info) continue;
                        item = AppInfoCache.this.getAppInfoMap(info);
                        p.hmset(AppInfoCache.APPINFO_PREFIX + info.getAppId(), item);
                    }
                    p.sync();
                }
            });
        }
    }

    private Map<String, String> getAppInfoMap(OpenApp info) {
        HashMap<String, String> item = new HashMap<String, String>();
        item.put("appId", info.getAppId());
        item.put("name", info.getName());
        item.put("secretKey", info.getSecretKey());
        item.put("pkgName", info.getPkgName());
        item.put("pkgSign", info.getPkgSign());
        item.put("suit", 0 == info.getSuit() ? "" : String.valueOf(info.getSuit()));
        item.put("type", String.valueOf(info.getType()));
        item.put("time", String.valueOf(info.getTime()));
        item.put("copyright", info.getCopyright());
        item.put("interVersion", info.getInterVersion());
        item.put("pkgHashVal", info.getPkgHashVal());
        item.put("token", info.getToken());
        item.put("version", StringUtils.isBlank((CharSequence)info.getVersion()) ? "" : String.valueOf(info.getVersion()));
        item.put("kdcSuit", null == info.getKdcSuit() ? "" : String.valueOf(info.getKdcSuit()));
        item.put("kdcAuthType", 0 == info.getKdcAuthType() ? "" : String.valueOf(info.getKdcAuthType()));
        item.put("kdcVersion", StringUtils.isBlank((CharSequence)info.getKdcVersion()) ? "" : info.getKdcVersion());
        item.put("kdcSignature", StringUtils.isBlank((CharSequence)info.getKdcSignature()) ? "" : info.getKdcSignature());
        return item;
    }

    public void addAppInfoByAppidPackageName(final OpenApp ... appInfos) {
        if (null != appInfos && appInfos.length > 0) {
            this.redisClient.execute(new JedisActionNoResult(){

                public void action(Jedis jedis) {
                    Pipeline p = jedis.pipelined();
                    OpenApp info = null;
                    Map item = null;
                    for (int i = 0; i < appInfos.length; ++i) {
                        info = appInfos[i];
                        if (null == info) continue;
                        item = AppInfoCache.this.getAppInfoMap(info);
                        p.hmset(AppInfoCache.APPINFO_PREFIX + info.getAppId() + "_" + info.getPkgName(), item);
                    }
                    p.sync();
                }
            });
        }
    }

    public OpenApp getAppInfo(final String appId) {
        return (OpenApp)this.redisClient.execute((JedisAction)new JedisAction<OpenApp>(){

            public OpenApp action(Jedis jedis) {
                OpenApp info = null;
                Map data = jedis.hgetAll(AppInfoCache.APPINFO_PREFIX + appId);
                if (null != data && !data.isEmpty()) {
                    info = AppInfoCache.this.getOpenApp(data);
                }
                return info;
            }
        });
    }

    private OpenApp getOpenApp(Map<String, String> data) {
        OpenApp info = new OpenApp();
        info.setAppId(data.get("appId"));
        info.setName(data.get("name"));
        info.setSecretKey(data.get("secretKey"));
        info.setPkgName(data.get("pkgName"));
        info.setPkgSign(data.get("pkgSign"));
        if (StringUtils.isNotBlank((CharSequence)data.get("suit"))) {
            info.setSuit(Integer.parseInt(data.get("suit")));
        }
        info.setType(Integer.parseInt(data.get("type")));
        info.setTime(Long.parseLong(data.get("time")));
        info.setCopyright(data.get("copyright"));
        info.setInterVersion(data.get("interVersion"));
        info.setPkgHashVal(data.get("pkgHashVal"));
        info.setToken(data.get("token"));
        info.setVersion(data.get("version"));
        if (StringUtils.isNotBlank((CharSequence)data.get("kdcSuit"))) {
            info.setKdcSuit(Long.valueOf(data.get("kdcSuit")));
        }
        if (StringUtils.isNotBlank((CharSequence)data.get("kdcAuthType"))) {
            info.setKdcAuthType(Integer.parseInt(data.get("kdcAuthType")));
        }
        if (StringUtils.isNotBlank((CharSequence)data.get("kdcVersion"))) {
            info.setKdcVersion(data.get("kdcVersion"));
        }
        if (StringUtils.isNotBlank((CharSequence)data.get("kdcSignature"))) {
            info.setKdcSignature(data.get("kdcSignature"));
        }
        return info;
    }

    public Map<String, OpenApp> getAppInfoBatch(final String ... appIds) {
        return (Map)this.redisClient.execute((JedisAction)new JedisAction<Map<String, OpenApp>>(){

            public Map<String, OpenApp> action(Jedis jedis) {
                HashMap<String, OpenApp> result = new HashMap<String, OpenApp>();
                HashMap<String, Response> responses = new HashMap<String, Response>();
                Map data = null;
                OpenApp appInfo = null;
                Pipeline p = jedis.pipelined();
                for (int i = 0; i < appIds.length; ++i) {
                    String key = AppInfoCache.APPINFO_PREFIX + appIds[i];
                    responses.put(key, p.hgetAll(key));
                }
                p.sync();
                for (Map.Entry item : responses.entrySet()) {
                    data = (Map)((Response)item.getValue()).get();
                    if (null == data || data.isEmpty()) continue;
                    appInfo = AppInfoCache.this.getOpenApp(data);
                    result.put(appInfo.getAppId(), appInfo);
                }
                return result;
            }
        });
    }

    public Map<Map<String, String>, OpenApp> getAppInfoBatch(final List<Map<String, String>> appIdPackages) {
        return (Map)this.redisClient.execute((JedisAction)new JedisAction<Map<Map<String, String>, OpenApp>>(){

            public Map<Map<String, String>, OpenApp> action(Jedis jedis) {
                HashMap<Map<String, String>, OpenApp> result = new HashMap<Map<String, String>, OpenApp>();
                HashMap<String, Response> responses = new HashMap<String, Response>();
                Map data = null;
                OpenApp appInfo = null;
                String appId = "";
                String packageName = "";
                Pipeline p = jedis.pipelined();
                for (Map appIdPackage : appIdPackages) {
                    appId = (String)appIdPackage.keySet().iterator().next();
                    packageName = (String)appIdPackage.get(appId);
                    String key = AppInfoCache.APPINFO_PREFIX + appId + "_" + packageName;
                    responses.put(key, p.hgetAll(key));
                }
                p.sync();
                HashMap<String, String> appIdPackageName = null;
                for (Map.Entry item : responses.entrySet()) {
                    data = (Map)((Response)item.getValue()).get();
                    if (null == data || data.isEmpty()) continue;
                    appInfo = AppInfoCache.this.getOpenApp(data);
                    appIdPackageName = new HashMap<String, String>();
                    appIdPackageName.put(appInfo.getAppId(), appInfo.getPkgName());
                    result.put(appIdPackageName, appInfo);
                }
                return result;
            }
        });
    }

    public void delAppInfo(String appId) {
        this.redisClient.del(new String[]{APPINFO_PREFIX + appId});
    }
}

