/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.cssp.open.system.dao;

import com.xdja.platform.datacenter.jpa.dao.BaseJdbcDao;
import java.util.List;
import java.util.Map;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.stereotype.Repository;

@Repository
public class SystemDao
extends BaseJdbcDao {
    public List<Map<String, Object>> getDicValues(String keyword, Integer start, Integer pageSize) {
        MapSqlParameterSource sqlParameterSource = new MapSqlParameterSource();
        StringBuilder sqlBuilder = new StringBuilder("SELECT t.c_code code, t.c_name name from t_dic t where ");
        sqlBuilder.append(" t.c_parent_code = :keyword ");
        sqlParameterSource.addValue("keyword", (Object)keyword);
        if (start != -1) {
            sqlBuilder.append("  limit ").append(start).append(" , ").append(pageSize);
        }
        return this.queryForList(sqlBuilder.toString(), (SqlParameterSource)sqlParameterSource);
    }

    public Map<String, Object> getDicName(String code, String parentCode) {
        MapSqlParameterSource sqlParameterSource = new MapSqlParameterSource();
        StringBuilder sqlBuilder = new StringBuilder("SELECT t.c_name name FROM t_dic t WHERE t.c_code = :code AND t.c_parent_code = :parentCode ");
        sqlParameterSource.addValue("code", (Object)code);
        sqlParameterSource.addValue("parentCode", (Object)parentCode);
        Map map = null;
        try {
            map = this.queryForMap(sqlBuilder.toString(), (SqlParameterSource)sqlParameterSource);
        }
        catch (Exception e) {
            this.logger.error("\u5b57\u5178\u4e2d\u6839\u636ecode\u548cparentCode\u83b7\u53d6name\u5931\u8d25");
        }
        return map;
    }

    public List<Map<String, Object>> getDicCodes(String name, String parentCode) {
        StringBuffer sqlBuffer = new StringBuffer("SELECT t.c_code code FROM t_dic t WHERE t.c_parent_code = :parentCode ");
        sqlBuffer.append(" AND t.c_name LIKE :name ESCAPE '/' ");
        MapSqlParameterSource sqlParameterSource = new MapSqlParameterSource();
        sqlParameterSource.addValue("parentCode", (Object)parentCode);
        sqlParameterSource.addValue("name", (Object)("%" + name.replaceAll("%", "/%").replaceAll("_", "/_") + "%"));
        return this.queryForList(sqlBuffer.toString(), (SqlParameterSource)sqlParameterSource);
    }
}

