/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.cssp.open.system.dao;

import com.xdja.cssp.open.system.entity.TUserRole;
import com.xdja.platform.datacenter.jpa.dao.BaseJpaDao;
import com.xdja.platform.datacenter.jpa.dao.helper.condition.Conditions;
import java.util.List;
import java.util.Map;
import org.springframework.jdbc.core.BeanPropertyRowMapper;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.stereotype.Repository;

@Repository
public class TUserRoleDao
extends BaseJpaDao<TUserRole, Long> {
    public void removeUserRoleByRoleId(Long roleId) {
        this.deleteByCondition("t_sys_user_role", Conditions.eq((String)"n_role_id", (Object)roleId));
    }

    public void removeUserRoleByUserId(Long userId) {
        this.deleteByCondition("t_sys_user_role", Conditions.eq((String)"n_user_id", (Object)userId));
    }

    public List<TUserRole> queryUserRoleListByUserId(Long userId) {
        MapSqlParameterSource sqlParam = new MapSqlParameterSource();
        String sql = "SELECT n_role_id AS roleId FROM t_sys_user_role WHERE n_user_id = :userId";
        sqlParam.addValue("userId", (Object)userId);
        return this.queryForList(sql, (SqlParameterSource)sqlParam, (RowMapper)BeanPropertyRowMapper.newInstance(TUserRole.class));
    }

    public Integer getUserCountByRoleId(Long roleId) {
        return this.countByCondition("t_sys_user_role", Conditions.eq((String)"n_role_id", (Object)roleId));
    }

    public List<Map<String, Object>> queryAuthFuns(Long roleId) {
        StringBuffer sqlBuffer = new StringBuffer();
        sqlBuffer.append("SELECT role.c_name name, role.n_id id FROM t_sys_role_function roleFun ").append("LEFT JOIN t_sys_role role ON roleFun.n_role_id = role.n_id ").append("WHERE role.n_id = :roleId ");
        MapSqlParameterSource sqlParam = new MapSqlParameterSource();
        sqlParam.addValue("roleId", (Object)roleId);
        return this.queryForList(sqlBuffer.toString(), (SqlParameterSource)sqlParam);
    }
}

