/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.cssp.as.api;

import com.xdja.cssp.as.api.Constants;
import com.xdja.cssp.as.api.bean.ClientLoginBean;
import com.xdja.cssp.as.api.exception.CommonBusinessException;
import com.xdja.cssp.as.api.util.IoReadUtil;
import com.xdja.cssp.as.auth.annotation.AuthClient;
import com.xdja.cssp.as.auth.model.Request;
import com.xdja.cssp.as.service.ILoginService;
import com.xdja.cssp.as.service.ITicketService;
import com.xdja.cssp.as.service.model.ClientLoginReq;
import com.xdja.cssp.as.service.model.ResultBean;
import com.xdja.cssp.restful.exception.BadRequestException;
import com.xdja.cssp.restful.exception.InternalServerException;
import com.xdja.cssp.restful.exception.ResourceNotFoundException;
import com.xdja.cssp.restful.exception.TicketNotAuthException;
import com.xdja.platform.rpc.consumer.refer.DefaultServiceRefer;
import java.util.HashMap;
import java.util.UUID;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class AsApi {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private ILoginService service = (ILoginService)DefaultServiceRefer.getServiceRefer(ILoginService.class);
    private ITicketService ticketService = (ITicketService)DefaultServiceRefer.getServiceRefer(ITicketService.class);

    @RequestMapping(value={"/login/single"}, method={RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    @AuthClient
    public Object singleClientLogin(Request request) throws Exception {
        ClientLoginBean loginBean;
        long startTime = System.currentTimeMillis();
        this.logger.debug("\u5f00\u59cb\u6267\u884c\u5355\u5ba2\u6237\u7aef\u767b\u5f55");
        String requestId = request.getId();
        String cardNo = request.getCardNo();
        String sn = request.getSignSn();
        int caAlg = request.getSignatureAlgo().equals("SM3WITHSM2") ? 2 : 1;
        try {
            loginBean = (ClientLoginBean)IoReadUtil.convertRequestData((byte[])request.getBody(), ClientLoginBean.class);
            this.logger.debug("\u767b\u5f55\u539f\u59cb\u8bf7\u6c42\uff1a{}", (Object)new String(request.getBody(), "UTF-8"));
        }
        catch (Exception e1) {
            this.logger.error("\u83b7\u53d6\u8bf7\u6c42\u6570\u636e\u5f02\u5e38", (Throwable)e1);
            throw new BadRequestException(Constants.HOST_ID, requestId, "request_params_error", "\u8bf7\u6c42\u53c2\u6570\u683c\u5f0f\u9519\u8bef");
        }
        this.checkClientLoginParams(loginBean, requestId);
        ClientLoginReq loginReq = this.buildLoginReq(loginBean, cardNo, sn, caAlg);
        Object result = null;
        try {
            long loginStartTime = System.currentTimeMillis();
            ResultBean resultBean = this.service.singleClientLogin(loginReq);
            this.logger.debug("\u3010\u5355\u5ba2\u6237\u7aef\u767b\u5f55\uff0c\u8c03\u7528AS-SERVICE\u6267\u884c\u767b\u5f55\u64cd\u4f5c\u5b8c\u6210\uff0c\u8017\u65f6\uff1a{} \u6beb\u79d2\u3011", (Object)(System.currentTimeMillis() - loginStartTime));
            result = this.convertResult(resultBean, requestId);
        }
        catch (ResourceNotFoundException e) {
            this.logger.debug("\u3010\u5355\u5ba2\u6237\u7aef\u767b\u5f55\u603b\u8017\u65f6\uff1a{} \u6beb\u79d2\u3011", (Object)(System.currentTimeMillis() - startTime));
            throw e;
        }
        catch (CommonBusinessException e) {
            this.logger.debug("\u3010\u5355\u5ba2\u6237\u7aef\u767b\u5f55\u603b\u8017\u65f6\uff1a{} \u6beb\u79d2\u3011", (Object)(System.currentTimeMillis() - startTime));
            throw e;
        }
        catch (Exception e) {
            this.logger.debug("\u3010\u5355\u5ba2\u6237\u7aef\u767b\u5f55\u603b\u8017\u65f6\uff1a{} \u6beb\u79d2\u3011", (Object)(System.currentTimeMillis() - startTime));
            this.logger.error("\u5355\u5ba2\u6237\u7aef\u767b\u5f55\u5931\u8d25", (Throwable)e);
            throw new InternalServerException(Constants.HOST_ID, requestId, "internal_server_error", "\u670d\u52a1\u5668\u5185\u90e8\u5f02\u5e38");
        }
        this.logger.debug("\u5355\u5ba2\u6237\u7aef\u767b\u5f55\u5b8c\u6210");
        this.logger.debug("\u3010\u5355\u5ba2\u6237\u7aef\u767b\u5f55\u603b\u8017\u65f6\uff1a{} \u6beb\u79d2\u3011", (Object)(System.currentTimeMillis() - startTime));
        return result;
    }

    @RequestMapping(value={"/verify/ticket/{ticket}"}, method={RequestMethod.GET}, produces={"application/json;charset=UTF-8"})
    public Object verifyTicket(@PathVariable(value="ticket") String ticket) {
        long startTime = System.currentTimeMillis();
        this.logger.debug("\u5f00\u59cb\u6267\u884chttp ticket\u8ba4\u8bc1");
        String requestId = this.genRequestId();
        if (StringUtils.isBlank((CharSequence)ticket)) {
            throw new BadRequestException(Constants.HOST_ID, requestId, "request_params_not_valid", "\u8bf7\u6c42\u53c2\u6570\u4e3a\u7a7a");
        }
        ResultBean resultBean = null;
        try {
            resultBean = this.ticketService.verifyTicket(ticket);
            this.logger.debug("\u3010HTTP\u9a8c\u8bc1ticket\uff0c\u8c03\u7528RPC\u9a8c\u8bc1ticket\u8017\u65f6\uff1a{} \u6beb\u79d2\u3011", (Object)(System.currentTimeMillis() - startTime));
            if (resultBean.getResultStatus() != 1) {
                this.logger.debug("ticket\u9a8c\u8bc1\u672a\u901a\u8fc7, ticket={}", (Object)ticket);
                throw new TicketNotAuthException(Constants.HOST_ID, requestId, "not_authorized", "ticket\u9a8c\u8bc1\u672a\u901a\u8fc7");
            }
            this.logger.debug("\u6267\u884chttp ticket\u8ba4\u8bc1\u6210\u529f");
            this.logger.debug("\u3010HTTP\u9a8c\u8bc1ticket\u603b\u8017\u65f6\uff1a{} \u6beb\u79d2\u3011", (Object)(System.currentTimeMillis() - startTime));
            return resultBean.getInfo();
        }
        catch (IllegalArgumentException e) {
            this.logger.debug("\u3010HTTP\u9a8c\u8bc1ticket\u5f02\u5e38\uff0c\u603b\u8017\u65f6\uff1a{} \u6beb\u79d2\u3011", (Object)(System.currentTimeMillis() - startTime));
            this.logger.error("\u8bf7\u6c42\u53c2\u6570\u975e\u6cd5", (Throwable)e);
            throw new BadRequestException(Constants.HOST_ID, requestId, "request_params_not_valid", "\u8bf7\u6c42\u53c2\u6570\u4e3a\u7a7a");
        }
        catch (TicketNotAuthException e) {
            this.logger.debug("\u3010HTTP\u9a8c\u8bc1ticket\u5f02\u5e38\uff0c\u603b\u8017\u65f6\uff1a{} \u6beb\u79d2\u3011", (Object)(System.currentTimeMillis() - startTime));
            throw e;
        }
        catch (Exception e) {
            this.logger.debug("\u3010HTTP\u9a8c\u8bc1ticket\u5f02\u5e38\uff0c\u603b\u8017\u65f6\uff1a{} \u6beb\u79d2\u3011", (Object)(System.currentTimeMillis() - startTime));
            this.logger.error("Http ticket\u8ba4\u8bc1\u5931\u8d25", (Throwable)e);
            throw new InternalServerException(Constants.HOST_ID, requestId, "internal_server_error", "\u670d\u52a1\u5668\u5185\u90e8\u5f02\u5e38");
        }
    }

    @RequestMapping(value={"/logout"}, method={RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    public void logout(HttpServletRequest httpRequest) {
        String resource;
        String ticket;
        long startTime = System.currentTimeMillis();
        this.logger.debug("\u5f00\u59cb\u6267\u884c\u5ba2\u6237\u7aef\u9000\u51fa");
        String requestId = this.genRequestId();
        try {
            ticket = httpRequest.getHeader("ticket");
            resource = (String)((HashMap)IoReadUtil.readRequestData((HttpServletRequest)httpRequest, HashMap.class)).get("resource");
        }
        catch (Exception e1) {
            this.logger.error("\u83b7\u53d6\u8bf7\u6c42\u6570\u636e\u5f02\u5e38", (Throwable)e1);
            throw new BadRequestException(Constants.HOST_ID, requestId, "request_params_error", "\u8bf7\u6c42\u53c2\u6570\u683c\u5f0f\u9519\u8bef");
        }
        if (StringUtils.isBlank((CharSequence)ticket) || StringUtils.isBlank((CharSequence)resource)) {
            throw new BadRequestException(Constants.HOST_ID, requestId, "request_params_not_valid", "\u8bf7\u6c42\u53c2\u6570\u4e3a\u7a7a");
        }
        try {
            int result = this.service.logout(ticket, resource);
            if (result != 1) {
                throw new CommonBusinessException(Constants.HOST_ID, requestId, "ticket_resuorce_disaccord", "\u7528\u6237\u51ed\u8bc1\u4e0e\u5ba2\u6237\u7aef\u6807\u8bc6\u4e0d\u4e00\u81f4");
            }
            this.logger.debug("\u5ba2\u6237\u7aef\u9000\u51fa\u6210\u529f");
            this.logger.debug("\u3010\u5ba2\u6237\u7aef\u9000\u51fa\u603b\u8017\u65f6\uff1a {} \u6beb\u79d2\u3011", (Object)(System.currentTimeMillis() - startTime));
        }
        catch (CommonBusinessException e) {
            this.logger.debug("\u3010\u5ba2\u6237\u7aef\u9000\u51fa\u5f02\u5e38\uff0c\u603b\u8017\u65f6\uff1a {} \u6beb\u79d2\u3011", (Object)(System.currentTimeMillis() - startTime));
            throw e;
        }
        catch (Exception e) {
            this.logger.debug("\u3010\u5ba2\u6237\u7aef\u9000\u51fa\u5f02\u5e38\uff0c\u603b\u8017\u65f6\uff1a {} \u6beb\u79d2\u3011", (Object)(System.currentTimeMillis() - startTime));
            this.logger.error("\u5ba2\u6237\u7aef\u9000\u51fa\u5931\u8d25", (Throwable)e);
            throw new InternalServerException(Constants.HOST_ID, requestId, "internal_server_error", "\u670d\u52a1\u5668\u5185\u90e8\u5f02\u5e38");
        }
    }

    private Object convertResult(ResultBean resultBean, String requestId) {
        switch (resultBean.getResultStatus()) {
            case 2: {
                this.logger.debug("\u767b\u5f55\u5931\u8d25\uff0c\u539f\u56e0\uff1aSN\u5bf9\u5e94\u8d44\u4ea7\u4e0d\u5b58\u5728");
                throw new ResourceNotFoundException(Constants.HOST_ID, requestId, "asset_not_exists", "SN\u5bf9\u5e94\u8d44\u4ea7\u4e0d\u5b58\u5728");
            }
            case 3: {
                this.logger.debug("\u767b\u5f55\u5931\u8d25\uff0c\u539f\u56e0\uff1aSN\u5bf9\u5e94\u8bc1\u4e66\u4e0d\u5b58\u5728");
                throw new ResourceNotFoundException(Constants.HOST_ID, requestId, "cert_not_exists", "SN\u5bf9\u5e94\u8bc1\u4e66\u4e0d\u5b58\u5728");
            }
            case 4: {
                this.logger.debug("\u767b\u5f55\u5931\u8d25\uff0c\u539f\u56e0\uff1a\u5361\u53f7\u4e0eSN\u4e0d\u5bf9\u5e94");
                throw new CommonBusinessException(Constants.HOST_ID, requestId, "card_sn_not_relation", "\u5361\u53f7\u4e0eSN\u4e0d\u5bf9\u5e94");
            }
            case 5: {
                this.logger.debug("\u767b\u5f55\u5931\u8d25\uff0c\u539f\u56e0\uff1a\u8bc1\u4e66\u5df2\u51bb\u7ed3");
                throw new CommonBusinessException(Constants.HOST_ID, requestId, "cert_freeze", "\u8bc1\u4e66\u5df2\u51bb\u7ed3");
            }
            case 6: {
                this.logger.debug("\u767b\u5f55\u5931\u8d25\uff0c\u539f\u56e0\uff1a\u8bc1\u4e66\u5df2\u540a\u9500");
                throw new CommonBusinessException(Constants.HOST_ID, requestId, "cert_revoke", "\u8bc1\u4e66\u5df2\u540a\u9500");
            }
            case 7: {
                this.logger.debug("\u767b\u5f55\u5931\u8d25\uff0c\u539f\u56e0\uff1a\u8d44\u4ea7\u672a\u7ed1\u5b9a\u7528\u6237");
                throw new CommonBusinessException(Constants.HOST_ID, requestId, "asset_not_bind", "\u8d44\u4ea7\u672a\u7ed1\u5b9a\u7528\u6237");
            }
            case 8: {
                this.logger.debug("\u767b\u5f55\u5931\u8d25\uff0c\u539f\u56e0\uff1a\u8bf7\u6c42\u7684kuep\u4e0d\u5b58\u5728 ");
                throw new ResourceNotFoundException(Constants.HOST_ID, requestId, "resource_kuep_not_found", "\u8bf7\u6c42\u7684kuep\u4e0d\u5b58\u5728");
            }
            case 9: {
                this.logger.debug("\u767b\u5f55\u5931\u8d25\uff0c\u539f\u56e0\uff1a\u8bbe\u5907\u672a\u6ce8\u518c ");
                throw new ResourceNotFoundException(Constants.HOST_ID, requestId, "device_is_not_exist", "\u8bbe\u5907\u672a\u6ce8\u518c ");
            }
        }
        return resultBean.getInfo();
    }

    private ClientLoginReq buildLoginReq(ClientLoginBean loginBean, String cardNo, String sn, int caAlg) {
        ClientLoginReq req = new ClientLoginReq();
        req.setClientType(loginBean.getClientType());
        req.setLoginType(loginBean.getLoginType());
        req.setClientModel(loginBean.getClientModel());
        req.setOsName(loginBean.getOsName());
        req.setOsVersion(loginBean.getOsVersion());
        req.setClientVersion(loginBean.getClientVersion());
        req.setResource(loginBean.getResource());
        req.setPnToken(loginBean.getPnToken());
        req.setCardNo(cardNo);
        req.setSn(sn);
        req.setCaAlg(caAlg);
        return req;
    }

    private void checkClientLoginParams(ClientLoginBean req, String requestId) {
        if (StringUtils.isBlank((CharSequence)req.getResource()) || null == req.getClientType() || null == req.getLoginType()) {
            if (req.getLoginType() == 1 && (StringUtils.isBlank((CharSequence)req.getClientModel()) || StringUtils.isBlank((CharSequence)req.getPnToken()) || StringUtils.isBlank((CharSequence)req.getOsName()) || StringUtils.isBlank((CharSequence)req.getOsVersion()) || StringUtils.isBlank((CharSequence)req.getClientVersion()))) {
                throw new BadRequestException(Constants.HOST_ID, requestId, "request_params_not_valid", "\u8bf7\u6c42\u53c2\u6570\u4e3a\u7a7a");
            }
            throw new BadRequestException(Constants.HOST_ID, requestId, "request_params_not_valid", "\u8bf7\u6c42\u53c2\u6570\u4e3a\u7a7a");
        }
        if (!Constants.CLIENT_TYPES.containsKey(req.getClientType()) || !Constants.LOGIN_TYPES.containsKey(req.getLoginType())) {
            throw new BadRequestException(Constants.HOST_ID, requestId, "request_params_not_valid", "\u8bf7\u6c42\u53c2\u6570\u4e0d\u518d\u679a\u4e3e\u7c7b\u578b\u5185");
        }
    }

    private String genRequestId() {
        return UUID.randomUUID().toString();
    }

    public String getHostId() {
        return Constants.HOST_ID;
    }

    public String getApiVersion() {
        return Constants.API_VERSION;
    }

    public long getTimeout() {
        return Constants.TIMEOUT;
    }
}

