/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.cssp.as.api.init;

import com.xdja.cssp.as.api.Constants;
import com.xdja.platform.common.lite.kit.prop.Prop;
import com.xdja.platform.common.lite.kit.prop.PropKit;
import com.xdja.platform.remoting.serialize.Serialization;
import com.xdja.platform.rpc.consumer.IService;
import com.xdja.platform.rpc.consumer.Service;
import com.xdja.platform.rpc.consumer.ServicePool;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.stereotype.Component;

@Component
public class SystemInit
implements InitializingBean {
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    public void afterPropertiesSet() throws Exception {
        this.logger.info("\u5f00\u59cb\u6ce8\u518c\u7edf\u4e00\u8ba4\u8bc1RPC\u670d\u52a1");
        Prop systemProp = PropKit.use((String)"system.properties");
        String[] services = StringUtils.split((String)systemProp.get("rpc.services"), (String)"|");
        Service rpcService = null;
        for (String service : services) {
            rpcService = new Service();
            rpcService.setAddr(systemProp.get("rpc." + service + ".ip"));
            rpcService.setPort(Integer.parseInt(systemProp.get("rpc." + service + ".port")));
            if (systemProp.containsKey("rpc." + service + ".serialization")) {
                rpcService.setSerialization(Serialization.valueOf((String)systemProp.get("rpc." + service + ".serialization")));
            }
            if (systemProp.containsKey("rpc." + service + ".timeoutMillis")) {
                rpcService.setTimeoutMillis(Long.valueOf(systemProp.get("rpc." + service + ".timeoutMillis")).longValue());
            }
            ServicePool.addService((String)service, (IService)rpcService);
            this.logger.debug("\u6ce8\u518c\u666e\u901arpc service\uff08{}==>{}:{}\uff09\u6210\u529f", new Object[]{service, rpcService.getAddr(), rpcService.getPort()});
        }
        Prop configConfig = PropKit.use((String)"config.properties");
        Constants.TIMEOUT = configConfig.getLong("request.timeout", Long.valueOf(300000L));
        Constants.HOST_ID = configConfig.get("host.Id", "SERVER");
        Constants.API_VERSION = configConfig.get("api.version");
        this.logger.info("\u52a0\u8f7d\u7cfb\u7edf\u914d\u7f6e\u6587\u4ef6\u5b8c\u6210");
    }
}

