package com.xdja.cssp.as.service;

import com.xdja.cssp.as.service.model.AuthBean;
import com.xdja.cssp.as.service.model.ResultBean;
import com.xdja.platform.rpc.RemoteService;

/**
 * ticket认证服务相关接口
 * @author wyf
 *
 */
@RemoteService(serviceCode = AS.SERVICE_CODE)
public interface ITicketService {
	
	/**
	 * Ticket认证
	 * @param ticket 用户凭证
	 * @return 执行结果，1-有效；2-无效
	 */
	ResultBean verifyTicket(String ticket);
	
	/**
	 * RPC方式验证签名
	 * @author 马德成
	 * @date 2015年12月14日
	 * @param auth 凭证信息
	 * @return
	 */
	ResultBean authSignature(AuthBean auth);
	
}
