package com.xdja.cssp.as.service;

/**
 * 签名头信息常量
 * @author 马德成
 * @date 2015年11月27日
 */
public final class SignConst {

	/**
	 * HTTP消息头中签名算法标识 RSA
	 */
	public static final String HTTP_HEADER_SIGN_METHOD_RSA = "SHA1WITHRSA";
	/**
	 * HTTP消息头中签名算法标识 SM2
	 */
	public static final String HTTP_HEADER_SIGN_METHOD_SM2 = "SM3WITHSM2";
	
	/**
	 * HTTP消息头KEY 业务key开头
	 */
	public static final String HEADER_NAME_START = "x-pcs-";
	/**
	 * HTTP消息头KEY API版本号
	 */
	public static final String VERSION_HEADER_NAME = HEADER_NAME_START + "version";
	/**
	 * HTTP消息头KEY 终端签名证书sn
	 */
	public static final String SIGNATURE_SN_HEADER_NAME = HEADER_NAME_START + "signature-sn";
	/**
	 * HTTP消息头KEY 终端签名证书dn
	 */
	public static final String SIGNATURE_DN_HEADER_NAME = HEADER_NAME_START + "signature-dn";
	/**
	 * HTTP消息头KEY 签名方式
	 */
	public static final String SIGNATURE_METHOD_HEADER_NAME = HEADER_NAME_START + "signature-method";
	/**
	 * HTTP消息头KEY 请求的时间戳
	 */
	public static final String TIMESTAMP_HEADER_NAME = HEADER_NAME_START + "timestamp";
	/**
	 * HTTP消息头KEY 签名算法版本
	 */
	public static final String SIGNATURE_VERSION_HEADER_NAME = HEADER_NAME_START + "signature-version";
	/**
	 * HTTP消息头KEY 唯一随机数
	 */
	public static final String SIGNATURE_NONCE_HEADER_NAME = HEADER_NAME_START + "signature-nonce";
	/**
	 * HTTP消息头KEY 签名信息
	 */
	public static final String AUTHORIZATION_HEADER_NAME = "Authorization";
}
