package com.xdja.cssp.as.service.model;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

/**
 * @author 马德成
 * @date 2015年12月14日
 */
public class AuthBean implements Serializable {
	private static final long serialVersionUID = 1L;
	
	/**
	 * 请求方法,post,get等
	 */
	private String method;
	/**
	 * 请求地址,不包含项目名以及前面的地址
	 */
	private String uri;
	
	/**
	 * url参数
	 */
	private String queryString;
	
	/**
	 * 请求内容
	 */
	private byte[] content;
	
	/**
	 * API版本号
	 */
	private String version;
	/**
	 * 请求时间戳
	 */
	private String timestamp;
	/**
	 * 挑战值
	 */
	private String signatureNonce;
	/**
	 * 签名算法,rsa:SHA1WITHRSA, sm2:SM3WITHSM2
	 */
	private String signatureMethod;

	/**
	 * 签名信息
	 */
	private String authorization;

	/**
	 * 签名证书SN
	 */
	private String signatureSn;

	private List<SimpleHeader> list = new ArrayList<>();

	/**
	 * @return 获取 {@linkplain #version}
	 */
	public String getVersion() {
		return version;
	}

	/**
	 * @param version 设置 version
	 */
	public void setVersion(String version) {
		this.version = version;
	}

	/**
	 * @return 获取 {@linkplain #timestamp}
	 */
	public String getTimestamp() {
		return timestamp;
	}

	/**
	 * @param timestamp
	 *            设置 timestamp
	 */
	public void setTimestamp(String timestamp) {
		this.timestamp = timestamp;
	}

	/**
	 * @return 获取 {@linkplain #signatureNonce}
	 */
	public String getSignatureNonce() {
		return signatureNonce;
	}

	/**
	 * @param signatureNonce
	 *            设置 signatureNonce
	 */
	public void setSignatureNonce(String signatureNonce) {
		this.signatureNonce = signatureNonce;
	}

	/**
	 * @return 获取 {@linkplain #signatureMethod}
	 */
	public String getSignatureMethod() {
		return signatureMethod;
	}

	/**
	 * @param signatureMethod
	 *            设置 signatureMethod
	 */
	public void setSignatureMethod(String signatureMethod) {
		this.signatureMethod = signatureMethod;
	}

	/**
	 * @return 获取 {@linkplain #authorization}
	 */
	public String getAuthorization() {
		return authorization;
	}

	/**
	 * @param authorization
	 *            设置 authorization
	 */
	public void setAuthorization(String authorization) {
		this.authorization = authorization;
	}

	/**
	 * @return 获取 {@linkplain #signatureSn}
	 */
	public String getSignatureSn() {
		return signatureSn;
	}

	/**
	 * @param signatureSn
	 *            设置 signatureSn
	 */
	public void setSignatureSn(String signatureSn) {
		this.signatureSn = signatureSn;
	}

	/**
	 * @return 获取 {@linkplain #list}
	 */
	public List<SimpleHeader> getList() {
		return list;
	}

	/**
	 * @param list
	 *            设置 list
	 */
	public void setList(List<SimpleHeader> list) {
		this.list = list;
	}

	/**
	 * @return 获取 {@linkplain #method}
	 */
	public String getMethod() {
		return method;
	}

	/**
	 * @param method
	 *            设置 method
	 */
	public void setMethod(String method) {
		this.method = method;
	}

	/**
	 * @return 获取 {@linkplain #uri}
	 */
	public String getUri() {
		return uri;
	}

	/**
	 * @param uri 设置 uri
	 */
	public void setUri(String uri) {
		this.uri = uri;
	}

	
	/**
	 * @return 获取 {@linkplain #queryString}
	 */
	public String getQueryString() {
		return queryString;
	}

	/**
	 * @param queryString 设置 queryString
	 */
	public void setQueryString(String queryString) {
		this.queryString = queryString;
	}

	
	/**
	 * @return 获取 {@linkplain #content}
	 */
	public byte[] getContent() {
		return content;
	}

	/**
	 * @param content 设置 content
	 */
	public void setContent(byte[] content) {
		this.content = content;
	}

	@Override
	public String toString() {
		return "AuthBean [method=" + method + ", uri=" + uri + ", queryString=" + queryString + ", content="
				+ Arrays.toString(content) + ", version=" + version + ", timestamp=" + timestamp + ", signatureNonce="
				+ signatureNonce + ", signatureMethod=" + signatureMethod + ", authorization=" + authorization
				+ ", signatureSn=" + signatureSn + ", list=" + list + "]";
	}

}
