package com.xdja.cssp.as.service.model;

import java.io.Serializable;

/**
 * 证书信息
 * @author wyf
 *
 */
public class Cert implements Serializable {

	private static final long serialVersionUID = 1L;
	
	/**
	 * 卡号
	 */
	private String cardNo;
	/**
	 * 证书SN
	 */
	private String sn;
	/**
	 * 证书算法；1-RSA，2-SM2
	 */
	private int caAlg;
	/**
	 * 证书类型；1-加密证书，2-签名证书
	 */
	private int certType;
	/**
	 * 公钥信息
	 */
	private String cert;

	public String getCardNo() {
		return cardNo;
	}

	public void setCardNo(String cardNo) {
		this.cardNo = cardNo;
	}

	public String getSn() {
		return sn;
	}

	public void setSn(String sn) {
		this.sn = sn;
	}

	public int getCaAlg() {
		return caAlg;
	}

	public void setCaAlg(int caAlg) {
		this.caAlg = caAlg;
	}

	public int getCertType() {
		return certType;
	}

	public void setCertType(int certType) {
		this.certType = certType;
	}

	public String getCert() {
		return cert;
	}

	public void setCert(String cert) {
		this.cert = cert;
	}
	
	/**
	 * 
	 * 证书算法
	 * @date 2015-2-5
	 * @author rrx
	 *
	 */
	public enum CaAlg {
		/**
		 * 1-RSA
		 */
		RSA(1), 
		/**
		 * 2-SM2
		 */
		SM2(2);
		
		public int value;
		
		private CaAlg(int value) {
			this.value = value;
		}
		
		/**
		 * 
		 * 获取value指定的证书算法枚举
		 * @param value 证书算法枚举值
		 * @return
		 * @throws IllegalArgumentException
		 */
		public static CaAlg valueOf(int value) throws IllegalArgumentException {
			for (CaAlg type : CaAlg.values()) {
				if (type.value == value) return type;
			}
			
			throw new IllegalArgumentException(String.format("值\"%d\"对应的枚举值不存在", value));
		}
	}
	
	/**
	 * 
	 * 证书类型
	 * @date 2015-2-5
	 * @author rrx
	 *
	 */
	public enum CertType {
		/**
		 * 1-加密证书
		 */
		ENCRYPT(1), 
		/**
		 * 2-签名证书
		 */
		SIGN(2),
		/**
		 * 3-单证书
		 */
		SINGLE(3);

		public int value;
		
		private CertType(int value) {
			this.value = value;
		}
		
		/**
		 * 
		 * 获取value指定的证书类型枚举
		 * @param value 证书类型枚举值
		 * @return
		 * @throws IllegalArgumentException
		 */
		public static CertType valueOf(int value) throws IllegalArgumentException {
			for (CertType type : CertType.values()) {
				if (type.value == value) return type;
			}
			
			throw new IllegalArgumentException(String.format("值\"%d\"对应的枚举值不存在", value));
		}
	}
}
