package com.xdja.cssp.as.service.model;

import java.io.Serializable;

/**
 * 客户端登录请求Bean
 * @author wyf
 *
 */
public class ClientLoginReq implements Serializable {

	private static final long serialVersionUID = 1L;
	
	/**
	 * 客户端类型，1-android；2-ios；3-PC，4-其他<br />
	 * <b>说明：单客户端登录接口 该属性适用以上含义描述；<br />
	 * 		多客户端登录、多类型客户端综合登录接口该属性适用以下描述;<br />
	 * 		客户端类型；1-手机，2-平板；3-PC，4-其他，5-车载</b>
	 */
	private Integer clientType;
	/**
	 * 登录类型；1-芯片登录，2-TF卡登录，3-USBKey
	 */
	private Integer loginType;
	/**
	 * 客户端型号
	 */
	private String clientModel;
	/**
	 * 客户端操作系统名称<br />
	 * <b>说明：单客户端登录接口 为系统名称字符串<br />
	 * 		多客户端登录、多类型客户端综合登录接口该属性适用以下描述;<br />
	 * 		客户端类型；1-Android，2-IOS，3-Windows，4-MAC，5-其他</b>
	 */
	private String osName;
	/**
	 * 客户端操作系统版本号
	 */
	private String osVersion;
	/**
	 * 安通+客户端版本号
	 */
	private String clientVersion;
	/**
	 * 客户端唯一标识，必须能鉴别出终端
	 */
	private String resource;
	/**
	 * 推送标识
	 */
	private String pnToken; 
	/**
	 * 终端芯片卡号
	 */
	private String cardNo;
	/**
	 * 终端签名证书SN
	 */
	private String sn;
	/**
	 * 终端证书算法 1-RSA;2-SM2
	 */
	private int caAlg;

	public Integer getClientType() {
		return clientType;
	}

	public void setClientType(Integer clientType) {
		this.clientType = clientType;
	}

	public Integer getLoginType() {
		return loginType;
	}

	public void setLoginType(Integer loginType) {
		this.loginType = loginType;
	}

	public String getClientModel() {
		return clientModel;
	}

	public void setClientModel(String clientModel) {
		this.clientModel = clientModel;
	}

	public String getOsName() {
		return osName;
	}

	public void setOsName(String osName) {
		this.osName = osName;
	}

	public String getOsVersion() {
		return osVersion;
	}

	public void setOsVersion(String osVersion) {
		this.osVersion = osVersion;
	}

	public String getClientVersion() {
		return clientVersion;
	}

	public void setClientVersion(String clientVersion) {
		this.clientVersion = clientVersion;
	}

	public String getResource() {
		return resource;
	}

	public void setResource(String resource) {
		this.resource = resource;
	}

	public String getPnToken() {
		return pnToken;
	}

	public void setPnToken(String pnToken) {
		this.pnToken = pnToken;
	}

	public String getCardNo() {
		return cardNo;
	}

	public void setCardNo(String cardNo) {
		this.cardNo = cardNo;
	}

	public String getSn() {
		return sn;
	}

	public void setSn(String sn) {
		this.sn = sn;
	}

	public int getCaAlg() {
		return caAlg;
	}

	public void setCaAlg(int caAlg) {
		this.caAlg = caAlg;
	}

}
