package com.xdja.cssp.as.service.model;

import java.io.Serializable;

/**
 * @author 马德成
 * @date 2015年12月14日
 */
public class SimpleHeader implements Serializable, Comparable<SimpleHeader> {
	private static final long serialVersionUID = -4453492658775846887L;

	private final String name;
	private final String value;
	
	/**
	 * @param name
	 * @param value
	 */
	public SimpleHeader(String name, String value) {
		this.name = name;
		this.value = value;
	}

	/**
	 * @return 获取 {@linkplain #name}
	 */
	public String getName() {
		return name;
	}

	/**
	 * @return 获取 {@linkplain #value}
	 */
	public String getValue() {
		return value;
	}

	@Override
	public String toString() {
		return "SimpleHeader [name=" + name + ", value=" + value + "]";
	}

	@Override
	public int compareTo(SimpleHeader other) {
		return this.getName().compareTo(other.getName());
	}
}
