package com.xdja.cssp.as.service.util;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;

/**
 * 字节工具类
 * @author wyf
 *
 */
public class ByteUtils {

	private static int MAX_PKG_SIZE = 1024;
	
    /**
     * 将InputStream对象转化为byte,直到读到结束符为止
     * @throws IOException 
     */
	public static byte[] inputStreamToBytes(InputStream inputStream) throws Exception {
		ByteArrayOutputStream outputData = new ByteArrayOutputStream();
		byte[] buf = new byte[MAX_PKG_SIZE];
		int num;
		while ((num = inputStream.read(buf)) != -1) {
			outputData.write(buf, 0, num);
		}
		return outputData.toByteArray();
	}
}
