package com.xdja.cssp.as.service.util;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.security.Security;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.security.interfaces.ECPublicKey;
import java.security.interfaces.RSAPublicKey;

import org.bouncycastle.jce.provider.BouncyCastleProvider;

import sun.misc.BASE64Encoder;

import com.sun.org.apache.xerces.internal.impl.dv.util.Base64;

/**
 * 证书工具类
 * @author wyf
 *
 */
@SuppressWarnings("restriction")
public class CertUtil {
	
	public static final String CERT_HEAD = "-----BEGIN CERTIFICATE-----";
	public static final String CERT_TAIL = "-----END CERTIFICATE-----";
	
	static {
		Security.addProvider(new BouncyCastleProvider());
	}
	
	/**
	 * 从16进制字符串进行转换
	 * @param str
	 * @return
	 */
	public static X509Certificate getCertFromStr16(String str){
		byte[] bs = hex2byte(str);
		CertificateFactory cf = null;
		X509Certificate x509Cert = null;
		try {
			cf = CertificateFactory.getInstance("X.509", "BC");
			InputStream inStream = new ByteArrayInputStream(bs);
			x509Cert = (X509Certificate) cf.generateCertificate(inStream);
			return x509Cert;
		} catch (Exception e) {
			System.err.println("getCertFromFullStr error: " + e.toString());
		}
		return null;
	}
	/**
	 * 16进制字符串转换为二进制
	 * @param str String 类型参数
	 * @return
	 */
    public static byte[] hex2byte(String str) { 
        if (null == str ||str.equals("")){
        	return null;
        }
        str = str.trim();
        StringBuffer sb = new StringBuffer(str);
        int len = sb.length();
        if (len == 0 || len % 2 == 1){
        	return null;
        }
        byte[] b = new byte[len / 2];
        try {
        	for (int i = 0; i < len; i += 2) {
        		b[i / 2] = (byte) Integer.decode("0x" + sb.substring(i, i + 2)).intValue();
        	}
        	return b;
        } catch (Exception e) {
        	return null;
        }
    }
	
	/**
	 * 获取证书的公钥
	 * @param str 证书内容
	 * @param caAlg 算法；1-RSA；2-SM2
	 * @return	证书公钥
	 */
	public static String getPubKey(String str, int caAlg) {
		System.out.println("进入CertUtil->getPubKey: str:\n" + str);
		X509Certificate x509Cert = getCertFromStr(str);
		String pubKey = null;
		if (caAlg == 1) {
			RSAPublicKey rsa = (RSAPublicKey) x509Cert.getPublicKey();
			pubKey = rsa.getModulus().toString(16).toUpperCase();
		} else {
			ECPublicKey sm2 = (ECPublicKey) x509Cert.getPublicKey();
			pubKey = sm2.getW().getAffineX().toString(16) + "#"
					+ sm2.getW().getAffineY().toString(16);
		}
		return pubKey;
	}

	public static X509Certificate getCertFromStr(String str) {
		str = str.replace(CERT_HEAD, "").replace(CERT_TAIL, "");
		str = str.replace("\r", "").replace("\n", "");
		str = str.replace("\\r", "").replace("\\n", "");
		
		X509Certificate x509Cert = null;
		x509Cert = getCertFromB64(str);
		if (x509Cert == null) {
			x509Cert = getCertFromFullStr(str);
		}
		if(x509Cert == null){
			x509Cert = getCertFromStr16(str);
		}
		return x509Cert;
	}
	
	public static X509Certificate getCertFromFullStr(String str) {
		CertificateFactory cf = null;
		X509Certificate x509Cert = null;
		try {
			cf = CertificateFactory.getInstance("X.509", "BC");
			InputStream inStream = new ByteArrayInputStream(str.getBytes());
			x509Cert = (X509Certificate) cf.generateCertificate(inStream);
			return x509Cert;
		} catch (Exception e) {
			System.err.println("getCertFromFullStr error: " + e.toString());
		}
		return null;
	}

	public synchronized static X509Certificate getCertFromB64(String b64) {
		CertificateFactory cf = null;
		X509Certificate x509Cert = null;
		try {
			cf = CertificateFactory.getInstance("X.509", "BC");
			byte[] bsCert = Base64.decode(b64);
			InputStream inStream = new ByteArrayInputStream(bsCert);
			x509Cert = (X509Certificate) cf.generateCertificate(inStream);
			return x509Cert;
		} catch (Exception e) {
			System.err.println("getCertFromB64 error: " + e.toString());
		}
		return null;
	}
	
	public static String getSub(String dn, String cn) {
		if (dn == null || dn.length() == 0 || cn == null || cn.length() == 0)
			return null;
		String[] items = dn.split(",");
		if (items == null || items.length == 0)
			return null;
		for (int i = 0; i < items.length; i++) {
			String[] item = items[i].split("=");

			if (item == null || item.length != 2)
				continue;

			for (int j = 0; j < item.length; j++) {
				item[j] = item[j].trim();
			}

			if (item[0].equalsIgnoreCase(cn))
				return item[1];
		}
		return null;
	}

	public static String[][] getItems(String dn) {
		if (dn == null || dn.length() == 0)
			return null;
		String[] items = dn.split(",");

		if (items == null || items.length == 0)
			return null;

		String[][] itemss = new String[items.length][2];

		for (int i = 0; i < items.length; i++) {
			String[] item = items[i].split("=");
			if (item == null || item.length != 2)
				return null;

			for (int j = 0; j < item.length; j++) {
				itemss[i][j] = item[j].trim();
			}
		}
		return itemss;
	}

	public static String getSn(X509Certificate cert) {
		return cert.getSerialNumber().toString(16).toLowerCase();
	}

	public static String getDn(X509Certificate cert) {
		String dn = cert.getSubjectX500Principal().getName();

		String[] items = dn.split(",");

		if (items.length == 4 && dn.toLowerCase().indexOf("cn=") > -1 && dn.toLowerCase().indexOf("ou=") > -1
				&& dn.toLowerCase().indexOf("o=") > -1 && dn.toLowerCase().indexOf("c=") > -1) {
			StringBuffer sb = new StringBuffer();
			sb.append("CN=");
			sb.append(getSub(dn, "cn"));
			sb.append(",OU=");
			sb.append(getSub(dn, "ou"));
			sb.append(",O=");
			sb.append(getSub(dn, "o"));
			sb.append(",C=");
			sb.append(getSub(dn, "c"));
			return sb.toString();
		} else {
			return dn;
		}
	}
	
	public static String certToFullB64(Certificate cert) {
        String certb64 = "";
        try {

            certb64 = bytesToFullB64(cert.getEncoded());

        } catch (Exception e) {
        	System.err.println("certToFullB64 error:" + e.toString());
        }
        return certb64;
    }
	
	public static String bytesToFullB64(byte[] certder) {
        String certb64 = null;
        try {
            BASE64Encoder encoder = new BASE64Encoder();

            certb64 = encoder.encode(certder);

            certb64 = CERT_HEAD + "\n" + certb64 + "\n" + CERT_TAIL + "\n";
            return certb64;
        } catch (Exception e) {
        	System.err.println("certDerToFullB64 error:" + e.toString());
        }
        return null;
    }
}
